package io.fabric8.kubernetes.client.extended.run;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface RunConfigFluent<A extends RunConfigFluent<A>> extends Fluent<A>{
  public String getName();
  public A withName(String name);
  public Boolean hasName();
  public String getImage();
  public A withImage(String image);
  public Boolean hasImage();
  public String getImagePullPolicy();
  public A withImagePullPolicy(String imagePullPolicy);
  public Boolean hasImagePullPolicy();
  public String getCommand();
  public A withCommand(String command);
  public Boolean hasCommand();
  public A addToArgs(int index,String item);
  public A setToArgs(int index,String item);
  public A addToArgs(java.lang.String... items);
  public A addAllToArgs(Collection<String> items);
  public A removeFromArgs(java.lang.String... items);
  public A removeAllFromArgs(Collection<String> items);
  public List<String> getArgs();
  public String getArg(int index);
  public String getFirstArg();
  public String getLastArg();
  public String getMatchingArg(Predicate<String> predicate);
  public Boolean hasMatchingArg(Predicate<String> predicate);
  public A withArgs(List<String> args);
  public A withArgs(java.lang.String... args);
  public Boolean hasArgs();
  public String getRestartPolicy();
  public A withRestartPolicy(String restartPolicy);
  public Boolean hasRestartPolicy();
  public String getServiceAccount();
  public A withServiceAccount(String serviceAccount);
  public Boolean hasServiceAccount();
  public A addToLabels(String key,String value);
  public A addToLabels(Map<String,String> map);
  public A removeFromLabels(String key);
  public A removeFromLabels(Map<String,String> map);
  public Map<String,String> getLabels();
  public <K,V>A withLabels(Map<String,String> labels);
  public Boolean hasLabels();
  public A addToEnv(String key,String value);
  public A addToEnv(Map<String,String> map);
  public A removeFromEnv(String key);
  public A removeFromEnv(Map<String,String> map);
  public Map<String,String> getEnv();
  public <K,V>A withEnv(Map<String,String> env);
  public Boolean hasEnv();
  public A addToLimits(String key,Quantity value);
  public A addToLimits(Map<String,Quantity> map);
  public A removeFromLimits(String key);
  public A removeFromLimits(Map<String,Quantity> map);
  public Map<String,Quantity> getLimits();
  public <K,V>A withLimits(Map<String,Quantity> limits);
  public Boolean hasLimits();
  public A addToRequests(String key,Quantity value);
  public A addToRequests(Map<String,Quantity> map);
  public A removeFromRequests(String key);
  public A removeFromRequests(Map<String,Quantity> map);
  public Map<String,Quantity> getRequests();
  public <K,V>A withRequests(Map<String,Quantity> requests);
  public Boolean hasRequests();
  public int getPort();
  public A withPort(int port);
  public Boolean hasPort();
  
}