package io.fabric8.kubernetes.client;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RequestConfigFluent<A extends RequestConfigFluent<A>> extends BaseFluent<A>{
  public RequestConfigFluent() {
  }
  public RequestConfigFluent(RequestConfig instance) {
    instance = (instance != null ? instance : new RequestConfig());

    if (instance != null) {
      this.withWatchReconnectLimit(instance.getWatchReconnectLimit());
      this.withWatchReconnectInterval(instance.getWatchReconnectInterval());
      this.withRequestTimeout(instance.getRequestTimeout());
      this.withScaleTimeout(instance.getScaleTimeout());
      this.withLoggingInterval(instance.getLoggingInterval());
      this.withRequestRetryBackoffLimit(instance.getRequestRetryBackoffLimit());
      this.withRequestRetryBackoffInterval(instance.getRequestRetryBackoffInterval());
      this.withUploadRequestTimeout(instance.getUploadRequestTimeout());
      this.withImpersonateUsername(instance.getImpersonateUsername());
      this.withImpersonateGroups(instance.getImpersonateGroups());
      this.withImpersonateExtras(instance.getImpersonateExtras());
      this.withWatchReconnectInterval(instance.getWatchReconnectInterval());
      this.withWatchReconnectLimit(instance.getWatchReconnectLimit());
      this.withUploadRequestTimeout(instance.getUploadRequestTimeout());
      this.withRequestRetryBackoffLimit(instance.getRequestRetryBackoffLimit());
      this.withRequestRetryBackoffInterval(instance.getRequestRetryBackoffInterval());
      this.withRequestTimeout(instance.getRequestTimeout());
      this.withScaleTimeout(instance.getScaleTimeout());
      this.withLoggingInterval(instance.getLoggingInterval());
    }
  }
  private String impersonateUsername;
  private List<String> impersonateGroups;
  private Map<String,List<String>> impersonateExtras;
  private int watchReconnectInterval;
  private int watchReconnectLimit;
  private int uploadRequestTimeout;
  private int requestRetryBackoffLimit;
  private int requestRetryBackoffInterval;
  private int requestTimeout;
  private long scaleTimeout;
  private int loggingInterval;
  public String getImpersonateUsername() {
    return this.impersonateUsername;
  }
  public A withImpersonateUsername(String impersonateUsername) {
    this.impersonateUsername=impersonateUsername; return (A) this;
  }
  public boolean hasImpersonateUsername() {
    return this.impersonateUsername != null;
  }
  public A withImpersonateGroups(java.lang.String... impersonateGroups) {
    if (this.impersonateGroups != null) {this.impersonateGroups.clear(); _visitables.remove("impersonateGroups"); }
    if (impersonateGroups != null) {for (String item :impersonateGroups){ this.addToImpersonateGroups(item);}} return (A) this;
  }
  public String[] getImpersonateGroups() {
    //This needs to work with primitives, so we use arrays.
int size = impersonateGroups != null ? impersonateGroups.size() : 0;
String[] result = new String[size];
if (size == 0) {
   return result;
}
int index = 0;
for (String item : impersonateGroups) {
    result[index++]=item;
}
return result;

  }
  public A addToImpersonateGroups(int index,String item) {
    if (this.impersonateGroups == null) {this.impersonateGroups = new ArrayList<String>();}
    this.impersonateGroups.add(index, item);
    return (A)this;
  }
  public A setToImpersonateGroups(int index,String item) {
    if (this.impersonateGroups == null) {this.impersonateGroups = new ArrayList<String>();}
    this.impersonateGroups.set(index, item); return (A)this;
  }
  public A addToImpersonateGroups(java.lang.String... items) {
    if (this.impersonateGroups == null) {this.impersonateGroups = new ArrayList<String>();}
    for (String item : items) {this.impersonateGroups.add(item);} return (A)this;
  }
  public A addAllToImpersonateGroups(Collection<String> items) {
    if (this.impersonateGroups == null) {this.impersonateGroups = new ArrayList<String>();}
    for (String item : items) {this.impersonateGroups.add(item);} return (A)this;
  }
  public A removeFromImpersonateGroups(java.lang.String... items) {
    if (this.impersonateGroups == null) return (A)this;
    for (String item : items) { this.impersonateGroups.remove(item);} return (A)this;
  }
  public A removeAllFromImpersonateGroups(Collection<String> items) {
    if (this.impersonateGroups == null) return (A)this;
    for (String item : items) { this.impersonateGroups.remove(item);} return (A)this;
  }
  public boolean hasImpersonateGroups() {
    return impersonateGroups != null && !impersonateGroups.isEmpty();
  }
  public A addToImpersonateExtras(String key,List<String> value) {
    if(this.impersonateExtras == null && key != null && value != null) { this.impersonateExtras = new LinkedHashMap(); }
    if(key != null && value != null) {this.impersonateExtras.put(key, value);} return (A)this;
  }
  public A addToImpersonateExtras(Map<String,List<String>> map) {
    if(this.impersonateExtras == null && map != null) { this.impersonateExtras = new LinkedHashMap(); }
    if(map != null) { this.impersonateExtras.putAll(map);} return (A)this;
  }
  public A removeFromImpersonateExtras(String key) {
    if(this.impersonateExtras == null) { return (A) this; }
    if(key != null && this.impersonateExtras != null) {this.impersonateExtras.remove(key);} return (A)this;
  }
  public A removeFromImpersonateExtras(Map<String,List<String>> map) {
    if(this.impersonateExtras == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.impersonateExtras != null){this.impersonateExtras.remove(key);}}} return (A)this;
  }
  public Map<String,List<String>> getImpersonateExtras() {
    return this.impersonateExtras;
  }
  public <K,V>A withImpersonateExtras(Map<String,List<String>> impersonateExtras) {
    if (impersonateExtras == null) { this.impersonateExtras =  null;} else {this.impersonateExtras = new LinkedHashMap(impersonateExtras);} return (A) this;
  }
  public boolean hasImpersonateExtras() {
    return this.impersonateExtras != null;
  }
  public int getWatchReconnectInterval() {
    return this.watchReconnectInterval;
  }
  public A withWatchReconnectInterval(int watchReconnectInterval) {
    this.watchReconnectInterval=watchReconnectInterval; return (A) this;
  }
  public boolean hasWatchReconnectInterval() {
    return true;
  }
  public int getWatchReconnectLimit() {
    return this.watchReconnectLimit;
  }
  public A withWatchReconnectLimit(int watchReconnectLimit) {
    this.watchReconnectLimit=watchReconnectLimit; return (A) this;
  }
  public boolean hasWatchReconnectLimit() {
    return true;
  }
  public int getUploadRequestTimeout() {
    return this.uploadRequestTimeout;
  }
  public A withUploadRequestTimeout(int uploadRequestTimeout) {
    this.uploadRequestTimeout=uploadRequestTimeout; return (A) this;
  }
  public boolean hasUploadRequestTimeout() {
    return true;
  }
  public int getRequestRetryBackoffLimit() {
    return this.requestRetryBackoffLimit;
  }
  public A withRequestRetryBackoffLimit(int requestRetryBackoffLimit) {
    this.requestRetryBackoffLimit=requestRetryBackoffLimit; return (A) this;
  }
  public boolean hasRequestRetryBackoffLimit() {
    return true;
  }
  public int getRequestRetryBackoffInterval() {
    return this.requestRetryBackoffInterval;
  }
  public A withRequestRetryBackoffInterval(int requestRetryBackoffInterval) {
    this.requestRetryBackoffInterval=requestRetryBackoffInterval; return (A) this;
  }
  public boolean hasRequestRetryBackoffInterval() {
    return true;
  }
  public int getRequestTimeout() {
    return this.requestTimeout;
  }
  public A withRequestTimeout(int requestTimeout) {
    this.requestTimeout=requestTimeout; return (A) this;
  }
  public boolean hasRequestTimeout() {
    return true;
  }
  public long getScaleTimeout() {
    return this.scaleTimeout;
  }
  public A withScaleTimeout(long scaleTimeout) {
    this.scaleTimeout=scaleTimeout; return (A) this;
  }
  public boolean hasScaleTimeout() {
    return true;
  }
  public int getLoggingInterval() {
    return this.loggingInterval;
  }
  public A withLoggingInterval(int loggingInterval) {
    this.loggingInterval=loggingInterval; return (A) this;
  }
  public boolean hasLoggingInterval() {
    return true;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RequestConfigFluent that = (RequestConfigFluent) o;
    if (!java.util.Objects.equals(impersonateUsername, that.impersonateUsername)) return false;

    if (!java.util.Objects.equals(impersonateGroups, that.impersonateGroups)) return false;

    if (!java.util.Objects.equals(impersonateExtras, that.impersonateExtras)) return false;

    if (watchReconnectInterval != that.watchReconnectInterval) return false;
    if (watchReconnectLimit != that.watchReconnectLimit) return false;
    if (uploadRequestTimeout != that.uploadRequestTimeout) return false;
    if (requestRetryBackoffLimit != that.requestRetryBackoffLimit) return false;
    if (requestRetryBackoffInterval != that.requestRetryBackoffInterval) return false;
    if (requestTimeout != that.requestTimeout) return false;
    if (scaleTimeout != that.scaleTimeout) return false;
    if (loggingInterval != that.loggingInterval) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(impersonateUsername,  impersonateGroups,  impersonateExtras,  watchReconnectInterval,  watchReconnectLimit,  uploadRequestTimeout,  requestRetryBackoffLimit,  requestRetryBackoffInterval,  requestTimeout,  scaleTimeout,  loggingInterval,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (impersonateUsername != null) { sb.append("impersonateUsername:"); sb.append(impersonateUsername + ","); }
    if (impersonateGroups != null && !impersonateGroups.isEmpty()) { sb.append("impersonateGroups:"); sb.append(impersonateGroups + ","); }
    if (impersonateExtras != null && !impersonateExtras.isEmpty()) { sb.append("impersonateExtras:"); sb.append(impersonateExtras + ","); }
    sb.append("watchReconnectInterval:"); sb.append(watchReconnectInterval + ",");
    sb.append("watchReconnectLimit:"); sb.append(watchReconnectLimit + ",");
    sb.append("uploadRequestTimeout:"); sb.append(uploadRequestTimeout + ",");
    sb.append("requestRetryBackoffLimit:"); sb.append(requestRetryBackoffLimit + ",");
    sb.append("requestRetryBackoffInterval:"); sb.append(requestRetryBackoffInterval + ",");
    sb.append("requestTimeout:"); sb.append(requestTimeout + ",");
    sb.append("scaleTimeout:"); sb.append(scaleTimeout + ",");
    sb.append("loggingInterval:"); sb.append(loggingInterval);
    sb.append("}");
    return sb.toString();
  }
  
}