package io.fabric8.kubernetes.client.extended.leaderelection;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.time.Duration;
import java.lang.String;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.Lock;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class LeaderElectionConfigFluent<A extends LeaderElectionConfigFluent<A>> extends BaseFluent<A>{
  public LeaderElectionConfigFluent() {
  }
  
  public LeaderElectionConfigFluent(LeaderElectionConfig instance) {
    this.copyInstance(instance);
  }
  private Lock lock;
  private Duration leaseDuration;
  private Duration renewDeadline;
  private Duration retryPeriod;
  private LeaderCallbacks leaderCallbacks;
  private boolean releaseOnCancel;
  private String name;
  
  protected void copyInstance(LeaderElectionConfig instance) {
    if (instance != null) {
        this.withLock(instance.getLock());
        this.withLeaseDuration(instance.getLeaseDuration());
        this.withRenewDeadline(instance.getRenewDeadline());
        this.withRetryPeriod(instance.getRetryPeriod());
        this.withLeaderCallbacks(instance.getLeaderCallbacks());
        this.withReleaseOnCancel(instance.isReleaseOnCancel());
        this.withName(instance.getName());
      }
  }
  
  public Lock getLock() {
    return this.lock;
  }
  
  public A withLock(Lock lock) {
    this.lock=lock; return (A) this;
  }
  
  public boolean hasLock() {
    return this.lock != null;
  }
  
  public Duration getLeaseDuration() {
    return this.leaseDuration;
  }
  
  public A withLeaseDuration(Duration leaseDuration) {
    this.leaseDuration=leaseDuration; return (A) this;
  }
  
  public boolean hasLeaseDuration() {
    return this.leaseDuration != null;
  }
  
  public Duration getRenewDeadline() {
    return this.renewDeadline;
  }
  
  public A withRenewDeadline(Duration renewDeadline) {
    this.renewDeadline=renewDeadline; return (A) this;
  }
  
  public boolean hasRenewDeadline() {
    return this.renewDeadline != null;
  }
  
  public Duration getRetryPeriod() {
    return this.retryPeriod;
  }
  
  public A withRetryPeriod(Duration retryPeriod) {
    this.retryPeriod=retryPeriod; return (A) this;
  }
  
  public boolean hasRetryPeriod() {
    return this.retryPeriod != null;
  }
  
  public LeaderCallbacks getLeaderCallbacks() {
    return this.leaderCallbacks;
  }
  
  public A withLeaderCallbacks(LeaderCallbacks leaderCallbacks) {
    this.leaderCallbacks=leaderCallbacks; return (A) this;
  }
  
  public boolean hasLeaderCallbacks() {
    return this.leaderCallbacks != null;
  }
  
  public boolean isReleaseOnCancel() {
    return this.releaseOnCancel;
  }
  
  public A withReleaseOnCancel(boolean releaseOnCancel) {
    this.releaseOnCancel=releaseOnCancel; return (A) this;
  }
  
  public boolean hasReleaseOnCancel() {
    return true;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    LeaderElectionConfigFluent that = (LeaderElectionConfigFluent) o;
    if (!java.util.Objects.equals(lock, that.lock)) return false;
  
    if (!java.util.Objects.equals(leaseDuration, that.leaseDuration)) return false;
  
    if (!java.util.Objects.equals(renewDeadline, that.renewDeadline)) return false;
  
    if (!java.util.Objects.equals(retryPeriod, that.retryPeriod)) return false;
  
    if (!java.util.Objects.equals(leaderCallbacks, that.leaderCallbacks)) return false;
  
    if (releaseOnCancel != that.releaseOnCancel) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(lock,  leaseDuration,  renewDeadline,  retryPeriod,  leaderCallbacks,  releaseOnCancel,  name,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (lock != null) { sb.append("lock:"); sb.append(lock + ","); }
    if (leaseDuration != null) { sb.append("leaseDuration:"); sb.append(leaseDuration + ","); }
    if (renewDeadline != null) { sb.append("renewDeadline:"); sb.append(renewDeadline + ","); }
    if (retryPeriod != null) { sb.append("retryPeriod:"); sb.append(retryPeriod + ","); }
    if (leaderCallbacks != null) { sb.append("leaderCallbacks:"); sb.append(leaderCallbacks + ","); }
    sb.append("releaseOnCancel:"); sb.append(releaseOnCancel + ",");
    if (name != null) { sb.append("name:"); sb.append(name); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withReleaseOnCancel() {
    return withReleaseOnCancel(true);
  }
  

}