package io.fabric8.kubernetes.client.extended.run;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RunConfigBuilder extends RunConfigFluentImpl<RunConfigBuilder> implements VisitableBuilder<RunConfig,RunConfigBuilder> {

    RunConfigFluent<?> fluent;
    Boolean validationEnabled;

    public RunConfigBuilder() { 
        this(true);
    }


    public RunConfigBuilder(Boolean validationEnabled) { 
        this.fluent = this; this.validationEnabled=validationEnabled;
    }


    public RunConfigBuilder(RunConfigFluent<?> fluent) { 
        this(fluent, true);
    }


    public RunConfigBuilder(RunConfigFluent<?> fluent,Boolean validationEnabled) { 
        this.fluent = fluent; this.validationEnabled=validationEnabled;
    }


    public RunConfigBuilder(RunConfigFluent<?> fluent,RunConfig instance) { 
        this(fluent, instance, true);
    }


    public RunConfigBuilder(RunConfigFluent<?> fluent,RunConfig instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withName(instance.getName()); 
        fluent.withImage(instance.getImage()); 
        fluent.withImagePullPolicy(instance.getImagePullPolicy()); 
        fluent.withCommand(instance.getCommand()); 
        fluent.withArgs(instance.getArgs()); 
        fluent.withRestartPolicy(instance.getRestartPolicy()); 
        fluent.withServiceAccount(instance.getServiceAccount()); 
        fluent.withLabels(instance.getLabels()); 
        fluent.withEnv(instance.getEnv()); 
        fluent.withLimits(instance.getLimits()); 
        fluent.withRequests(instance.getRequests()); 
        fluent.withPort(instance.getPort()); 
        this.validationEnabled = validationEnabled; 
    }


    public RunConfigBuilder(RunConfig instance) { 
        this(instance,true);
    }


    public RunConfigBuilder(RunConfig instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withName(instance.getName()); 
        this.withImage(instance.getImage()); 
        this.withImagePullPolicy(instance.getImagePullPolicy()); 
        this.withCommand(instance.getCommand()); 
        this.withArgs(instance.getArgs()); 
        this.withRestartPolicy(instance.getRestartPolicy()); 
        this.withServiceAccount(instance.getServiceAccount()); 
        this.withLabels(instance.getLabels()); 
        this.withEnv(instance.getEnv()); 
        this.withLimits(instance.getLimits()); 
        this.withRequests(instance.getRequests()); 
        this.withPort(instance.getPort()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.kubernetes.client.extended.run.EditableRunConfig build() {
        EditableRunConfig buildable = new EditableRunConfig(fluent.getName(),fluent.getImage(),fluent.getImagePullPolicy(),fluent.getCommand(),fluent.getArgs(),fluent.getRestartPolicy(),fluent.getServiceAccount(),fluent.getLabels(),fluent.getEnv(),fluent.getLimits(),fluent.getRequests(),fluent.getPort());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RunConfigBuilder that = (RunConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
