
                                          

package io.fabric8.kubernetes.client.handlers.apiextensions.v1beta1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.apiextensions.v1beta1.CustomResourceDefinitionOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class CustomResourceDefinitionHandler implements ResourceHandler<CustomResourceDefinition, CustomResourceDefinitionBuilder> {

  @Override
  public String getKind() {
    return CustomResourceDefinition.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "apiextensions.k8s.io/v1beta1";
      }

  @Override
  public CustomResourceDefinition create(OkHttpClient client, Config config, String namespace, CustomResourceDefinition item) {
    return new CustomResourceDefinitionOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public CustomResourceDefinition replace(OkHttpClient client, Config config, String namespace, CustomResourceDefinition item) {
    return new CustomResourceDefinitionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public CustomResourceDefinition reload(OkHttpClient client, Config config, String namespace, CustomResourceDefinition item) {
    return new CustomResourceDefinitionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public CustomResourceDefinitionBuilder edit(CustomResourceDefinition item) {
    return new CustomResourceDefinitionBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, CustomResourceDefinition item) {
    return new CustomResourceDefinitionOperationsImpl(client, config, namespace).withItem(item).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CustomResourceDefinition item, Watcher<CustomResourceDefinition> watcher) {
    return new CustomResourceDefinitionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CustomResourceDefinition item, String resourceVersion, Watcher<CustomResourceDefinition> watcher) {
    return new CustomResourceDefinitionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CustomResourceDefinition item, ListOptions options, Watcher<CustomResourceDefinition> watcher) {
    return new CustomResourceDefinitionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }

  @Override
  public CustomResourceDefinition waitUntilReady(OkHttpClient client, Config config, String namespace, CustomResourceDefinition item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new CustomResourceDefinitionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public CustomResourceDefinition waitUntilCondition(OkHttpClient client, Config config, String namespace, CustomResourceDefinition item, Predicate<CustomResourceDefinition> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new CustomResourceDefinitionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
