/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.okhttp;

import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.okhttp.OkHttpClientBuilderImpl;
import io.fabric8.kubernetes.client.okhttp.OkHttpRequestImpl;
import io.fabric8.kubernetes.client.okhttp.OkHttpWebSocketImpl;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttpClientImpl
implements HttpClient {
    static final Map<String, MediaType> MEDIA_TYPES = new ConcurrentHashMap<String, MediaType>();
    public static final MediaType JSON = OkHttpClientImpl.parseMediaType("application/json");
    public static final MediaType JSON_PATCH = OkHttpClientImpl.parseMediaType("application/json-patch+json");
    public static final MediaType STRATEGIC_MERGE_JSON_PATCH = OkHttpClientImpl.parseMediaType("application/strategic-merge-patch+json");
    public static final MediaType JSON_MERGE_PATCH = OkHttpClientImpl.parseMediaType("application/merge-patch+json");
    private final OkHttpClient httpClient;

    static MediaType parseMediaType(String contentType) {
        MediaType result = MediaType.parse((String)contentType);
        MEDIA_TYPES.put(contentType, result);
        return result;
    }

    public OkHttpClientImpl(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public void close() {
        ExecutorService executorService;
        ConnectionPool connectionPool = this.httpClient.connectionPool();
        Dispatcher dispatcher = this.httpClient.dispatcher();
        ExecutorService executorService2 = executorService = this.httpClient.dispatcher() != null ? this.httpClient.dispatcher().executorService() : null;
        if (dispatcher != null) {
            dispatcher.cancelAll();
        }
        if (connectionPool != null) {
            connectionPool.evictAll();
        }
        if (executorService != null) {
            executorService.shutdownNow();
        }
    }

    @Override
    public <T> HttpResponse<T> send(HttpRequest request, Class<T> type) throws IOException {
        return new OkHttpResponseImpl<T>(this.httpClient.newCall(((OkHttpRequestImpl)request).getRequest()).execute(), type);
    }

    @Override
    public HttpClient.Builder newBuilder() {
        return new OkHttpClientBuilderImpl(this.httpClient.newBuilder());
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, final Class<T> type) {
        final CompletableFuture future = new CompletableFuture();
        Call call = this.httpClient.newCall(((OkHttpRequestImpl)request).getRequest());
        call.enqueue(new Callback(){

            public void onResponse(Call call, Response response) throws IOException {
                future.complete(new OkHttpResponseImpl(response, type));
            }

            public void onFailure(Call call, IOException e) {
                future.completeExceptionally(e);
            }
        });
        future.whenComplete((r, t) -> {
            if (future.isCancelled()) {
                call.cancel();
            }
        });
        return future;
    }

    @Override
    public WebSocket.Builder newWebSocketBuilder() {
        return new OkHttpWebSocketImpl.BuilderImpl(this.httpClient);
    }

    public OkHttpClient getOkHttpClient() {
        return this.httpClient;
    }

    @Override
    public HttpRequest.Builder newHttpRequestBuilder() {
        return new OkHttpRequestImpl.BuilderImpl();
    }

    static class OkHttpResponseImpl<T>
    implements HttpResponse<T> {
        private final Response response;
        private T body;
        private Class<T> type;

        public OkHttpResponseImpl(Response response, Class<T> type) throws IOException {
            this.response = response;
            this.type = type;
            ResponseBody responseBody = response.body();
            if (responseBody != null) {
                if (type == null) {
                    responseBody.close();
                } else {
                    this.body = type == String.class ? responseBody.string() : (type == Reader.class ? responseBody.charStream() : responseBody.byteStream());
                }
            }
        }

        @Override
        public int code() {
            return this.response.code();
        }

        @Override
        public T body() {
            return this.body;
        }

        @Override
        public HttpRequest request() {
            return new OkHttpRequestImpl(this.response.request());
        }

        @Override
        public Optional<HttpResponse<T>> previousResponse() {
            Response previous = this.response.priorResponse() != null ? this.response.priorResponse() : this.response;
            previous = previous.networkResponse() != null ? previous.networkResponse() : previous;
            try {
                return Optional.ofNullable(previous == this.response ? null : new OkHttpResponseImpl<T>(previous, this.type));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public List<String> headers(String key) {
            return this.response.headers(key);
        }
    }
}

