
                                          
  

package io.fabric8.kubernetes.client.dsl.internal.rbac.v1;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingBuilder;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingList;

import java.util.Map;
import java.util.TreeMap;


public class ClusterRoleBindingOperationsImpl extends HasMetadataOperation<ClusterRoleBinding, ClusterRoleBindingList, Resource<ClusterRoleBinding>> {

  public ClusterRoleBindingOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public ClusterRoleBindingOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ClusterRoleBindingOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("rbac.authorization.k8s.io")
    .withApiGroupVersion("v1")
    .withPlural("clusterrolebindings"));
    this.type = ClusterRoleBinding.class;
    this.listType = ClusterRoleBindingList.class;
  }

  public ClusterRoleBindingOperationsImpl newInstance(OperationContext context) {
    return new ClusterRoleBindingOperationsImpl(context);
  }

  @Override
  public ClusterRoleBinding edit(Visitor... visitors) {
    return patch(new ClusterRoleBindingBuilder(getMandatory()).accept(visitors).build());
  }

  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
