
                                          

package io.fabric8.kubernetes.client.handlers.discovery.v1beta1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.discovery.v1beta1.EndpointSliceOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSlice;
import io.fabric8.kubernetes.api.model.discovery.v1beta1.EndpointSliceBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class EndpointSliceHandler implements ResourceHandler<EndpointSlice, EndpointSliceBuilder> {

  @Override
  public String getKind() {
    return EndpointSlice.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "discovery.k8s.io/v1beta1";
      }

  @Override
  public EndpointSlice create(OkHttpClient client, Config config, String namespace, EndpointSlice item, boolean dryRun) {
    return new EndpointSliceOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public EndpointSlice replace(OkHttpClient client, Config config, String namespace, EndpointSlice item, boolean dryRun) {
    return new EndpointSliceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public EndpointSlice reload(OkHttpClient client, Config config, String namespace, EndpointSlice item) {
    return new EndpointSliceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public EndpointSliceBuilder edit(EndpointSlice item) {
    return new EndpointSliceBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, EndpointSlice item, boolean dryRun) {
    return new EndpointSliceOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

@Override
  public Watch watch(OkHttpClient client, Config config, String namespace, EndpointSlice item, Watcher<EndpointSlice> watcher) {
    return new EndpointSliceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, EndpointSlice item, String resourceVersion, Watcher<EndpointSlice> watcher) {
    return new EndpointSliceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, EndpointSlice item, ListOptions options, Watcher<EndpointSlice> watcher) {
    return new EndpointSliceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }

  @Override
  public EndpointSlice waitUntilReady(OkHttpClient client, Config config, String namespace, EndpointSlice item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new EndpointSliceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public EndpointSlice waitUntilCondition(OkHttpClient client, Config config, String namespace, EndpointSlice item, Predicate<EndpointSlice> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new EndpointSliceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
