
                                          

package io.fabric8.kubernetes.client.handlers.storage.v1beta1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.storage.v1beta1.CSINodeOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSINode;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class CSINodeHandler implements ResourceHandler<CSINode, CSINodeBuilder> {

  @Override
  public String getKind() {
    return CSINode.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "storage.k8s.io/v1beta1";
      }

  @Override
  public CSINode create(OkHttpClient client, Config config, String namespace, CSINode item, boolean dryRun) {
    return new CSINodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public CSINode replace(OkHttpClient client, Config config, String namespace, CSINode item, boolean dryRun) {
    return new CSINodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public CSINode reload(OkHttpClient client, Config config, String namespace, CSINode item) {
    return new CSINodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public CSINodeBuilder edit(CSINode item) {
    return new CSINodeBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, CSINode item, boolean dryRun) {
    return new CSINodeOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

@Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CSINode item, Watcher<CSINode> watcher) {
    return new CSINodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CSINode item, String resourceVersion, Watcher<CSINode> watcher) {
    return new CSINodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CSINode item, ListOptions options, Watcher<CSINode> watcher) {
    return new CSINodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }

  @Override
  public CSINode waitUntilReady(OkHttpClient client, Config config, String namespace, CSINode item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new CSINodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public CSINode waitUntilCondition(OkHttpClient client, Config config, String namespace, CSINode item, Predicate<CSINode> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new CSINodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
