/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.client.LocalPortForward;
import io.fabric8.kubernetes.client.PortForward;
import io.fabric8.kubernetes.client.dsl.internal.PortForwarder;
import io.fabric8.kubernetes.client.dsl.internal.PortForwarderWebsocketListener;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortForwarderWebsocket
implements PortForwarder {
    private static final Logger LOG = LoggerFactory.getLogger(PortForwarderWebsocket.class);
    private final HttpClient client;
    private final Executor executor;

    public PortForwarderWebsocket(HttpClient client, Executor executor) {
        this.client = client;
        this.executor = executor;
    }

    @Override
    public LocalPortForward forward(URL resourceBaseUrl, int port) {
        return this.forward(resourceBaseUrl, port, 0);
    }

    @Override
    public LocalPortForward forward(URL resourceBaseUrl, int port, int localPort) {
        return this.forward(resourceBaseUrl, port, null, localPort);
    }

    @Override
    public LocalPortForward forward(URL resourceBaseUrl, int port, InetAddress localHost, int localPort) {
        try {
            InetSocketAddress inetSocketAddress = this.createNewInetSocketAddress(localHost, localPort);
            final ServerSocketChannel server = ServerSocketChannel.open().bind(inetSocketAddress);
            final AtomicBoolean alive = new AtomicBoolean(true);
            final CopyOnWriteArrayList handles = new CopyOnWriteArrayList();
            final ExecutorService executorService = Executors.newSingleThreadExecutor();
            LocalPortForward localPortForwardHandle = new LocalPortForward(){

                @Override
                public void close() throws IOException {
                    alive.set(false);
                    try {
                        server.close();
                    }
                    finally {
                        Utils.closeQuietly(handles);
                        executorService.shutdownNow();
                    }
                }

                @Override
                public boolean isAlive() {
                    return alive.get();
                }

                @Override
                public boolean errorOccurred() {
                    for (PortForward handle : handles) {
                        if (!handle.errorOccurred()) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public InetAddress getLocalAddress() {
                    try {
                        return ((InetSocketAddress)server.getLocalAddress()).getAddress();
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Cannot determine local address", e);
                    }
                }

                @Override
                public int getLocalPort() {
                    try {
                        return ((InetSocketAddress)server.getLocalAddress()).getPort();
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Cannot determine local address", e);
                    }
                }

                @Override
                public Collection<Throwable> getClientThrowables() {
                    ArrayList<Throwable> clientThrowables = new ArrayList<Throwable>();
                    for (PortForward handle : handles) {
                        clientThrowables.addAll(handle.getClientThrowables());
                    }
                    return clientThrowables;
                }

                @Override
                public Collection<Throwable> getServerThrowables() {
                    ArrayList<Throwable> serverThrowables = new ArrayList<Throwable>();
                    for (PortForward handle : handles) {
                        serverThrowables.addAll(handle.getServerThrowables());
                    }
                    return serverThrowables;
                }
            };
            executorService.execute(() -> {
                while (alive.get()) {
                    try {
                        SocketChannel socket = server.accept();
                        handles.add(this.forward(resourceBaseUrl, port, socket, socket));
                    }
                    catch (IOException e) {
                        if (alive.get()) {
                            LOG.error("Error while listening for connections", (Throwable)e);
                        }
                        Utils.closeQuietly(localPortForwardHandle);
                    }
                }
            });
            return localPortForwardHandle;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to port forward", e);
        }
    }

    @Override
    public PortForward forward(URL resourceBaseUrl, int port, ReadableByteChannel in, WritableByteChannel out) {
        final PortForwarderWebsocketListener listener = new PortForwarderWebsocketListener(in, out, this.executor);
        final CompletableFuture<WebSocket> socket = this.client.newWebSocketBuilder().uri(URI.create(URLUtils.join(resourceBaseUrl.toString(), "portforward?ports=" + port))).buildAsync(listener);
        socket.whenComplete((w, t) -> {
            if (t != null) {
                listener.onError((WebSocket)w, (Throwable)t);
            }
        });
        return new PortForward(){

            @Override
            public void close() {
                socket.cancel(true);
                socket.whenComplete((w, t) -> {
                    if (w != null) {
                        w.sendClose(1001, "User closing");
                    }
                });
            }

            @Override
            public boolean isAlive() {
                return listener.isAlive();
            }

            @Override
            public boolean errorOccurred() {
                return listener.errorOccurred();
            }

            @Override
            public Collection<Throwable> getClientThrowables() {
                return listener.getClientThrowables();
            }

            @Override
            public Collection<Throwable> getServerThrowables() {
                return listener.getServerThrowables();
            }
        };
    }

    InetSocketAddress createNewInetSocketAddress(InetAddress localHost, int localPort) {
        if (localHost == null) {
            return new InetSocketAddress(localPort);
        }
        return new InetSocketAddress(localHost, localPort);
    }
}

