/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.extensions.v1beta1;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentList;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollback;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetList;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.client.dsl.BytesLimitTerminateTimeTailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.Loggable;
import io.fabric8.kubernetes.client.dsl.PrettyLoggable;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.TailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TimeTailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.RollableScalableResourceOperation;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.RollingUpdater;
import io.fabric8.kubernetes.client.dsl.internal.extensions.v1beta1.ReplicaSetOperationsImpl;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentOperationsImpl
extends RollableScalableResourceOperation<Deployment, DeploymentList, RollableScalableResource<Deployment>>
implements TimeoutImageEditReplacePatchable<Deployment> {
    static final transient Logger LOG = LoggerFactory.getLogger(DeploymentOperationsImpl.class);
    public static final String DEPLOYMENT_KUBERNETES_IO_REVISION = "deployment.kubernetes.io/revision";

    public DeploymentOperationsImpl(Client client) {
        this(new PodOperationContext(), HasMetadataOperationsImpl.defaultContext(client));
    }

    public DeploymentOperationsImpl(PodOperationContext context, OperationContext superContext) {
        super(context, superContext.withApiGroupName("extensions").withApiGroupVersion("v1beta1").withPlural("deployments"), Deployment.class, DeploymentList.class);
    }

    @Override
    public DeploymentOperationsImpl newInstance(OperationContext context) {
        return new DeploymentOperationsImpl(this.rollingOperationContext, context);
    }

    public DeploymentOperationsImpl newInstance(PodOperationContext context, OperationContext superContext) {
        return new DeploymentOperationsImpl(context, superContext);
    }

    @Override
    public Deployment scale(int count, boolean wait) {
        Deployment res = this.accept((T d) -> d.getSpec().setReplicas(Integer.valueOf(count)));
        if (wait) {
            this.waitUntilDeploymentIsScaled(count);
            res = (Deployment)this.getMandatory();
        }
        return res;
    }

    @Override
    public Status rollback(DeploymentRollback rollback) {
        return this.handleDeploymentRollback(rollback);
    }

    @Override
    public RollingUpdater<Deployment, DeploymentList> getRollingUpdater(long rollingTimeout, TimeUnit rollingTimeUnit) {
        return null;
    }

    @Override
    public Deployment withReplicas(int count) {
        return this.accept((T d) -> d.getSpec().setReplicas(Integer.valueOf(count)));
    }

    @Override
    public int getCurrentReplicas(Deployment current) {
        return current.getStatus().getReplicas();
    }

    @Override
    public int getDesiredReplicas(Deployment item) {
        return item.getSpec().getReplicas();
    }

    @Override
    public long getObservedGeneration(Deployment current) {
        return current != null && current.getStatus() != null && current.getStatus().getObservedGeneration() != null ? current.getStatus().getObservedGeneration() : -1L;
    }

    @Override
    public Deployment resume() {
        return RollingUpdater.resume(this);
    }

    @Override
    public Deployment pause() {
        return RollingUpdater.pause(this);
    }

    @Override
    public Deployment restart() {
        return RollingUpdater.restart(this);
    }

    @Override
    public Deployment undo() {
        List replicaSets = this.getReplicaSetListForDeployment((Deployment)this.get()).getItems();
        replicaSets.sort((o1, o2) -> {
            String revisionO1 = (String)o1.getMetadata().getAnnotations().get(DEPLOYMENT_KUBERNETES_IO_REVISION);
            String revisionO2 = (String)o2.getMetadata().getAnnotations().get(DEPLOYMENT_KUBERNETES_IO_REVISION);
            return Integer.parseInt(revisionO2) - Integer.parseInt(revisionO1);
        });
        ReplicaSet latestReplicaSet = (ReplicaSet)replicaSets.get(0);
        ReplicaSet previousRevisionReplicaSet = (ReplicaSet)replicaSets.get(1);
        Deployment deployment = (Deployment)this.get();
        deployment.getMetadata().getAnnotations().put(DEPLOYMENT_KUBERNETES_IO_REVISION, latestReplicaSet.getMetadata().getAnnotations().get(DEPLOYMENT_KUBERNETES_IO_REVISION));
        deployment.getSpec().setTemplate(previousRevisionReplicaSet.getSpec().getTemplate());
        return this.sendPatchedObject(this.get(), deployment);
    }

    private void waitUntilDeploymentIsScaled(int count) {
        AtomicReference<Integer> replicasRef = new AtomicReference<Integer>(0);
        String name = this.checkName(this.getItem());
        String namespace = this.checkNamespace(this.getItem());
        try {
            this.waitUntilCondition((T deployment) -> {
                long observedGeneration;
                if (deployment == null) {
                    if (count == 0) {
                        return true;
                    }
                    throw new IllegalStateException("Can't wait for Deployment: " + this.checkName(this.getItem()) + " in namespace: " + this.checkName(this.getItem()) + " to scale. Resource is no longer available.");
                }
                replicasRef.set(deployment.getStatus().getReplicas());
                int currentReplicas = deployment.getStatus().getReplicas() != null ? deployment.getStatus().getReplicas() : 0;
                long generation = deployment.getMetadata().getGeneration() != null ? deployment.getMetadata().getGeneration() : 0L;
                long l = observedGeneration = deployment.getStatus() != null && deployment.getStatus().getObservedGeneration() != null ? deployment.getStatus().getObservedGeneration() : -1L;
                if (observedGeneration >= generation && Objects.equals(deployment.getSpec().getReplicas(), currentReplicas)) {
                    return true;
                }
                LOG.debug("Only {}/{} pods scheduled for Deployment: {} in namespace: {} seconds so waiting...", new Object[]{deployment.getStatus().getReplicas(), deployment.getSpec().getReplicas(), deployment.getMetadata().getName(), namespace});
                return false;
            }, this.getConfig().getScaleTimeout(), TimeUnit.MILLISECONDS);
            LOG.debug("{}/{} pod(s) ready for Deployment: {} in namespace: {}.", new Object[]{replicasRef.get(), count, name, namespace});
        }
        catch (KubernetesClientTimeoutException e) {
            LOG.error("{}/{} pod(s) ready for Deployment: {} in namespace: {}  after waiting for {} seconds so giving up", new Object[]{replicasRef.get(), count, name, namespace, TimeUnit.MILLISECONDS.toSeconds(this.getConfig().getScaleTimeout())});
        }
    }

    @Override
    public String getLog(boolean isPretty) {
        StringBuilder stringBuilder = new StringBuilder();
        List<RollableScalableResource<ReplicaSet>> rcList = this.doGetLog();
        for (RollableScalableResource<ReplicaSet> rcOperation : rcList) {
            stringBuilder.append(rcOperation.getLog(isPretty));
        }
        return stringBuilder.toString();
    }

    private List<RollableScalableResource<ReplicaSet>> doGetLog() {
        ArrayList<RollableScalableResource<ReplicaSet>> rcs = new ArrayList<RollableScalableResource<ReplicaSet>>();
        Deployment deployment = (Deployment)this.requireFromServer();
        String rcUid = deployment.getMetadata().getUid();
        ReplicaSetOperationsImpl rsOperations = new ReplicaSetOperationsImpl(this.rollingOperationContext, this.context.withName(null));
        ReplicaSetList rcList = (ReplicaSetList)rsOperations.withLabels((Map)DeploymentOperationsImpl.getDeploymentSelectorLabels(deployment)).list();
        for (ReplicaSet rs : rcList.getItems()) {
            OwnerReference ownerReference = KubernetesResourceUtil.getControllerUid((HasMetadata)rs);
            if (ownerReference == null || !ownerReference.getUid().equals(rcUid)) continue;
            rcs.add((RollableScalableResource<ReplicaSet>)rsOperations.withName(rs.getMetadata().getName()));
        }
        return rcs;
    }

    @Override
    public Reader getLogReader() {
        return this.findFirstPodResource().map(Loggable::getLogReader).orElse(null);
    }

    @Override
    public InputStream getLogInputStream() {
        return this.findFirstPodResource().map(Loggable::getLogInputStream).orElse(null);
    }

    @Override
    public LogWatch watchLog(OutputStream out) {
        return this.findFirstPodResource().map(it -> it.watchLog(out)).orElse(null);
    }

    private Optional<RollableScalableResource<ReplicaSet>> findFirstPodResource() {
        List<RollableScalableResource<ReplicaSet>> podResources = this.doGetLog();
        if (!podResources.isEmpty()) {
            if (podResources.size() > 1) {
                LOG.debug("Found {} pods, Using first one to get log", (Object)podResources.size());
            }
            return Optional.of(podResources.get(0));
        }
        return Optional.empty();
    }

    private ReplicaSetList getReplicaSetListForDeployment(Deployment deployment) {
        return (ReplicaSetList)((BaseOperation)new ReplicaSetOperationsImpl(this.context.getClient()).inNamespace(this.getNamespace())).withLabels(deployment.getSpec().getSelector().getMatchLabels()).list();
    }

    static Map<String, String> getDeploymentSelectorLabels(Deployment deployment) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (deployment != null && deployment.getSpec() != null && deployment.getSpec().getTemplate() != null && deployment.getSpec().getTemplate().getMetadata() != null) {
            labels.putAll(deployment.getSpec().getTemplate().getMetadata().getLabels());
        }
        return labels;
    }

    @Override
    protected List<Container> getContainers(Deployment value) {
        return value.getSpec().getTemplate().getSpec().getContainers();
    }

    @Override
    public TimeTailPrettyLoggable limitBytes(int limitBytes) {
        return new DeploymentOperationsImpl(this.rollingOperationContext.withLimitBytes(limitBytes), this.context);
    }

    @Override
    public TimeTailPrettyLoggable terminated() {
        return new DeploymentOperationsImpl(this.rollingOperationContext.withTerminatedStatus(true), this.context);
    }

    @Override
    public Loggable withPrettyOutput() {
        return new DeploymentOperationsImpl(this.rollingOperationContext.withPrettyOutput(true), this.context);
    }

    @Override
    public PrettyLoggable tailingLines(int lines) {
        return new DeploymentOperationsImpl(this.rollingOperationContext.withTailingLines(lines), this.context);
    }

    @Override
    public TailPrettyLoggable sinceTime(String timestamp) {
        return new DeploymentOperationsImpl(this.rollingOperationContext.withSinceTimestamp(timestamp), this.context);
    }

    @Override
    public TailPrettyLoggable sinceSeconds(int seconds) {
        return new DeploymentOperationsImpl(this.rollingOperationContext.withSinceSeconds(seconds), this.context);
    }

    @Override
    public BytesLimitTerminateTimeTailPrettyLoggable usingTimestamps() {
        return new DeploymentOperationsImpl(this.rollingOperationContext.withTimestamps(true), this.context);
    }
}

