/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.autoscaling.v1.Scale;
import io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleFluent;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.PatchContext;
import io.fabric8.kubernetes.client.dsl.base.PatchType;
import io.fabric8.kubernetes.client.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.utils.IOHelpers;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HasMetadataOperation<T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>>
extends BaseOperation<T, L, R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HasMetadataOperation.class);
    public static final DeletionPropagation DEFAULT_PROPAGATION_POLICY = DeletionPropagation.BACKGROUND;
    public static final long DEFAULT_GRACE_PERIOD_IN_SECONDS = -1L;
    private static final String PATCH_OPERATION = "patch";
    private static final String REPLACE_OPERATION = "replace";
    private static final String UPDATE_OPERATION = "update";

    public HasMetadataOperation(OperationContext ctx, Class<T> type, Class<L> listType) {
        super(ctx);
        this.type = type;
        this.listType = listType;
    }

    @Override
    public T edit(UnaryOperator<T> function) {
        Object item = this.getItemOrRequireFromServer();
        Object clone = this.clone(item);
        return (T)this.patch(null, clone, (HasMetadata)function.apply(item));
    }

    private T clone(T item) {
        return (T)((HasMetadata)Serialization.clone(item));
    }

    @Override
    public T editStatus(UnaryOperator<T> function) {
        Object item = this.getItemOrRequireFromServer();
        Object clone = this.clone(item);
        return (T)this.statusSubresource().patch(null, (HasMetadata)clone, (HasMetadata)function.apply(item));
    }

    private HasMetadataOperation<T, L, R> statusSubresource() {
        return this.newInstance(this.context.withSubresource("status"));
    }

    @Override
    public T accept(Consumer<T> consumer) {
        Object item = this.getItemOrRequireFromServer();
        Object clone = this.clone(item);
        consumer.accept(item);
        return this.patch(null, clone, item);
    }

    @Override
    public T edit(Visitor ... visitors) {
        Object item = this.getItemOrRequireFromServer();
        Object clone = this.clone(item);
        return (T)this.patch(null, clone, (HasMetadata)((VisitableBuilder)this.context.getHandler(item).edit(item).accept(visitors)).build());
    }

    @Override
    public T replace() {
        return this.handleReplace(this.getItem());
    }

    @Override
    public T replaceStatus() {
        return this.statusSubresource().replace();
    }

    protected T modifyItemForReplaceOrPatch(Supplier<T> current, T item) {
        return item;
    }

    @Override
    public T update() {
        return this.update(this.getItem());
    }

    @Override
    public T updateStatus() {
        return this.statusSubresource().update();
    }

    protected T update(T item) {
        String existingResourceVersion = KubernetesResourceUtil.getResourceVersion(item);
        try {
            if (existingResourceVersion == null) {
                Object got = this.requireFromServer();
                String resourceVersion = KubernetesResourceUtil.getResourceVersion(got);
                item = this.clone(item);
                item.getMetadata().setResourceVersion(resourceVersion);
            }
            return this.handleUpdate(item);
        }
        catch (KubernetesClientException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType(UPDATE_OPERATION), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(this.forOperationType(UPDATE_OPERATION), (Throwable)e);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType(UPDATE_OPERATION), (Throwable)e);
        }
    }

    protected T handleReplace(T item) {
        String fixedResourceVersion = this.getResourceVersion();
        Exception caught = null;
        int maxTries = 10;
        if ((item = this.clone(item)).getMetadata() == null) {
            item.setMetadata(new ObjectMeta());
        }
        if (this.context.getSubresource() == null) {
            try {
                item = this.modifyItemForReplaceOrPatch(this::requireFromServer, item);
            }
            catch (Exception e) {
                throw KubernetesClientException.launderThrowable(this.forOperationType(REPLACE_OPERATION), (Throwable)e);
            }
        }
        String existingResourceVersion = KubernetesResourceUtil.getResourceVersion(item);
        for (int i = 0; i < maxTries; ++i) {
            try {
                String resourceVersion;
                if (fixedResourceVersion != null) {
                    resourceVersion = fixedResourceVersion;
                } else if (i == 0 && existingResourceVersion != null) {
                    resourceVersion = existingResourceVersion;
                } else {
                    Object got = this.requireFromServer();
                    resourceVersion = KubernetesResourceUtil.getResourceVersion(got);
                }
                UnaryOperator visitor = resource -> {
                    try {
                        resource.getMetadata().setResourceVersion(resourceVersion);
                        return this.handleUpdate(resource);
                    }
                    catch (Exception e) {
                        throw KubernetesClientException.launderThrowable(this.forOperationType(REPLACE_OPERATION), (Throwable)e);
                    }
                };
                return (T)((HasMetadata)visitor.apply(item));
            }
            catch (KubernetesClientException e) {
                caught = e;
                if (e.getCode() != 409 || fixedResourceVersion != null) break;
                if (i >= maxTries - 1) continue;
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            catch (Exception e) {
                caught = e;
            }
        }
        throw KubernetesClientException.launderThrowable(this.forOperationType(REPLACE_OPERATION), (Throwable)caught);
    }

    protected T patch(PatchContext context, T base, T item) {
        if ((context == null || context.getPatchType() == PatchType.JSON) && base == null) {
            if (base == null) {
                base = this.requireFromServer();
            }
            Object current = base;
            try {
                item = this.modifyItemForReplaceOrPatch(() -> current, item);
            }
            catch (Exception e) {
                throw KubernetesClientException.launderThrowable(this.forOperationType(PATCH_OPERATION), (Throwable)e);
            }
        }
        Object theBase = base;
        UnaryOperator visitor = resource -> {
            try {
                return this.handlePatch(context, theBase, resource);
            }
            catch (Exception e) {
                throw KubernetesClientException.launderThrowable(this.forOperationType(PATCH_OPERATION), (Throwable)e);
            }
        };
        return (T)((HasMetadata)visitor.apply(item));
    }

    @Override
    public T patchStatus() {
        return this.statusSubresource().patch(PatchContext.of(PatchType.JSON_MERGE), null, this.getNonNullItem());
    }

    @Override
    public T patch() {
        return this.patch(null, null, this.getNonNullItem());
    }

    @Override
    public T patch(PatchContext patchContext) {
        return this.patch(patchContext, null, this.getNonNullItem());
    }

    @Override
    public T patchStatus(T item) {
        return this.statusSubresource().patch(PatchContext.of(PatchType.JSON_MERGE), this.getItem(), this.clone(item));
    }

    @Override
    public T patch(PatchContext patchContext, T item) {
        return this.patch(patchContext, this.getItem(), this.clone(item));
    }

    @Override
    public T patch(PatchContext patchContext, String patch) {
        try {
            Object got = this.getItemOrRequireFromServer();
            return (T)((HasMetadata)this.handlePatch(patchContext, got, IOHelpers.convertToJson(patch), this.getType()));
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(this.forOperationType(PATCH_OPERATION), (Throwable)interruptedException);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType(PATCH_OPERATION), (Throwable)e);
        }
    }

    @Override
    public HasMetadataOperation<T, L, R> newInstance(OperationContext context) {
        return new HasMetadataOperation<T, L, R>(context, this.type, this.listType);
    }

    @Override
    public T scale(int count) {
        return this.scale(count, false);
    }

    @Override
    public T scale(int count, boolean wait) {
        this.scale(((ScaleBuilder)((ScaleFluent.SpecNested)((ScaleBuilder)((ScaleFluent.MetadataNested)new ScaleBuilder(this.scale()).editOrNewMetadata().withResourceVersion(null)).endMetadata()).editOrNewSpec().withReplicas(Integer.valueOf(count))).endSpec()).build());
        if (wait) {
            this.waitUntilScaled(count);
        }
        return this.get();
    }

    @Override
    public Scale scale(Scale scaleParam) {
        return this.handleScale(scaleParam, Scale.class);
    }

    protected void waitUntilScaled(int count) {
        AtomicReference<Integer> replicasRef = new AtomicReference<Integer>(0);
        String name = this.checkName(this.getItem());
        String namespace = this.checkNamespace(this.getItem());
        CompletableFuture<Object> completion = new CompletableFuture<Object>();
        Utils.scheduleWithVariableRate(completion, this.getOperationContext().getExecutor(), () -> {
            try {
                Scale scale = this.scale();
                int statusReplicas = Optional.ofNullable(scale.getStatus().getReplicas()).orElse(0);
                int specReplicas = Optional.ofNullable(scale.getSpec().getReplicas()).orElse(0);
                if (count == statusReplicas && count == specReplicas) {
                    completion.complete(null);
                } else {
                    LOGGER.debug("Only {}/{} replicas scheduled for {}: {} in namespace: {} seconds so waiting...", new Object[]{specReplicas, count, this.getKind(), this.getName(), namespace});
                }
            }
            catch (KubernetesClientException e) {
                completion.completeExceptionally(e);
            }
        }, 0L, () -> 1L, TimeUnit.SECONDS);
        if (!Utils.waitUntilReady(completion, this.getRequestConfig().getScaleTimeout(), TimeUnit.MILLISECONDS)) {
            completion.complete(null);
            throw new KubernetesClientException(String.format("%s/%s pod(s) ready for %s: %s in namespace: %s  after waiting for %s seconds so giving up", replicasRef.get(), count, this.getType().getSimpleName(), name, namespace, TimeUnit.MILLISECONDS.toSeconds(this.getRequestConfig().getScaleTimeout())));
        }
    }
}

