/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.impl.cache;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.informers.cache.BasicItemStore;
import io.fabric8.kubernetes.client.informers.cache.Cache;
import io.fabric8.kubernetes.client.informers.cache.ItemStore;
import io.fabric8.kubernetes.client.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CacheImpl<T extends HasMetadata>
implements Cache<T> {
    public static final String NAMESPACE_INDEX = "namespace";
    private final Map<String, Function<T, List<String>>> indexers = Collections.synchronizedMap(new HashMap());
    private ItemStore<T> items;
    private final ConcurrentMap<String, Index> indices = new ConcurrentHashMap<String, Index>();

    public CacheImpl() {
        this(NAMESPACE_INDEX, Cache::metaNamespaceIndexFunc, Cache::metaNamespaceKeyFunc);
    }

    public CacheImpl(String indexName, Function<T, List<String>> indexFunc, Function<T, String> keyFunc) {
        this.items = new BasicItemStore<T>(keyFunc);
        this.addIndexFunc(indexName, indexFunc);
    }

    public void setItemStore(ItemStore<T> items) {
        this.items = items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Function<T, List<String>>> getIndexers() {
        Map<String, Function<T, List<String>>> map = this.indexers;
        synchronized (map) {
            return Collections.unmodifiableMap(this.indexers);
        }
    }

    @Override
    public synchronized void addIndexers(Map<String, Function<T, List<String>>> indexersNew) {
        HashSet<String> intersection = new HashSet<String>(this.indexers.keySet());
        intersection.retainAll(indexersNew.keySet());
        if (!intersection.isEmpty()) {
            throw new IllegalArgumentException("Indexer conflict: " + String.valueOf(intersection));
        }
        for (Map.Entry<String, Function<T, List<String>>> indexEntry : indexersNew.entrySet()) {
            this.addIndexFunc(indexEntry.getKey(), indexEntry.getValue());
        }
    }

    public synchronized T put(T obj) {
        if (obj == null) {
            return null;
        }
        String key = this.getKey(obj);
        HasMetadata oldObj = (HasMetadata)this.items.put(key, obj);
        this.updateIndices(oldObj, obj, key);
        return (T)oldObj;
    }

    public synchronized T remove(T obj) {
        String key = this.getKey(obj);
        HasMetadata old = (HasMetadata)this.items.remove(key);
        if (old != null) {
            this.updateIndices(old, null, key);
        }
        return (T)old;
    }

    @Override
    public List<String> listKeys() {
        return this.items.keySet().collect(Collectors.toList());
    }

    @Override
    public T get(T obj) {
        String key = this.getKey(obj);
        return this.getByKey(key);
    }

    @Override
    public String getKey(T obj) {
        String result = this.items.getKey(obj);
        return result == null ? "" : result;
    }

    @Override
    public List<T> list() {
        return this.items.values().collect(Collectors.toList());
    }

    @Override
    public T getByKey(String key) {
        return (T)((HasMetadata)this.items.get(key));
    }

    @Override
    public List<T> index(String indexName, T obj) {
        Function<T, List<String>> indexFunc = this.indexers.get(indexName);
        if (indexFunc == null) {
            throw new IllegalArgumentException(String.format("index %s doesn't exist!", indexName));
        }
        Index index = this.getIndex(indexName);
        List<String> indexKeys = indexFunc.apply(obj);
        HashSet<String> returnKeySet = new HashSet<String>();
        for (String indexKey : indexKeys) {
            returnKeySet.addAll(index.get(indexKey));
        }
        return this.getItems(returnKeySet);
    }

    private List<T> getItems(Set<String> returnKeySet) {
        ArrayList items = new ArrayList(returnKeySet.size());
        for (String absoluteKey : returnKeySet) {
            Optional.ofNullable((HasMetadata)this.items.get(absoluteKey)).ifPresent(items::add);
        }
        return items;
    }

    private Index getIndex(String indexName) {
        return Optional.ofNullable((Index)this.indices.get(indexName)).orElseThrow(() -> new IllegalArgumentException(String.format("index %s doesn't exist!", indexName)));
    }

    @Override
    public List<String> indexKeys(String indexName, String indexKey) {
        Index index = this.getIndex(indexName);
        return new ArrayList<String>(index.get(indexKey));
    }

    @Override
    public List<T> byIndex(String indexName, String indexKey) {
        Index index = this.getIndex(indexName);
        return this.getItems(index.get(indexKey));
    }

    private void updateIndices(T oldObj, T newObj, String key) {
        for (Map.Entry<String, Function<T, List<String>>> indexEntry : this.indexers.entrySet()) {
            String indexName = indexEntry.getKey();
            Function<T, List<String>> indexFunc = indexEntry.getValue();
            Index index = (Index)this.indices.get(indexName);
            if (index == null) continue;
            if (oldObj != null) {
                this.updateIndex(key, oldObj, indexFunc, index, true);
            }
            if (newObj == null) continue;
            this.updateIndex(key, newObj, indexFunc, index, false);
        }
    }

    private void updateIndex(String key, T obj, Function<T, List<String>> indexFunc, Index index, boolean remove) {
        List<String> indexValues = indexFunc.apply(obj);
        if (indexValues != null && !indexValues.isEmpty()) {
            for (String indexValue : indexValues) {
                index.update(indexValue, key, remove);
            }
        }
    }

    public synchronized CacheImpl<T> addIndexFunc(String indexName, Function<T, List<String>> indexFunc) {
        if (this.indices.containsKey(indexName)) {
            throw new IllegalArgumentException("Indexer conflict: " + indexName);
        }
        Index index = new Index();
        this.indices.put(indexName, index);
        this.indexers.put(indexName, indexFunc);
        this.items.values().forEach(v -> this.updateIndex(this.getKey((T)v), v, indexFunc, index, false));
        return this;
    }

    public static String metaNamespaceKeyFunc(Object obj) {
        if (obj == null) {
            return "";
        }
        ObjectMeta metadata = null;
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof ObjectMeta) {
            metadata = (ObjectMeta)obj;
        } else if (obj instanceof HasMetadata) {
            metadata = ((HasMetadata)obj).getMetadata();
        }
        if (metadata == null) {
            throw new RuntimeException("Object is bad :" + String.valueOf(obj));
        }
        return CacheImpl.namespaceKeyFunc(metadata.getNamespace(), metadata.getName());
    }

    public static String namespaceKeyFunc(String objectNamespace, String objectName) {
        if (Utils.isNullOrEmpty(objectNamespace)) {
            return objectName;
        }
        return objectNamespace + "/" + objectName;
    }

    public static List<String> metaNamespaceIndexFunc(Object obj) {
        Object metadata = obj instanceof HasMetadata ? ((HasMetadata)obj).getMetadata() : (obj instanceof ObjectMeta ? (ObjectMeta)obj : null);
        return metadata == null ? Collections.emptyList() : Collections.singletonList(metadata.getNamespace());
    }

    @Override
    public synchronized void removeIndexer(String name) {
        this.indices.remove(name);
        this.indexers.remove(name);
    }

    public boolean isFullState() {
        return this.items.isFullState();
    }

    public Object getLockObject() {
        return this;
    }

    private static class Index {
        private Map<Object, Set<String>> values = new ConcurrentHashMap<Object, Set<String>>();

        private Index() {
        }

        public void update(String indexKey, String key, boolean remove) {
            if (remove) {
                this.values.computeIfPresent(indexKey == null ? this : indexKey, (k, v) -> {
                    v.remove(key);
                    return v.isEmpty() ? null : v;
                });
            } else {
                this.values.computeIfAbsent(indexKey == null ? this : indexKey, k -> ConcurrentHashMap.newKeySet()).add(key);
            }
        }

        public Set<String> get(String indexKey) {
            return this.values.getOrDefault(indexKey == null ? this : indexKey, Collections.emptySet());
        }
    }
}

