/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.okhttp;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.okhttp.OkHttpClientBuilderImpl;
import io.fabric8.kubernetes.client.okhttp.OkHttpClientFactory;
import io.fabric8.kubernetes.client.okhttp.OkHttpRequestImpl;
import io.fabric8.kubernetes.client.okhttp.OkHttpWebSocketImpl;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSource;

public class OkHttpClientImpl
implements HttpClient {
    static final Map<String, MediaType> MEDIA_TYPES = new ConcurrentHashMap<String, MediaType>();
    public static final MediaType JSON = OkHttpClientImpl.parseMediaType("application/json");
    public static final MediaType JSON_PATCH = OkHttpClientImpl.parseMediaType("application/json-patch+json");
    public static final MediaType STRATEGIC_MERGE_JSON_PATCH = OkHttpClientImpl.parseMediaType("application/strategic-merge-patch+json");
    public static final MediaType JSON_MERGE_PATCH = OkHttpClientImpl.parseMediaType("application/merge-patch+json");
    private final OkHttpClient httpClient;
    private final OkHttpClientFactory factory;
    private final Config config;

    static MediaType parseMediaType(String contentType) {
        MediaType result = MediaType.parse((String)contentType);
        MEDIA_TYPES.put(contentType, result);
        return result;
    }

    public OkHttpClientImpl(OkHttpClient httpClient, OkHttpClientFactory factory, Config config) {
        this.httpClient = httpClient;
        this.factory = factory;
        this.config = config;
    }

    public void close() {
        ExecutorService executorService;
        ConnectionPool connectionPool = this.httpClient.connectionPool();
        Dispatcher dispatcher = this.httpClient.dispatcher();
        ExecutorService executorService2 = executorService = this.httpClient.dispatcher() != null ? this.httpClient.dispatcher().executorService() : null;
        if (dispatcher != null) {
            dispatcher.cancelAll();
        }
        if (connectionPool != null) {
            connectionPool.evictAll();
        }
        if (executorService != null) {
            executorService.shutdownNow();
        }
    }

    public HttpClient.DerivedClientBuilder newBuilder() {
        return new OkHttpClientBuilderImpl(this.httpClient.newBuilder(), this.factory, this.config);
    }

    public CompletableFuture<HttpResponse<HttpClient.AsyncBody>> consumeLines(HttpRequest request, HttpClient.BodyConsumer<String> consumer) {
        Function<BufferedSource, HttpClient.AsyncBody> handler = s -> new OkHttpAsyncBody<String>(consumer, s){

            @Override
            protected String process(BufferedSource source) throws IOException {
                return source.readUtf8Line();
            }
        };
        return this.sendAsync(request, handler);
    }

    public CompletableFuture<HttpResponse<HttpClient.AsyncBody>> consumeBytes(HttpRequest request, HttpClient.BodyConsumer<List<ByteBuffer>> consumer) {
        Function<BufferedSource, HttpClient.AsyncBody> handler = s -> new OkHttpAsyncBody<List<ByteBuffer>>(consumer, s){

            @Override
            protected List<ByteBuffer> process(BufferedSource source) throws IOException {
                return Collections.singletonList(ByteBuffer.wrap(source.readByteArray(source.buffer().size())));
            }
        };
        return this.sendAsync(request, handler);
    }

    private CompletableFuture<HttpResponse<HttpClient.AsyncBody>> sendAsync(HttpRequest request, final Function<BufferedSource, HttpClient.AsyncBody> handler) {
        final CompletableFuture<HttpResponse<HttpClient.AsyncBody>> future = new CompletableFuture<HttpResponse<HttpClient.AsyncBody>>();
        Call call = this.httpClient.newCall(((OkHttpRequestImpl)request).getRequest());
        call.enqueue(new Callback(){

            public void onResponse(Call call, Response response) throws IOException {
                BufferedSource source = response.body().source();
                HttpClient.AsyncBody asyncBody = (HttpClient.AsyncBody)handler.apply(source);
                future.complete(new OkHttpResponseImpl<HttpClient.AsyncBody>(response, asyncBody));
            }

            public void onFailure(Call call, IOException e) {
                future.completeExceptionally(e);
            }
        });
        future.whenComplete((r, t) -> {
            if (future.isCancelled()) {
                call.cancel();
            }
        });
        return future;
    }

    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, final Class<T> type) {
        final CompletableFuture future = new CompletableFuture();
        Call call = this.httpClient.newCall(((OkHttpRequestImpl)request).getRequest());
        call.enqueue(new Callback(){

            public void onResponse(Call call, Response response) throws IOException {
                future.complete(new OkHttpResponseImpl(response, type));
            }

            public void onFailure(Call call, IOException e) {
                future.completeExceptionally(e);
            }
        });
        future.whenComplete((r, t) -> {
            if (future.isCancelled()) {
                call.cancel();
            }
        });
        return future;
    }

    public WebSocket.Builder newWebSocketBuilder() {
        return new OkHttpWebSocketImpl.BuilderImpl(this.httpClient, this.newRequestBuilder());
    }

    public OkHttpClient getOkHttpClient() {
        return this.httpClient;
    }

    public HttpRequest.Builder newHttpRequestBuilder() {
        return new OkHttpRequestImpl.BuilderImpl(this.newRequestBuilder());
    }

    private Request.Builder newRequestBuilder() {
        return new Request.Builder().tag(Config.class, (Object)this.config);
    }

    static class OkHttpResponseImpl<T>
    implements HttpResponse<T> {
        private final Response response;
        private T body;
        private Class<T> type;

        public OkHttpResponseImpl(Response response, T body) throws IOException {
            this.response = response;
            this.body = body;
        }

        public OkHttpResponseImpl(Response response, Class<T> type) throws IOException {
            this.response = response;
            this.type = type;
            ResponseBody responseBody = response.body();
            if (responseBody != null) {
                if (type == null) {
                    responseBody.close();
                } else {
                    this.body = type == String.class ? responseBody.string() : (type == Reader.class ? responseBody.charStream() : (type == byte[].class ? (T)responseBody.bytes() : responseBody.byteStream()));
                }
            }
        }

        public int code() {
            return this.response.code();
        }

        public T body() {
            return this.body;
        }

        public HttpRequest request() {
            return new OkHttpRequestImpl(this.response.request());
        }

        public Optional<HttpResponse<?>> previousResponse() {
            Response previous = this.response.priorResponse() != null ? this.response.priorResponse() : this.response;
            previous = previous.networkResponse() != null ? previous.networkResponse() : previous;
            try {
                return Optional.ofNullable(previous == this.response ? null : new OkHttpResponseImpl<T>(previous, this.type));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public List<String> headers(String key) {
            return this.response.headers(key);
        }

        public Map<String, List<String>> headers() {
            return this.response.headers().toMultimap();
        }
    }

    private abstract class OkHttpAsyncBody<T>
    implements HttpClient.AsyncBody {
        private final HttpClient.BodyConsumer<T> consumer;
        private final BufferedSource source;
        private final CompletableFuture<Void> done = new CompletableFuture();

        private OkHttpAsyncBody(HttpClient.BodyConsumer<T> consumer, BufferedSource source) {
            this.consumer = consumer;
            this.source = source;
        }

        public void consume() {
            try {
                OkHttpClientImpl.this.httpClient.dispatcher().executorService().execute(() -> {
                    try {
                        if (!this.source.exhausted() && !this.done.isDone()) {
                            T value = this.process(this.source);
                            this.consumer.consume(value, (HttpClient.AsyncBody)this);
                        } else {
                            this.done.complete(null);
                        }
                    }
                    catch (Exception e) {
                        Utils.closeQuietly((Closeable[])new Closeable[]{this.source});
                        this.done.completeExceptionally(e);
                    }
                });
            }
            catch (Exception e) {
                Utils.closeQuietly((Closeable[])new Closeable[]{this.source});
                this.done.completeExceptionally(e);
            }
        }

        public CompletableFuture<Void> done() {
            return this.done;
        }

        protected abstract T process(BufferedSource var1) throws IOException;

        public void cancel() {
            Utils.closeQuietly((Closeable[])new Closeable[]{this.source});
            this.done.cancel(false);
        }
    }
}

