/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.okhttp;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.StandardHttpRequest;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.http.WebSocketResponse;
import io.fabric8.kubernetes.client.http.WebSocketUpgradeResponse;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

class OkHttpWebSocketImpl
implements io.fabric8.kubernetes.client.http.WebSocket {
    private final WebSocket webSocket;
    private final Runnable requestMethod;

    public OkHttpWebSocketImpl(WebSocket webSocket, Runnable requestMethod) {
        this.webSocket = webSocket;
        this.requestMethod = requestMethod;
    }

    public boolean send(ByteBuffer buffer) {
        return this.webSocket.send(ByteString.of((ByteBuffer)buffer));
    }

    public boolean sendClose(int code, String reason) {
        return this.webSocket.close(code, reason);
    }

    public long queueSize() {
        return this.webSocket.queueSize();
    }

    public void request() {
        this.requestMethod.run();
    }

    public static CompletableFuture<WebSocketResponse> buildAsync(OkHttpClient httpClient, final StandardHttpRequest fabric8Request, Request request, final WebSocket.Listener listener) {
        final CompletableFuture<WebSocketResponse> future = new CompletableFuture<WebSocketResponse>();
        httpClient.newWebSocket(request, new WebSocketListener(){
            private volatile boolean opened;
            private boolean more = true;
            private ReentrantLock lock = new ReentrantLock();
            private Condition moreRequested = this.lock.newCondition();

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                if (response != null) {
                    response.close();
                }
                if (!this.opened) {
                    if (response != null) {
                        Optional.ofNullable(response.body()).ifPresent(ResponseBody::close);
                        WebSocketUpgradeResponse upgradeResponse = new WebSocketUpgradeResponse((HttpRequest)fabric8Request, response.code(), response.headers().toMultimap());
                        future.complete(new WebSocketResponse(upgradeResponse, t));
                    } else {
                        future.completeExceptionally(t);
                    }
                } else {
                    listener.onError((io.fabric8.kubernetes.client.http.WebSocket)new OkHttpWebSocketImpl(webSocket, this::request), t);
                }
            }

            public void onOpen(WebSocket webSocket, Response response) {
                this.opened = true;
                response.close();
                OkHttpWebSocketImpl fabric8WebSocket = new OkHttpWebSocketImpl(webSocket, this::request);
                listener.onOpen((io.fabric8.kubernetes.client.http.WebSocket)fabric8WebSocket);
                future.complete(new WebSocketResponse(new WebSocketUpgradeResponse((HttpRequest)fabric8Request, response.code(), response.headers().toMultimap()), (io.fabric8.kubernetes.client.http.WebSocket)fabric8WebSocket));
            }

            public void onMessage(WebSocket webSocket, ByteString bytes) {
                this.awaitMoreRequest();
                listener.onMessage((io.fabric8.kubernetes.client.http.WebSocket)new OkHttpWebSocketImpl(webSocket, this::request), bytes.asByteBuffer());
            }

            public void onMessage(WebSocket webSocket, String text) {
                this.awaitMoreRequest();
                listener.onMessage((io.fabric8.kubernetes.client.http.WebSocket)new OkHttpWebSocketImpl(webSocket, this::request), text);
            }

            private void awaitMoreRequest() {
                this.lock.lock();
                try {
                    while (!this.more) {
                        if (this.moreRequested.await(30L, TimeUnit.SECONDS)) continue;
                        throw new KubernetesClientException("OkHttp HttpClient thread is waiting too long for the consumption of previous websocket message");
                    }
                    this.more = false;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw KubernetesClientException.launderThrowable((Throwable)e);
                }
                finally {
                    this.lock.unlock();
                }
            }

            private void request() {
                this.lock.lock();
                try {
                    this.more = true;
                    this.moreRequested.signalAll();
                }
                finally {
                    this.lock.unlock();
                }
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
                listener.onClose((io.fabric8.kubernetes.client.http.WebSocket)new OkHttpWebSocketImpl(webSocket, this::request), code, reason);
            }
        });
        return future;
    }
}

