/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.junit.jupiter;

import io.fabric8.junit.jupiter.api.RequireK8sSupport;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class RequireK8sSupportCondition
implements ExecutionCondition {
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        RequireK8sSupport requireK8s = AnnotationSupport.findAnnotation((Optional)context.getElement(), RequireK8sSupport.class).orElse(null);
        if (requireK8s != null) {
            try (KubernetesClient client = new KubernetesClientBuilder().build();){
                if (client.supports(requireK8s.value())) {
                    ConditionEvaluationResult conditionEvaluationResult = ConditionEvaluationResult.enabled((String)String.format("Kubernetes resource %s IS supported in this cluster", requireK8s.value().getName()));
                    return conditionEvaluationResult;
                }
                ConditionEvaluationResult conditionEvaluationResult = ConditionEvaluationResult.disabled((String)String.format("Kubernetes resource %s IS NOT supported in this cluster", requireK8s.value().getName()));
                return conditionEvaluationResult;
            }
        }
        return ConditionEvaluationResult.enabled((String)"RequireK8sSupportCondition is not applicable");
    }
}

