package io.fabric8.kubernetes.api.model.authorization;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SelfSubjectRulesReviewBuilder extends SelfSubjectRulesReviewFluentImpl<SelfSubjectRulesReviewBuilder> implements VisitableBuilder<SelfSubjectRulesReview,SelfSubjectRulesReviewBuilder>{

    SelfSubjectRulesReviewFluent<?> fluent;
    Boolean validationEnabled;

    public SelfSubjectRulesReviewBuilder(){
            this(true);
    }
    public SelfSubjectRulesReviewBuilder(Boolean validationEnabled){
            this(new SelfSubjectRulesReview(), validationEnabled);
    }
    public SelfSubjectRulesReviewBuilder(SelfSubjectRulesReviewFluent<?> fluent){
            this(fluent, true);
    }
    public SelfSubjectRulesReviewBuilder(SelfSubjectRulesReviewFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SelfSubjectRulesReview(), validationEnabled);
    }
    public SelfSubjectRulesReviewBuilder(SelfSubjectRulesReviewFluent<?> fluent,SelfSubjectRulesReview instance){
            this(fluent, instance, true);
    }
    public SelfSubjectRulesReviewBuilder(SelfSubjectRulesReviewFluent<?> fluent,SelfSubjectRulesReview instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public SelfSubjectRulesReviewBuilder(SelfSubjectRulesReview instance){
            this(instance,true);
    }
    public SelfSubjectRulesReviewBuilder(SelfSubjectRulesReview instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public SelfSubjectRulesReview build(){
            SelfSubjectRulesReview buildable = new SelfSubjectRulesReview(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SelfSubjectRulesReviewBuilder that = (SelfSubjectRulesReviewBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
