package io.fabric8.kubernetes.api.model.admission;

import io.fabric8.kubernetes.api.model.Status;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface AdmissionResponseFluent<A extends AdmissionResponseFluent<A>> extends Fluent<A> {


    public Boolean isAllowed();
    public A withAllowed(Boolean allowed);
    public Boolean hasAllowed();
    public A withNewAllowed(String arg1);
    public A withNewAllowed(boolean arg1);
    public A addToAuditAnnotations(String key,String value);
    public A addToAuditAnnotations(Map<String,String> map);
    public A removeFromAuditAnnotations(String key);
    public A removeFromAuditAnnotations(Map<String,String> map);
    public Map<String,String> getAuditAnnotations();
    public A withAuditAnnotations(Map<String,String> auditAnnotations);
    public Boolean hasAuditAnnotations();
    public String getPatch();
    public A withPatch(String patch);
    public Boolean hasPatch();
    public A withNewPatch(String arg1);
    public A withNewPatch(StringBuilder arg1);
    public A withNewPatch(StringBuffer arg1);
    public String getPatchType();
    public A withPatchType(String patchType);
    public Boolean hasPatchType();
    public A withNewPatchType(String arg1);
    public A withNewPatchType(StringBuilder arg1);
    public A withNewPatchType(StringBuffer arg1);
    public Status getStatus();
    public A withStatus(Status status);
    public Boolean hasStatus();
    public String getUid();
    public A withUid(String uid);
    public Boolean hasUid();
    public A withNewUid(String arg1);
    public A withNewUid(StringBuilder arg1);
    public A withNewUid(StringBuffer arg1);
    public A addToWarnings(int index,String item);
    public A setToWarnings(int index,String item);
    public A addToWarnings(String... items);
    public A addAllToWarnings(Collection<String> items);
    public A removeFromWarnings(String... items);
    public A removeAllFromWarnings(Collection<String> items);
    public List<String> getWarnings();
    public String getWarning(int index);
    public String getFirstWarning();
    public String getLastWarning();
    public String getMatchingWarning(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingWarning(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withWarnings(List<String> warnings);
    public A withWarnings(String... warnings);
    public Boolean hasWarnings();
    public A addNewWarning(String arg1);
    public A addNewWarning(StringBuilder arg1);
    public A addNewWarning(StringBuffer arg1);
}
