package io.fabric8.kubernetes.api.model.authorization.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class SubjectRulesReviewStatusFluentImpl<A extends io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent<A>{
  public SubjectRulesReviewStatusFluentImpl() {
  }
  public SubjectRulesReviewStatusFluentImpl(io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatus instance) {
    this.withEvaluationError(instance.getEvaluationError()); 
    this.withIncomplete(instance.getIncomplete()); 
    this.withNonResourceRules(instance.getNonResourceRules()); 
    this.withResourceRules(instance.getResourceRules()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.lang.String evaluationError;
  private java.lang.Boolean incomplete;
  private java.util.List<io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder> nonResourceRules =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder>();
  private java.util.List<io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder> resourceRules =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder>();
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public java.lang.String getEvaluationError() {
    return this.evaluationError;
  }
  public A withEvaluationError(java.lang.String evaluationError) {
    this.evaluationError=evaluationError; return (A) this;
  }
  public java.lang.Boolean hasEvaluationError() {
    return this.evaluationError != null;
  }
  
  /**
   * Method is deprecated. use withEvaluationError instead.
   */
  @java.lang.Deprecated
  public A withNewEvaluationError(java.lang.String arg0) {
    return (A)withEvaluationError(new String(arg0));
  }
  public java.lang.Boolean getIncomplete() {
    return this.incomplete;
  }
  public A withIncomplete(java.lang.Boolean incomplete) {
    this.incomplete=incomplete; return (A) this;
  }
  public java.lang.Boolean hasIncomplete() {
    return this.incomplete != null;
  }
  public A addToNonResourceRules(java.lang.Integer index,io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRule item) {
    if (this.nonResourceRules == null) {this.nonResourceRules = new java.util.ArrayList<io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder>();}
    io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder builder = new io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder(item);_visitables.get("nonResourceRules").add(index >= 0 ? index : _visitables.get("nonResourceRules").size(), builder);this.nonResourceRules.add(index >= 0 ? index : nonResourceRules.size(), builder); return (A)this;
  }
  public A setToNonResourceRules(java.lang.Integer index,io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRule item) {
    if (this.nonResourceRules == null) {this.nonResourceRules = new java.util.ArrayList<io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder>();}
    io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder builder = new io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder(item);
    if (index < 0 || index >= _visitables.get("nonResourceRules").size()) { _visitables.get("nonResourceRules").add(builder); } else { _visitables.get("nonResourceRules").set(index, builder);}
    if (index < 0 || index >= nonResourceRules.size()) { nonResourceRules.add(builder); } else { nonResourceRules.set(index, builder);}
     return (A)this;
  }
  public A addToNonResourceRules(io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRule... items) {
    if (this.nonResourceRules == null) {this.nonResourceRules = new java.util.ArrayList<io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder>();}
    for (io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRule item : items) {io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder builder = new io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder(item);_visitables.get("nonResourceRules").add(builder);this.nonResourceRules.add(builder);} return (A)this;
  }
  public A addAllToNonResourceRules(java.util.Collection<io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRule> items) {
    if (this.nonResourceRules == null) {this.nonResourceRules = new java.util.ArrayList<io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder>();}
    for (io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRule item : items) {io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder builder = new io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder(item);_visitables.get("nonResourceRules").add(builder);this.nonResourceRules.add(builder);} return (A)this;
  }
  public A removeFromNonResourceRules(io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRule... items) {
    for (io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRule item : items) {io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder builder = new io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder(item);_visitables.get("nonResourceRules").remove(builder);if (this.nonResourceRules != null) {this.nonResourceRules.remove(builder);}} return (A)this;
  }
  public A removeAllFromNonResourceRules(java.util.Collection<io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRule> items) {
    for (io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRule item : items) {io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder builder = new io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder(item);_visitables.get("nonResourceRules").remove(builder);if (this.nonResourceRules != null) {this.nonResourceRules.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromNonResourceRules(java.util.function.Predicate<io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder> predicate) {
    if (nonResourceRules == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder> each = nonResourceRules.iterator();
    final List visitables = _visitables.get("nonResourceRules");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildNonResourceRules instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRule> getNonResourceRules() {
    return build(nonResourceRules);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRule> buildNonResourceRules() {
    return build(nonResourceRules);
  }
  public io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRule buildNonResourceRule(java.lang.Integer index) {
    return this.nonResourceRules.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRule buildFirstNonResourceRule() {
    return this.nonResourceRules.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRule buildLastNonResourceRule() {
    return this.nonResourceRules.get(nonResourceRules.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRule buildMatchingNonResourceRule(java.util.function.Predicate<io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder item: nonResourceRules) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingNonResourceRule(java.util.function.Predicate<io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder item: nonResourceRules) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNonResourceRules(java.util.List<io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRule> nonResourceRules) {
    if (this.nonResourceRules != null) { _visitables.get("nonResourceRules").removeAll(this.nonResourceRules);}
    if (nonResourceRules != null) {this.nonResourceRules = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRule item : nonResourceRules){this.addToNonResourceRules(item);}} else { this.nonResourceRules = null;} return (A) this;
  }
  public A withNonResourceRules(io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRule... nonResourceRules) {
    if (this.nonResourceRules != null) {this.nonResourceRules.clear();}
    if (nonResourceRules != null) {for (io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRule item :nonResourceRules){ this.addToNonResourceRules(item);}} return (A) this;
  }
  public java.lang.Boolean hasNonResourceRules() {
    return nonResourceRules != null && !nonResourceRules.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> addNewNonResourceRule() {
    return new io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluentImpl.NonResourceRulesNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> addNewNonResourceRuleLike(io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRule item) {
    return new io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluentImpl.NonResourceRulesNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> setNewNonResourceRuleLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRule item) {
    return new io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluentImpl.NonResourceRulesNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> editNonResourceRule(java.lang.Integer index) {
    if (nonResourceRules.size() <= index) throw new RuntimeException("Can't edit nonResourceRules. Index exceeds size.");
    return setNewNonResourceRuleLike(index, buildNonResourceRule(index));
  }
  public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> editFirstNonResourceRule() {
    if (nonResourceRules.size() == 0) throw new RuntimeException("Can't edit first nonResourceRules. The list is empty.");
    return setNewNonResourceRuleLike(0, buildNonResourceRule(0));
  }
  public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> editLastNonResourceRule() {
    int index = nonResourceRules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last nonResourceRules. The list is empty.");
    return setNewNonResourceRuleLike(index, buildNonResourceRule(index));
  }
  public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.NonResourceRulesNested<A> editMatchingNonResourceRule(java.util.function.Predicate<io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<nonResourceRules.size();i++) { 
    if (predicate.test(nonResourceRules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching nonResourceRules. No match found.");
    return setNewNonResourceRuleLike(index, buildNonResourceRule(index));
  }
  public A addToResourceRules(java.lang.Integer index,io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule item) {
    if (this.resourceRules == null) {this.resourceRules = new java.util.ArrayList<io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder>();}
    io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder builder = new io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder(item);_visitables.get("resourceRules").add(index >= 0 ? index : _visitables.get("resourceRules").size(), builder);this.resourceRules.add(index >= 0 ? index : resourceRules.size(), builder); return (A)this;
  }
  public A setToResourceRules(java.lang.Integer index,io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule item) {
    if (this.resourceRules == null) {this.resourceRules = new java.util.ArrayList<io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder>();}
    io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder builder = new io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder(item);
    if (index < 0 || index >= _visitables.get("resourceRules").size()) { _visitables.get("resourceRules").add(builder); } else { _visitables.get("resourceRules").set(index, builder);}
    if (index < 0 || index >= resourceRules.size()) { resourceRules.add(builder); } else { resourceRules.set(index, builder);}
     return (A)this;
  }
  public A addToResourceRules(io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule... items) {
    if (this.resourceRules == null) {this.resourceRules = new java.util.ArrayList<io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder>();}
    for (io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule item : items) {io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder builder = new io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder(item);_visitables.get("resourceRules").add(builder);this.resourceRules.add(builder);} return (A)this;
  }
  public A addAllToResourceRules(java.util.Collection<io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule> items) {
    if (this.resourceRules == null) {this.resourceRules = new java.util.ArrayList<io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder>();}
    for (io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule item : items) {io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder builder = new io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder(item);_visitables.get("resourceRules").add(builder);this.resourceRules.add(builder);} return (A)this;
  }
  public A removeFromResourceRules(io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule... items) {
    for (io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule item : items) {io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder builder = new io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder(item);_visitables.get("resourceRules").remove(builder);if (this.resourceRules != null) {this.resourceRules.remove(builder);}} return (A)this;
  }
  public A removeAllFromResourceRules(java.util.Collection<io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule> items) {
    for (io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule item : items) {io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder builder = new io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder(item);_visitables.get("resourceRules").remove(builder);if (this.resourceRules != null) {this.resourceRules.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromResourceRules(java.util.function.Predicate<io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder> predicate) {
    if (resourceRules == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder> each = resourceRules.iterator();
    final List visitables = _visitables.get("resourceRules");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildResourceRules instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule> getResourceRules() {
    return build(resourceRules);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule> buildResourceRules() {
    return build(resourceRules);
  }
  public io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule buildResourceRule(java.lang.Integer index) {
    return this.resourceRules.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule buildFirstResourceRule() {
    return this.resourceRules.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule buildLastResourceRule() {
    return this.resourceRules.get(resourceRules.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule buildMatchingResourceRule(java.util.function.Predicate<io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder item: resourceRules) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingResourceRule(java.util.function.Predicate<io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder item: resourceRules) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResourceRules(java.util.List<io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule> resourceRules) {
    if (this.resourceRules != null) { _visitables.get("resourceRules").removeAll(this.resourceRules);}
    if (resourceRules != null) {this.resourceRules = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule item : resourceRules){this.addToResourceRules(item);}} else { this.resourceRules = null;} return (A) this;
  }
  public A withResourceRules(io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule... resourceRules) {
    if (this.resourceRules != null) {this.resourceRules.clear();}
    if (resourceRules != null) {for (io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule item :resourceRules){ this.addToResourceRules(item);}} return (A) this;
  }
  public java.lang.Boolean hasResourceRules() {
    return resourceRules != null && !resourceRules.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.ResourceRulesNested<A> addNewResourceRule() {
    return new io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluentImpl.ResourceRulesNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.ResourceRulesNested<A> addNewResourceRuleLike(io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule item) {
    return new io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluentImpl.ResourceRulesNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.ResourceRulesNested<A> setNewResourceRuleLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule item) {
    return new io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluentImpl.ResourceRulesNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.ResourceRulesNested<A> editResourceRule(java.lang.Integer index) {
    if (resourceRules.size() <= index) throw new RuntimeException("Can't edit resourceRules. Index exceeds size.");
    return setNewResourceRuleLike(index, buildResourceRule(index));
  }
  public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.ResourceRulesNested<A> editFirstResourceRule() {
    if (resourceRules.size() == 0) throw new RuntimeException("Can't edit first resourceRules. The list is empty.");
    return setNewResourceRuleLike(0, buildResourceRule(0));
  }
  public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.ResourceRulesNested<A> editLastResourceRule() {
    int index = resourceRules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last resourceRules. The list is empty.");
    return setNewResourceRuleLike(index, buildResourceRule(index));
  }
  public io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.ResourceRulesNested<A> editMatchingResourceRule(java.util.function.Predicate<io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<resourceRules.size();i++) { 
    if (predicate.test(resourceRules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching resourceRules. No match found.");
    return setNewResourceRuleLike(index, buildResourceRule(index));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SubjectRulesReviewStatusFluentImpl that = (SubjectRulesReviewStatusFluentImpl) o;
    if (evaluationError != null ? !evaluationError.equals(that.evaluationError) :that.evaluationError != null) return false;
    if (incomplete != null ? !incomplete.equals(that.incomplete) :that.incomplete != null) return false;
    if (nonResourceRules != null ? !nonResourceRules.equals(that.nonResourceRules) :that.nonResourceRules != null) return false;
    if (resourceRules != null ? !resourceRules.equals(that.resourceRules) :that.resourceRules != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(evaluationError,  incomplete,  nonResourceRules,  resourceRules,  additionalProperties,  super.hashCode());
  }
  public class NonResourceRulesNestedImpl<N> extends io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleFluentImpl<io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.NonResourceRulesNested<N>> implements io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.NonResourceRulesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    NonResourceRulesNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRule item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder(this, item);
    }
    NonResourceRulesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder(this);
    }
    io.fabric8.kubernetes.api.model.authorization.v1.NonResourceRuleBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) SubjectRulesReviewStatusFluentImpl.this.setToNonResourceRules(index,builder.build());
    }
    public N endNonResourceRule() {
      return and();
    }
    
  }
  public class ResourceRulesNestedImpl<N> extends io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleFluentImpl<io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.ResourceRulesNested<N>> implements io.fabric8.kubernetes.api.model.authorization.v1.SubjectRulesReviewStatusFluent.ResourceRulesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ResourceRulesNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder(this, item);
    }
    ResourceRulesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder(this);
    }
    io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) SubjectRulesReviewStatusFluentImpl.this.setToResourceRules(index,builder.build());
    }
    public N endResourceRule() {
      return and();
    }
    
  }
  
}