package io.fabric8.kubernetes.api.model.admissionregistration.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ValidatingWebhookBuilder extends ValidatingWebhookFluentImpl<ValidatingWebhookBuilder> implements VisitableBuilder<ValidatingWebhook,ValidatingWebhookBuilder>{
  public ValidatingWebhookBuilder() {
    this(false);
  }
  public ValidatingWebhookBuilder(Boolean validationEnabled) {
    this(new ValidatingWebhook(), validationEnabled);
  }
  public ValidatingWebhookBuilder(ValidatingWebhookFluent<?> fluent) {
    this(fluent, false);
  }
  public ValidatingWebhookBuilder(ValidatingWebhookFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ValidatingWebhook(), validationEnabled);
  }
  public ValidatingWebhookBuilder(ValidatingWebhookFluent<?> fluent,ValidatingWebhook instance) {
    this(fluent, instance, false);
  }
  public ValidatingWebhookBuilder(ValidatingWebhookFluent<?> fluent,ValidatingWebhook instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAdmissionReviewVersions(instance.getAdmissionReviewVersions()); 
    fluent.withClientConfig(instance.getClientConfig()); 
    fluent.withFailurePolicy(instance.getFailurePolicy()); 
    fluent.withMatchPolicy(instance.getMatchPolicy()); 
    fluent.withName(instance.getName()); 
    fluent.withNamespaceSelector(instance.getNamespaceSelector()); 
    fluent.withObjectSelector(instance.getObjectSelector()); 
    fluent.withRules(instance.getRules()); 
    fluent.withSideEffects(instance.getSideEffects()); 
    fluent.withTimeoutSeconds(instance.getTimeoutSeconds()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ValidatingWebhookBuilder(ValidatingWebhook instance) {
    this(instance,false);
  }
  public ValidatingWebhookBuilder(ValidatingWebhook instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAdmissionReviewVersions(instance.getAdmissionReviewVersions()); 
    this.withClientConfig(instance.getClientConfig()); 
    this.withFailurePolicy(instance.getFailurePolicy()); 
    this.withMatchPolicy(instance.getMatchPolicy()); 
    this.withName(instance.getName()); 
    this.withNamespaceSelector(instance.getNamespaceSelector()); 
    this.withObjectSelector(instance.getObjectSelector()); 
    this.withRules(instance.getRules()); 
    this.withSideEffects(instance.getSideEffects()); 
    this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ValidatingWebhookFluent<?> fluent;
  Boolean validationEnabled;
  public ValidatingWebhook build() {
    ValidatingWebhook buildable = new ValidatingWebhook(fluent.getAdmissionReviewVersions(),fluent.getClientConfig(),fluent.getFailurePolicy(),fluent.getMatchPolicy(),fluent.getName(),fluent.getNamespaceSelector(),fluent.getObjectSelector(),fluent.getRules(),fluent.getSideEffects(),fluent.getTimeoutSeconds());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}