package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ValidatingAdmissionPolicySpecFluentImpl<A extends ValidatingAdmissionPolicySpecFluent<A>> extends BaseFluent<A> implements ValidatingAdmissionPolicySpecFluent<A>{
  public ValidatingAdmissionPolicySpecFluentImpl() {
  }
  public ValidatingAdmissionPolicySpecFluentImpl(ValidatingAdmissionPolicySpec instance) {
    this.withFailurePolicy(instance.getFailurePolicy()); 
    this.withMatchConstraints(instance.getMatchConstraints()); 
    this.withParamKind(instance.getParamKind()); 
    this.withValidations(instance.getValidations()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String failurePolicy;
  private MatchResourcesBuilder matchConstraints;
  private ParamKindBuilder paramKind;
  private ArrayList<ValidationBuilder> validations = new ArrayList<ValidationBuilder>();
  private Map<String,Object> additionalProperties;
  public String getFailurePolicy() {
    return this.failurePolicy;
  }
  public A withFailurePolicy(String failurePolicy) {
    this.failurePolicy=failurePolicy; return (A) this;
  }
  public Boolean hasFailurePolicy() {
    return this.failurePolicy != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMatchConstraints instead.
   * @return The buildable object.
   */
  @Deprecated
  public MatchResources getMatchConstraints() {
    return this.matchConstraints!=null ?this.matchConstraints.build():null;
  }
  public MatchResources buildMatchConstraints() {
    return this.matchConstraints!=null ?this.matchConstraints.build():null;
  }
  public A withMatchConstraints(MatchResources matchConstraints) {
    _visitables.get("matchConstraints").remove(this.matchConstraints);
    if (matchConstraints!=null){ this.matchConstraints= new MatchResourcesBuilder(matchConstraints); _visitables.get("matchConstraints").add(this.matchConstraints);} else { this.matchConstraints = null; _visitables.get("matchConstraints").remove(this.matchConstraints); } return (A) this;
  }
  public Boolean hasMatchConstraints() {
    return this.matchConstraints != null;
  }
  public ValidatingAdmissionPolicySpecFluent.MatchConstraintsNested<A> withNewMatchConstraints() {
    return new ValidatingAdmissionPolicySpecFluentImpl.MatchConstraintsNestedImpl();
  }
  public ValidatingAdmissionPolicySpecFluent.MatchConstraintsNested<A> withNewMatchConstraintsLike(MatchResources item) {
    return new ValidatingAdmissionPolicySpecFluentImpl.MatchConstraintsNestedImpl(item);
  }
  public ValidatingAdmissionPolicySpecFluent.MatchConstraintsNested<A> editMatchConstraints() {
    return withNewMatchConstraintsLike(getMatchConstraints());
  }
  public ValidatingAdmissionPolicySpecFluent.MatchConstraintsNested<A> editOrNewMatchConstraints() {
    return withNewMatchConstraintsLike(getMatchConstraints() != null ? getMatchConstraints(): new MatchResourcesBuilder().build());
  }
  public ValidatingAdmissionPolicySpecFluent.MatchConstraintsNested<A> editOrNewMatchConstraintsLike(MatchResources item) {
    return withNewMatchConstraintsLike(getMatchConstraints() != null ? getMatchConstraints(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildParamKind instead.
   * @return The buildable object.
   */
  @Deprecated
  public ParamKind getParamKind() {
    return this.paramKind!=null ?this.paramKind.build():null;
  }
  public ParamKind buildParamKind() {
    return this.paramKind!=null ?this.paramKind.build():null;
  }
  public A withParamKind(ParamKind paramKind) {
    _visitables.get("paramKind").remove(this.paramKind);
    if (paramKind!=null){ this.paramKind= new ParamKindBuilder(paramKind); _visitables.get("paramKind").add(this.paramKind);} else { this.paramKind = null; _visitables.get("paramKind").remove(this.paramKind); } return (A) this;
  }
  public Boolean hasParamKind() {
    return this.paramKind != null;
  }
  public A withNewParamKind(String apiVersion,String kind) {
    return (A)withParamKind(new ParamKind(apiVersion, kind));
  }
  public ValidatingAdmissionPolicySpecFluent.ParamKindNested<A> withNewParamKind() {
    return new ValidatingAdmissionPolicySpecFluentImpl.ParamKindNestedImpl();
  }
  public ValidatingAdmissionPolicySpecFluent.ParamKindNested<A> withNewParamKindLike(ParamKind item) {
    return new ValidatingAdmissionPolicySpecFluentImpl.ParamKindNestedImpl(item);
  }
  public ValidatingAdmissionPolicySpecFluent.ParamKindNested<A> editParamKind() {
    return withNewParamKindLike(getParamKind());
  }
  public ValidatingAdmissionPolicySpecFluent.ParamKindNested<A> editOrNewParamKind() {
    return withNewParamKindLike(getParamKind() != null ? getParamKind(): new ParamKindBuilder().build());
  }
  public ValidatingAdmissionPolicySpecFluent.ParamKindNested<A> editOrNewParamKindLike(ParamKind item) {
    return withNewParamKindLike(getParamKind() != null ? getParamKind(): item);
  }
  public A addToValidations(Integer index,Validation item) {
    if (this.validations == null) {this.validations = new ArrayList<ValidationBuilder>();}
    ValidationBuilder builder = new ValidationBuilder(item);_visitables.get("validations").add(index >= 0 ? index : _visitables.get("validations").size(), builder);this.validations.add(index >= 0 ? index : validations.size(), builder); return (A)this;
  }
  public A setToValidations(Integer index,Validation item) {
    if (this.validations == null) {this.validations = new ArrayList<ValidationBuilder>();}
    ValidationBuilder builder = new ValidationBuilder(item);
    if (index < 0 || index >= _visitables.get("validations").size()) { _visitables.get("validations").add(builder); } else { _visitables.get("validations").set(index, builder);}
    if (index < 0 || index >= validations.size()) { validations.add(builder); } else { validations.set(index, builder);}
     return (A)this;
  }
  public A addToValidations(io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.Validation... items) {
    if (this.validations == null) {this.validations = new ArrayList<ValidationBuilder>();}
    for (Validation item : items) {ValidationBuilder builder = new ValidationBuilder(item);_visitables.get("validations").add(builder);this.validations.add(builder);} return (A)this;
  }
  public A addAllToValidations(Collection<Validation> items) {
    if (this.validations == null) {this.validations = new ArrayList<ValidationBuilder>();}
    for (Validation item : items) {ValidationBuilder builder = new ValidationBuilder(item);_visitables.get("validations").add(builder);this.validations.add(builder);} return (A)this;
  }
  public A removeFromValidations(io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.Validation... items) {
    for (Validation item : items) {ValidationBuilder builder = new ValidationBuilder(item);_visitables.get("validations").remove(builder);if (this.validations != null) {this.validations.remove(builder);}} return (A)this;
  }
  public A removeAllFromValidations(Collection<Validation> items) {
    for (Validation item : items) {ValidationBuilder builder = new ValidationBuilder(item);_visitables.get("validations").remove(builder);if (this.validations != null) {this.validations.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromValidations(Predicate<ValidationBuilder> predicate) {
    if (validations == null) return (A) this;
    final Iterator<ValidationBuilder> each = validations.iterator();
    final List visitables = _visitables.get("validations");
    while (each.hasNext()) {
      ValidationBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildValidations instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Validation> getValidations() {
    return validations != null ? build(validations) : null;
  }
  public List<Validation> buildValidations() {
    return validations != null ? build(validations) : null;
  }
  public Validation buildValidation(Integer index) {
    return this.validations.get(index).build();
  }
  public Validation buildFirstValidation() {
    return this.validations.get(0).build();
  }
  public Validation buildLastValidation() {
    return this.validations.get(validations.size() - 1).build();
  }
  public Validation buildMatchingValidation(Predicate<ValidationBuilder> predicate) {
    for (ValidationBuilder item: validations) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingValidation(Predicate<ValidationBuilder> predicate) {
    for (ValidationBuilder item: validations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withValidations(List<Validation> validations) {
    if (this.validations != null) { _visitables.get("validations").removeAll(this.validations);}
    if (validations != null) {this.validations = new ArrayList(); for (Validation item : validations){this.addToValidations(item);}} else { this.validations = null;} return (A) this;
  }
  public A withValidations(io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.Validation... validations) {
    if (this.validations != null) {this.validations.clear();}
    if (validations != null) {for (Validation item :validations){ this.addToValidations(item);}} return (A) this;
  }
  public Boolean hasValidations() {
    return validations != null && !validations.isEmpty();
  }
  public A addNewValidation(String expression,String message,String reason) {
    return (A)addToValidations(new Validation(expression, message, reason));
  }
  public ValidatingAdmissionPolicySpecFluent.ValidationsNested<A> addNewValidation() {
    return new ValidatingAdmissionPolicySpecFluentImpl.ValidationsNestedImpl();
  }
  public ValidatingAdmissionPolicySpecFluent.ValidationsNested<A> addNewValidationLike(Validation item) {
    return new ValidatingAdmissionPolicySpecFluentImpl.ValidationsNestedImpl(-1, item);
  }
  public ValidatingAdmissionPolicySpecFluent.ValidationsNested<A> setNewValidationLike(Integer index,Validation item) {
    return new ValidatingAdmissionPolicySpecFluentImpl.ValidationsNestedImpl(index, item);
  }
  public ValidatingAdmissionPolicySpecFluent.ValidationsNested<A> editValidation(Integer index) {
    if (validations.size() <= index) throw new RuntimeException("Can't edit validations. Index exceeds size.");
    return setNewValidationLike(index, buildValidation(index));
  }
  public ValidatingAdmissionPolicySpecFluent.ValidationsNested<A> editFirstValidation() {
    if (validations.size() == 0) throw new RuntimeException("Can't edit first validations. The list is empty.");
    return setNewValidationLike(0, buildValidation(0));
  }
  public ValidatingAdmissionPolicySpecFluent.ValidationsNested<A> editLastValidation() {
    int index = validations.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last validations. The list is empty.");
    return setNewValidationLike(index, buildValidation(index));
  }
  public ValidatingAdmissionPolicySpecFluent.ValidationsNested<A> editMatchingValidation(Predicate<ValidationBuilder> predicate) {
    int index = -1;
    for (int i=0;i<validations.size();i++) { 
    if (predicate.test(validations.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching validations. No match found.");
    return setNewValidationLike(index, buildValidation(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ValidatingAdmissionPolicySpecFluentImpl that = (ValidatingAdmissionPolicySpecFluentImpl) o;
    if (failurePolicy != null ? !failurePolicy.equals(that.failurePolicy) :that.failurePolicy != null) return false;
    if (matchConstraints != null ? !matchConstraints.equals(that.matchConstraints) :that.matchConstraints != null) return false;
    if (paramKind != null ? !paramKind.equals(that.paramKind) :that.paramKind != null) return false;
    if (validations != null ? !validations.equals(that.validations) :that.validations != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(failurePolicy,  matchConstraints,  paramKind,  validations,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (failurePolicy != null) { sb.append("failurePolicy:"); sb.append(failurePolicy + ","); }
    if (matchConstraints != null) { sb.append("matchConstraints:"); sb.append(matchConstraints + ","); }
    if (paramKind != null) { sb.append("paramKind:"); sb.append(paramKind + ","); }
    if (validations != null && !validations.isEmpty()) { sb.append("validations:"); sb.append(validations + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MatchConstraintsNestedImpl<N> extends MatchResourcesFluentImpl<ValidatingAdmissionPolicySpecFluent.MatchConstraintsNested<N>> implements ValidatingAdmissionPolicySpecFluent.MatchConstraintsNested<N>,Nested<N>{
    MatchConstraintsNestedImpl(MatchResources item) {
      this.builder = new MatchResourcesBuilder(this, item);
    }
    MatchConstraintsNestedImpl() {
      this.builder = new MatchResourcesBuilder(this);
    }
    MatchResourcesBuilder builder;
    public N and() {
      return (N) ValidatingAdmissionPolicySpecFluentImpl.this.withMatchConstraints(builder.build());
    }
    public N endMatchConstraints() {
      return and();
    }
    
  }
  class ParamKindNestedImpl<N> extends ParamKindFluentImpl<ValidatingAdmissionPolicySpecFluent.ParamKindNested<N>> implements ValidatingAdmissionPolicySpecFluent.ParamKindNested<N>,Nested<N>{
    ParamKindNestedImpl(ParamKind item) {
      this.builder = new ParamKindBuilder(this, item);
    }
    ParamKindNestedImpl() {
      this.builder = new ParamKindBuilder(this);
    }
    ParamKindBuilder builder;
    public N and() {
      return (N) ValidatingAdmissionPolicySpecFluentImpl.this.withParamKind(builder.build());
    }
    public N endParamKind() {
      return and();
    }
    
  }
  class ValidationsNestedImpl<N> extends ValidationFluentImpl<ValidatingAdmissionPolicySpecFluent.ValidationsNested<N>> implements ValidatingAdmissionPolicySpecFluent.ValidationsNested<N>,Nested<N>{
    ValidationsNestedImpl(Integer index,Validation item) {
      this.index = index;
      this.builder = new ValidationBuilder(this, item);
    }
    ValidationsNestedImpl() {
      this.index = -1;
      this.builder = new ValidationBuilder(this);
    }
    ValidationBuilder builder;
    Integer index;
    public N and() {
      return (N) ValidatingAdmissionPolicySpecFluentImpl.this.setToValidations(index,builder.build());
    }
    public N endValidation() {
      return and();
    }
    
  }
  
}