package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ParamKindBuilder extends ParamKindFluentImpl<ParamKindBuilder> implements VisitableBuilder<ParamKind,ParamKindBuilder>{
  public ParamKindBuilder() {
    this(false);
  }
  public ParamKindBuilder(Boolean validationEnabled) {
    this(new ParamKind(), validationEnabled);
  }
  public ParamKindBuilder(ParamKindFluent<?> fluent) {
    this(fluent, false);
  }
  public ParamKindBuilder(ParamKindFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ParamKind(), validationEnabled);
  }
  public ParamKindBuilder(ParamKindFluent<?> fluent,ParamKind instance) {
    this(fluent, instance, false);
  }
  public ParamKindBuilder(ParamKindFluent<?> fluent,ParamKind instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ParamKindBuilder(ParamKind instance) {
    this(instance,false);
  }
  public ParamKindBuilder(ParamKind instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ParamKindFluent<?> fluent;
  Boolean validationEnabled;
  public ParamKind build() {
    ParamKind buildable = new ParamKind(fluent.getApiVersion(),fluent.getKind());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}