package io.fabric8.kubernetes.api.model.admissionregistration.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ValidatingWebhookConfigurationListBuilder extends ValidatingWebhookConfigurationListFluentImpl<ValidatingWebhookConfigurationListBuilder> implements VisitableBuilder<ValidatingWebhookConfigurationList,ValidatingWebhookConfigurationListBuilder>{
  public ValidatingWebhookConfigurationListBuilder() {
    this(false);
  }
  public ValidatingWebhookConfigurationListBuilder(Boolean validationEnabled) {
    this(new ValidatingWebhookConfigurationList(), validationEnabled);
  }
  public ValidatingWebhookConfigurationListBuilder(ValidatingWebhookConfigurationListFluent<?> fluent) {
    this(fluent, false);
  }
  public ValidatingWebhookConfigurationListBuilder(ValidatingWebhookConfigurationListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ValidatingWebhookConfigurationList(), validationEnabled);
  }
  public ValidatingWebhookConfigurationListBuilder(ValidatingWebhookConfigurationListFluent<?> fluent,ValidatingWebhookConfigurationList instance) {
    this(fluent, instance, false);
  }
  public ValidatingWebhookConfigurationListBuilder(ValidatingWebhookConfigurationListFluent<?> fluent,ValidatingWebhookConfigurationList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ValidatingWebhookConfigurationListBuilder(ValidatingWebhookConfigurationList instance) {
    this(instance,false);
  }
  public ValidatingWebhookConfigurationListBuilder(ValidatingWebhookConfigurationList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ValidatingWebhookConfigurationListFluent<?> fluent;
  Boolean validationEnabled;
  public ValidatingWebhookConfigurationList build() {
    ValidatingWebhookConfigurationList buildable = new ValidatingWebhookConfigurationList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}