package io.fabric8.kubernetes.api.model.authentication.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SelfSubjectReviewStatusBuilder extends SelfSubjectReviewStatusFluentImpl<SelfSubjectReviewStatusBuilder> implements VisitableBuilder<SelfSubjectReviewStatus,SelfSubjectReviewStatusBuilder>{
  public SelfSubjectReviewStatusBuilder() {
    this(false);
  }
  public SelfSubjectReviewStatusBuilder(Boolean validationEnabled) {
    this(new SelfSubjectReviewStatus(), validationEnabled);
  }
  public SelfSubjectReviewStatusBuilder(SelfSubjectReviewStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public SelfSubjectReviewStatusBuilder(SelfSubjectReviewStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SelfSubjectReviewStatus(), validationEnabled);
  }
  public SelfSubjectReviewStatusBuilder(SelfSubjectReviewStatusFluent<?> fluent,SelfSubjectReviewStatus instance) {
    this(fluent, instance, false);
  }
  public SelfSubjectReviewStatusBuilder(SelfSubjectReviewStatusFluent<?> fluent,SelfSubjectReviewStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withUserInfo(instance.getUserInfo()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SelfSubjectReviewStatusBuilder(SelfSubjectReviewStatus instance) {
    this(instance,false);
  }
  public SelfSubjectReviewStatusBuilder(SelfSubjectReviewStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withUserInfo(instance.getUserInfo()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  SelfSubjectReviewStatusFluent<?> fluent;
  Boolean validationEnabled;
  public SelfSubjectReviewStatus build() {
    SelfSubjectReviewStatus buildable = new SelfSubjectReviewStatus(fluent.getUserInfo());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}