package io.fabric8.kubernetes.api.model.admission.v1beta1;

import io.fabric8.kubernetes.api.model.Status;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface AdmissionResponseFluent<A extends AdmissionResponseFluent<A>> extends Fluent<A>{
  public Boolean getAllowed();
  public A withAllowed(Boolean allowed);
  public Boolean hasAllowed();
  public A addToAuditAnnotations(String key,String value);
  public A addToAuditAnnotations(Map<String,String> map);
  public A removeFromAuditAnnotations(String key);
  public A removeFromAuditAnnotations(Map<String,String> map);
  public Map<String,String> getAuditAnnotations();
  public <K,V>A withAuditAnnotations(Map<String,String> auditAnnotations);
  public Boolean hasAuditAnnotations();
  public String getPatch();
  public A withPatch(String patch);
  public Boolean hasPatch();
  public String getPatchType();
  public A withPatchType(String patchType);
  public Boolean hasPatchType();
  public Status getStatus();
  public A withStatus(Status status);
  public Boolean hasStatus();
  public String getUid();
  public A withUid(String uid);
  public Boolean hasUid();
  public A addToWarnings(int index,String item);
  public A setToWarnings(int index,String item);
  public A addToWarnings(java.lang.String... items);
  public A addAllToWarnings(Collection<String> items);
  public A removeFromWarnings(java.lang.String... items);
  public A removeAllFromWarnings(Collection<String> items);
  public List<String> getWarnings();
  public String getWarning(int index);
  public String getFirstWarning();
  public String getLastWarning();
  public String getMatchingWarning(Predicate<String> predicate);
  public Boolean hasMatchingWarning(Predicate<String> predicate);
  public A withWarnings(List<String> warnings);
  public A withWarnings(java.lang.String... warnings);
  public Boolean hasWarnings();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withAllowed();
  
}