package io.fabric8.kubernetes.api.model.admission.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class AdmissionReviewFluentImpl<A extends AdmissionReviewFluent<A>> extends BaseFluent<A> implements AdmissionReviewFluent<A>{
  public AdmissionReviewFluentImpl() {
  }
  public AdmissionReviewFluentImpl(AdmissionReview instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withRequest(instance.getRequest());
      this.withResponse(instance.getResponse());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private String kind;
  private AdmissionRequest request;
  private AdmissionResponseBuilder response;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  public AdmissionRequest getRequest() {
    return this.request;
  }
  public A withRequest(AdmissionRequest request) {
    this.request=request; return (A) this;
  }
  public Boolean hasRequest() {
    return this.request != null;
  }
  
  /**
   * This method has been deprecated, please use method buildResponse instead.
   * @return The buildable object.
   */
  @Deprecated
  public AdmissionResponse getResponse() {
    return this.response!=null ?this.response.build():null;
  }
  public AdmissionResponse buildResponse() {
    return this.response!=null ?this.response.build():null;
  }
  public A withResponse(AdmissionResponse response) {
    _visitables.get("response").remove(this.response);
    if (response!=null){ this.response= new AdmissionResponseBuilder(response); _visitables.get("response").add(this.response);} else { this.response = null; _visitables.get("response").remove(this.response); } return (A) this;
  }
  public Boolean hasResponse() {
    return this.response != null;
  }
  public AdmissionReviewFluentImpl.ResponseNested<A> withNewResponse() {
    return new AdmissionReviewFluentImpl.ResponseNestedImpl();
  }
  public AdmissionReviewFluentImpl.ResponseNested<A> withNewResponseLike(AdmissionResponse item) {
    return new AdmissionReviewFluentImpl.ResponseNestedImpl(item);
  }
  public AdmissionReviewFluentImpl.ResponseNested<A> editResponse() {
    return withNewResponseLike(getResponse());
  }
  public AdmissionReviewFluentImpl.ResponseNested<A> editOrNewResponse() {
    return withNewResponseLike(getResponse() != null ? getResponse(): new AdmissionResponseBuilder().build());
  }
  public AdmissionReviewFluentImpl.ResponseNested<A> editOrNewResponseLike(AdmissionResponse item) {
    return withNewResponseLike(getResponse() != null ? getResponse(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AdmissionReviewFluentImpl that = (AdmissionReviewFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(request, that.request)) return false;

    if (!java.util.Objects.equals(response, that.response)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  request,  response,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (request != null) { sb.append("request:"); sb.append(request + ","); }
    if (response != null) { sb.append("response:"); sb.append(response + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ResponseNestedImpl<N> extends AdmissionResponseFluentImpl<AdmissionReviewFluentImpl.ResponseNested<N>> implements AdmissionReviewFluentImpl.ResponseNested<N>,Nested<N>{
    ResponseNestedImpl(AdmissionResponse item) {
      this.builder = new AdmissionResponseBuilder(this, item);
    }
    ResponseNestedImpl() {
      this.builder = new AdmissionResponseBuilder(this);
    }
    AdmissionResponseBuilder builder;
    public N and() {
      return (N) AdmissionReviewFluentImpl.this.withResponse(builder.build());
    }
    public N endResponse() {
      return and();
    }
    
  }
  
}