package io.fabric8.kubernetes.api.model.admissionregistration.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MutatingWebhookFluentImpl<A extends MutatingWebhookFluent<A>> extends BaseFluent<A> implements MutatingWebhookFluent<A>{
  public MutatingWebhookFluentImpl() {
  }
  public MutatingWebhookFluentImpl(MutatingWebhook instance) {
    if (instance != null) {
      this.withAdmissionReviewVersions(instance.getAdmissionReviewVersions());
      this.withClientConfig(instance.getClientConfig());
      this.withFailurePolicy(instance.getFailurePolicy());
      this.withMatchPolicy(instance.getMatchPolicy());
      this.withName(instance.getName());
      this.withNamespaceSelector(instance.getNamespaceSelector());
      this.withObjectSelector(instance.getObjectSelector());
      this.withReinvocationPolicy(instance.getReinvocationPolicy());
      this.withRules(instance.getRules());
      this.withSideEffects(instance.getSideEffects());
      this.withTimeoutSeconds(instance.getTimeoutSeconds());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<String> admissionReviewVersions = new ArrayList<String>();
  private WebhookClientConfigBuilder clientConfig;
  private String failurePolicy;
  private String matchPolicy;
  private String name;
  private LabelSelectorBuilder namespaceSelector;
  private LabelSelectorBuilder objectSelector;
  private String reinvocationPolicy;
  private ArrayList<RuleWithOperationsBuilder> rules = new ArrayList<RuleWithOperationsBuilder>();
  private String sideEffects;
  private Integer timeoutSeconds;
  private Map<String,Object> additionalProperties;
  public A addToAdmissionReviewVersions(int index,String item) {
    if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
    this.admissionReviewVersions.add(index, item);
    return (A)this;
  }
  public A setToAdmissionReviewVersions(int index,String item) {
    if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
    this.admissionReviewVersions.set(index, item); return (A)this;
  }
  public A addToAdmissionReviewVersions(java.lang.String... items) {
    if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
    for (String item : items) {this.admissionReviewVersions.add(item);} return (A)this;
  }
  public A addAllToAdmissionReviewVersions(Collection<String> items) {
    if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
    for (String item : items) {this.admissionReviewVersions.add(item);} return (A)this;
  }
  public A removeFromAdmissionReviewVersions(java.lang.String... items) {
    for (String item : items) {if (this.admissionReviewVersions!= null){ this.admissionReviewVersions.remove(item);}} return (A)this;
  }
  public A removeAllFromAdmissionReviewVersions(Collection<String> items) {
    for (String item : items) {if (this.admissionReviewVersions!= null){ this.admissionReviewVersions.remove(item);}} return (A)this;
  }
  public List<String> getAdmissionReviewVersions() {
    return this.admissionReviewVersions;
  }
  public String getAdmissionReviewVersion(int index) {
    return this.admissionReviewVersions.get(index);
  }
  public String getFirstAdmissionReviewVersion() {
    return this.admissionReviewVersions.get(0);
  }
  public String getLastAdmissionReviewVersion() {
    return this.admissionReviewVersions.get(admissionReviewVersions.size() - 1);
  }
  public String getMatchingAdmissionReviewVersion(Predicate<String> predicate) {
    for (String item: admissionReviewVersions) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAdmissionReviewVersion(Predicate<String> predicate) {
    for (String item: admissionReviewVersions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAdmissionReviewVersions(List<String> admissionReviewVersions) {
    if (admissionReviewVersions != null) {this.admissionReviewVersions = new ArrayList(); for (String item : admissionReviewVersions){this.addToAdmissionReviewVersions(item);}} else { this.admissionReviewVersions = null;} return (A) this;
  }
  public A withAdmissionReviewVersions(java.lang.String... admissionReviewVersions) {
    if (this.admissionReviewVersions != null) {this.admissionReviewVersions.clear(); _visitables.remove("admissionReviewVersions"); }
    if (admissionReviewVersions != null) {for (String item :admissionReviewVersions){ this.addToAdmissionReviewVersions(item);}} return (A) this;
  }
  public Boolean hasAdmissionReviewVersions() {
    return admissionReviewVersions != null && !admissionReviewVersions.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildClientConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public WebhookClientConfig getClientConfig() {
    return this.clientConfig!=null ?this.clientConfig.build():null;
  }
  public WebhookClientConfig buildClientConfig() {
    return this.clientConfig!=null ?this.clientConfig.build():null;
  }
  public A withClientConfig(WebhookClientConfig clientConfig) {
    _visitables.get("clientConfig").remove(this.clientConfig);
    if (clientConfig!=null){ this.clientConfig= new WebhookClientConfigBuilder(clientConfig); _visitables.get("clientConfig").add(this.clientConfig);} else { this.clientConfig = null; _visitables.get("clientConfig").remove(this.clientConfig); } return (A) this;
  }
  public Boolean hasClientConfig() {
    return this.clientConfig != null;
  }
  public MutatingWebhookFluentImpl.ClientConfigNested<A> withNewClientConfig() {
    return new MutatingWebhookFluentImpl.ClientConfigNestedImpl();
  }
  public MutatingWebhookFluentImpl.ClientConfigNested<A> withNewClientConfigLike(WebhookClientConfig item) {
    return new MutatingWebhookFluentImpl.ClientConfigNestedImpl(item);
  }
  public MutatingWebhookFluentImpl.ClientConfigNested<A> editClientConfig() {
    return withNewClientConfigLike(getClientConfig());
  }
  public MutatingWebhookFluentImpl.ClientConfigNested<A> editOrNewClientConfig() {
    return withNewClientConfigLike(getClientConfig() != null ? getClientConfig(): new WebhookClientConfigBuilder().build());
  }
  public MutatingWebhookFluentImpl.ClientConfigNested<A> editOrNewClientConfigLike(WebhookClientConfig item) {
    return withNewClientConfigLike(getClientConfig() != null ? getClientConfig(): item);
  }
  public String getFailurePolicy() {
    return this.failurePolicy;
  }
  public A withFailurePolicy(String failurePolicy) {
    this.failurePolicy=failurePolicy; return (A) this;
  }
  public Boolean hasFailurePolicy() {
    return this.failurePolicy != null;
  }
  public String getMatchPolicy() {
    return this.matchPolicy;
  }
  public A withMatchPolicy(String matchPolicy) {
    this.matchPolicy=matchPolicy; return (A) this;
  }
  public Boolean hasMatchPolicy() {
    return this.matchPolicy != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  
  /**
   * This method has been deprecated, please use method buildNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public LabelSelector buildNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public A withNamespaceSelector(LabelSelector namespaceSelector) {
    _visitables.get("namespaceSelector").remove(this.namespaceSelector);
    if (namespaceSelector!=null){ this.namespaceSelector= new LabelSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} else { this.namespaceSelector = null; _visitables.get("namespaceSelector").remove(this.namespaceSelector); } return (A) this;
  }
  public Boolean hasNamespaceSelector() {
    return this.namespaceSelector != null;
  }
  public MutatingWebhookFluentImpl.NamespaceSelectorNested<A> withNewNamespaceSelector() {
    return new MutatingWebhookFluentImpl.NamespaceSelectorNestedImpl();
  }
  public MutatingWebhookFluentImpl.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
    return new MutatingWebhookFluentImpl.NamespaceSelectorNestedImpl(item);
  }
  public MutatingWebhookFluentImpl.NamespaceSelectorNested<A> editNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector());
  }
  public MutatingWebhookFluentImpl.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): new LabelSelectorBuilder().build());
  }
  public MutatingWebhookFluentImpl.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildObjectSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getObjectSelector() {
    return this.objectSelector!=null ?this.objectSelector.build():null;
  }
  public LabelSelector buildObjectSelector() {
    return this.objectSelector!=null ?this.objectSelector.build():null;
  }
  public A withObjectSelector(LabelSelector objectSelector) {
    _visitables.get("objectSelector").remove(this.objectSelector);
    if (objectSelector!=null){ this.objectSelector= new LabelSelectorBuilder(objectSelector); _visitables.get("objectSelector").add(this.objectSelector);} else { this.objectSelector = null; _visitables.get("objectSelector").remove(this.objectSelector); } return (A) this;
  }
  public Boolean hasObjectSelector() {
    return this.objectSelector != null;
  }
  public MutatingWebhookFluentImpl.ObjectSelectorNested<A> withNewObjectSelector() {
    return new MutatingWebhookFluentImpl.ObjectSelectorNestedImpl();
  }
  public MutatingWebhookFluentImpl.ObjectSelectorNested<A> withNewObjectSelectorLike(LabelSelector item) {
    return new MutatingWebhookFluentImpl.ObjectSelectorNestedImpl(item);
  }
  public MutatingWebhookFluentImpl.ObjectSelectorNested<A> editObjectSelector() {
    return withNewObjectSelectorLike(getObjectSelector());
  }
  public MutatingWebhookFluentImpl.ObjectSelectorNested<A> editOrNewObjectSelector() {
    return withNewObjectSelectorLike(getObjectSelector() != null ? getObjectSelector(): new LabelSelectorBuilder().build());
  }
  public MutatingWebhookFluentImpl.ObjectSelectorNested<A> editOrNewObjectSelectorLike(LabelSelector item) {
    return withNewObjectSelectorLike(getObjectSelector() != null ? getObjectSelector(): item);
  }
  public String getReinvocationPolicy() {
    return this.reinvocationPolicy;
  }
  public A withReinvocationPolicy(String reinvocationPolicy) {
    this.reinvocationPolicy=reinvocationPolicy; return (A) this;
  }
  public Boolean hasReinvocationPolicy() {
    return this.reinvocationPolicy != null;
  }
  public A addToRules(int index,RuleWithOperations item) {
    if (this.rules == null) {this.rules = new ArrayList<RuleWithOperationsBuilder>();}
    RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);
    if (index < 0 || index >= rules.size()) { _visitables.get("rules").add(builder); rules.add(builder); } else { _visitables.get("rules").add(index, builder); rules.add(index, builder);}
    return (A)this;
  }
  public A setToRules(int index,RuleWithOperations item) {
    if (this.rules == null) {this.rules = new ArrayList<RuleWithOperationsBuilder>();}
    RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);
    if (index < 0 || index >= rules.size()) { _visitables.get("rules").add(builder); rules.add(builder); } else { _visitables.get("rules").set(index, builder); rules.set(index, builder);}
    return (A)this;
  }
  public A addToRules(io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations... items) {
    if (this.rules == null) {this.rules = new ArrayList<RuleWithOperationsBuilder>();}
    for (RuleWithOperations item : items) {RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  public A addAllToRules(Collection<RuleWithOperations> items) {
    if (this.rules == null) {this.rules = new ArrayList<RuleWithOperationsBuilder>();}
    for (RuleWithOperations item : items) {RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  public A removeFromRules(io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations... items) {
    for (RuleWithOperations item : items) {RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
  }
  public A removeAllFromRules(Collection<RuleWithOperations> items) {
    for (RuleWithOperations item : items) {RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRules(Predicate<RuleWithOperationsBuilder> predicate) {
    if (rules == null) return (A) this;
    final Iterator<RuleWithOperationsBuilder> each = rules.iterator();
    final List visitables = _visitables.get("rules");
    while (each.hasNext()) {
      RuleWithOperationsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRules instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<RuleWithOperations> getRules() {
    return rules != null ? build(rules) : null;
  }
  public List<RuleWithOperations> buildRules() {
    return rules != null ? build(rules) : null;
  }
  public RuleWithOperations buildRule(int index) {
    return this.rules.get(index).build();
  }
  public RuleWithOperations buildFirstRule() {
    return this.rules.get(0).build();
  }
  public RuleWithOperations buildLastRule() {
    return this.rules.get(rules.size() - 1).build();
  }
  public RuleWithOperations buildMatchingRule(Predicate<RuleWithOperationsBuilder> predicate) {
    for (RuleWithOperationsBuilder item: rules) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingRule(Predicate<RuleWithOperationsBuilder> predicate) {
    for (RuleWithOperationsBuilder item: rules) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRules(List<RuleWithOperations> rules) {
    if (this.rules != null) { _visitables.get("rules").clear();}
    if (rules != null) {this.rules = new ArrayList(); for (RuleWithOperations item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
  }
  public A withRules(io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations... rules) {
    if (this.rules != null) {this.rules.clear(); _visitables.remove("rules"); }
    if (rules != null) {for (RuleWithOperations item :rules){ this.addToRules(item);}} return (A) this;
  }
  public Boolean hasRules() {
    return rules != null && !rules.isEmpty();
  }
  public MutatingWebhookFluentImpl.RulesNested<A> addNewRule() {
    return new MutatingWebhookFluentImpl.RulesNestedImpl();
  }
  public MutatingWebhookFluentImpl.RulesNested<A> addNewRuleLike(RuleWithOperations item) {
    return new MutatingWebhookFluentImpl.RulesNestedImpl(-1, item);
  }
  public MutatingWebhookFluentImpl.RulesNested<A> setNewRuleLike(int index,RuleWithOperations item) {
    return new MutatingWebhookFluentImpl.RulesNestedImpl(index, item);
  }
  public MutatingWebhookFluentImpl.RulesNested<A> editRule(int index) {
    if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
    return setNewRuleLike(index, buildRule(index));
  }
  public MutatingWebhookFluentImpl.RulesNested<A> editFirstRule() {
    if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
    return setNewRuleLike(0, buildRule(0));
  }
  public MutatingWebhookFluentImpl.RulesNested<A> editLastRule() {
    int index = rules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
    return setNewRuleLike(index, buildRule(index));
  }
  public MutatingWebhookFluentImpl.RulesNested<A> editMatchingRule(Predicate<RuleWithOperationsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<rules.size();i++) { 
    if (predicate.test(rules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
    return setNewRuleLike(index, buildRule(index));
  }
  public String getSideEffects() {
    return this.sideEffects;
  }
  public A withSideEffects(String sideEffects) {
    this.sideEffects=sideEffects; return (A) this;
  }
  public Boolean hasSideEffects() {
    return this.sideEffects != null;
  }
  public Integer getTimeoutSeconds() {
    return this.timeoutSeconds;
  }
  public A withTimeoutSeconds(Integer timeoutSeconds) {
    this.timeoutSeconds=timeoutSeconds; return (A) this;
  }
  public Boolean hasTimeoutSeconds() {
    return this.timeoutSeconds != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MutatingWebhookFluentImpl that = (MutatingWebhookFluentImpl) o;
    if (!java.util.Objects.equals(admissionReviewVersions, that.admissionReviewVersions)) return false;

    if (!java.util.Objects.equals(clientConfig, that.clientConfig)) return false;

    if (!java.util.Objects.equals(failurePolicy, that.failurePolicy)) return false;

    if (!java.util.Objects.equals(matchPolicy, that.matchPolicy)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(namespaceSelector, that.namespaceSelector)) return false;

    if (!java.util.Objects.equals(objectSelector, that.objectSelector)) return false;

    if (!java.util.Objects.equals(reinvocationPolicy, that.reinvocationPolicy)) return false;

    if (!java.util.Objects.equals(rules, that.rules)) return false;

    if (!java.util.Objects.equals(sideEffects, that.sideEffects)) return false;

    if (!java.util.Objects.equals(timeoutSeconds, that.timeoutSeconds)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(admissionReviewVersions,  clientConfig,  failurePolicy,  matchPolicy,  name,  namespaceSelector,  objectSelector,  reinvocationPolicy,  rules,  sideEffects,  timeoutSeconds,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (admissionReviewVersions != null && !admissionReviewVersions.isEmpty()) { sb.append("admissionReviewVersions:"); sb.append(admissionReviewVersions + ","); }
    if (clientConfig != null) { sb.append("clientConfig:"); sb.append(clientConfig + ","); }
    if (failurePolicy != null) { sb.append("failurePolicy:"); sb.append(failurePolicy + ","); }
    if (matchPolicy != null) { sb.append("matchPolicy:"); sb.append(matchPolicy + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (namespaceSelector != null) { sb.append("namespaceSelector:"); sb.append(namespaceSelector + ","); }
    if (objectSelector != null) { sb.append("objectSelector:"); sb.append(objectSelector + ","); }
    if (reinvocationPolicy != null) { sb.append("reinvocationPolicy:"); sb.append(reinvocationPolicy + ","); }
    if (rules != null && !rules.isEmpty()) { sb.append("rules:"); sb.append(rules + ","); }
    if (sideEffects != null) { sb.append("sideEffects:"); sb.append(sideEffects + ","); }
    if (timeoutSeconds != null) { sb.append("timeoutSeconds:"); sb.append(timeoutSeconds + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ClientConfigNestedImpl<N> extends WebhookClientConfigFluentImpl<MutatingWebhookFluentImpl.ClientConfigNested<N>> implements MutatingWebhookFluentImpl.ClientConfigNested<N>,Nested<N>{
    ClientConfigNestedImpl(WebhookClientConfig item) {
      this.builder = new WebhookClientConfigBuilder(this, item);
    }
    ClientConfigNestedImpl() {
      this.builder = new WebhookClientConfigBuilder(this);
    }
    WebhookClientConfigBuilder builder;
    public N and() {
      return (N) MutatingWebhookFluentImpl.this.withClientConfig(builder.build());
    }
    public N endClientConfig() {
      return and();
    }
    
  }
  class NamespaceSelectorNestedImpl<N> extends LabelSelectorFluentImpl<MutatingWebhookFluentImpl.NamespaceSelectorNested<N>> implements MutatingWebhookFluentImpl.NamespaceSelectorNested<N>,Nested<N>{
    NamespaceSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    NamespaceSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) MutatingWebhookFluentImpl.this.withNamespaceSelector(builder.build());
    }
    public N endNamespaceSelector() {
      return and();
    }
    
  }
  class ObjectSelectorNestedImpl<N> extends LabelSelectorFluentImpl<MutatingWebhookFluentImpl.ObjectSelectorNested<N>> implements MutatingWebhookFluentImpl.ObjectSelectorNested<N>,Nested<N>{
    ObjectSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    ObjectSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) MutatingWebhookFluentImpl.this.withObjectSelector(builder.build());
    }
    public N endObjectSelector() {
      return and();
    }
    
  }
  class RulesNestedImpl<N> extends RuleWithOperationsFluentImpl<MutatingWebhookFluentImpl.RulesNested<N>> implements MutatingWebhookFluentImpl.RulesNested<N>,Nested<N>{
    RulesNestedImpl(int index,RuleWithOperations item) {
      this.index = index;
      this.builder = new RuleWithOperationsBuilder(this, item);
    }
    RulesNestedImpl() {
      this.index = -1;
      this.builder = new RuleWithOperationsBuilder(this);
    }
    RuleWithOperationsBuilder builder;
    int index;
    public N and() {
      return (N) MutatingWebhookFluentImpl.this.setToRules(index,builder.build());
    }
    public N endRule() {
      return and();
    }
    
  }
  
}