package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ValidatingAdmissionPolicyBindingFluentImpl<A extends ValidatingAdmissionPolicyBindingFluent<A>> extends BaseFluent<A> implements ValidatingAdmissionPolicyBindingFluent<A>{
  public ValidatingAdmissionPolicyBindingFluentImpl() {
  }
  public ValidatingAdmissionPolicyBindingFluentImpl(ValidatingAdmissionPolicyBinding instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private ValidatingAdmissionPolicyBindingSpecBuilder spec;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ValidatingAdmissionPolicyBindingFluentImpl.MetadataNested<A> withNewMetadata() {
    return new ValidatingAdmissionPolicyBindingFluentImpl.MetadataNestedImpl();
  }
  public ValidatingAdmissionPolicyBindingFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new ValidatingAdmissionPolicyBindingFluentImpl.MetadataNestedImpl(item);
  }
  public ValidatingAdmissionPolicyBindingFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public ValidatingAdmissionPolicyBindingFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public ValidatingAdmissionPolicyBindingFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public ValidatingAdmissionPolicyBindingSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public ValidatingAdmissionPolicyBindingSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(ValidatingAdmissionPolicyBindingSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new ValidatingAdmissionPolicyBindingSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public ValidatingAdmissionPolicyBindingFluentImpl.SpecNested<A> withNewSpec() {
    return new ValidatingAdmissionPolicyBindingFluentImpl.SpecNestedImpl();
  }
  public ValidatingAdmissionPolicyBindingFluentImpl.SpecNested<A> withNewSpecLike(ValidatingAdmissionPolicyBindingSpec item) {
    return new ValidatingAdmissionPolicyBindingFluentImpl.SpecNestedImpl(item);
  }
  public ValidatingAdmissionPolicyBindingFluentImpl.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public ValidatingAdmissionPolicyBindingFluentImpl.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new ValidatingAdmissionPolicyBindingSpecBuilder().build());
  }
  public ValidatingAdmissionPolicyBindingFluentImpl.SpecNested<A> editOrNewSpecLike(ValidatingAdmissionPolicyBindingSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ValidatingAdmissionPolicyBindingFluentImpl that = (ValidatingAdmissionPolicyBindingFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(spec, that.spec)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ValidatingAdmissionPolicyBindingFluentImpl.MetadataNested<N>> implements ValidatingAdmissionPolicyBindingFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ValidatingAdmissionPolicyBindingFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends ValidatingAdmissionPolicyBindingSpecFluentImpl<ValidatingAdmissionPolicyBindingFluentImpl.SpecNested<N>> implements ValidatingAdmissionPolicyBindingFluentImpl.SpecNested<N>,Nested<N>{
    SpecNestedImpl(ValidatingAdmissionPolicyBindingSpec item) {
      this.builder = new ValidatingAdmissionPolicyBindingSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new ValidatingAdmissionPolicyBindingSpecBuilder(this);
    }
    ValidatingAdmissionPolicyBindingSpecBuilder builder;
    public N and() {
      return (N) ValidatingAdmissionPolicyBindingFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  
}