package io.fabric8.kubernetes.api.model.authorization.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceRuleBuilder extends ResourceRuleFluentImpl<ResourceRuleBuilder> implements VisitableBuilder<ResourceRule,ResourceRuleBuilder>{
  public ResourceRuleBuilder() {
    this(false);
  }
  public ResourceRuleBuilder(Boolean validationEnabled) {
    this(new ResourceRule(), validationEnabled);
  }
  public ResourceRuleBuilder(ResourceRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceRuleBuilder(ResourceRuleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceRule(), validationEnabled);
  }
  public ResourceRuleBuilder(ResourceRuleFluent<?> fluent,ResourceRule instance) {
    this(fluent, instance, false);
  }
  public ResourceRuleBuilder(ResourceRuleFluent<?> fluent,ResourceRule instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiGroups(instance.getApiGroups());
      fluent.withResourceNames(instance.getResourceNames());
      fluent.withResources(instance.getResources());
      fluent.withVerbs(instance.getVerbs());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ResourceRuleBuilder(ResourceRule instance) {
    this(instance,false);
  }
  public ResourceRuleBuilder(ResourceRule instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiGroups(instance.getApiGroups());
      this.withResourceNames(instance.getResourceNames());
      this.withResources(instance.getResources());
      this.withVerbs(instance.getVerbs());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ResourceRuleFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceRule build() {
    ResourceRule buildable = new ResourceRule(fluent.getApiGroups(),fluent.getResourceNames(),fluent.getResources(),fluent.getVerbs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}