package io.fabric8.kubernetes.api.model.admission.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AdmissionReviewBuilder extends AdmissionReviewFluentImpl<AdmissionReviewBuilder> implements VisitableBuilder<AdmissionReview,AdmissionReviewBuilder>{
  public AdmissionReviewBuilder() {
    this(false);
  }
  public AdmissionReviewBuilder(Boolean validationEnabled) {
    this(new AdmissionReview(), validationEnabled);
  }
  public AdmissionReviewBuilder(AdmissionReviewFluent<?> fluent) {
    this(fluent, false);
  }
  public AdmissionReviewBuilder(AdmissionReviewFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AdmissionReview(), validationEnabled);
  }
  public AdmissionReviewBuilder(AdmissionReviewFluent<?> fluent,AdmissionReview instance) {
    this(fluent, instance, false);
  }
  public AdmissionReviewBuilder(AdmissionReviewFluent<?> fluent,AdmissionReview instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withRequest(instance.getRequest());
      fluent.withResponse(instance.getResponse());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AdmissionReviewBuilder(AdmissionReview instance) {
    this(instance,false);
  }
  public AdmissionReviewBuilder(AdmissionReview instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withRequest(instance.getRequest());
      this.withResponse(instance.getResponse());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AdmissionReviewFluent<?> fluent;
  Boolean validationEnabled;
  public AdmissionReview build() {
    AdmissionReview buildable = new AdmissionReview(fluent.getApiVersion(),fluent.getKind(),fluent.getRequest(),fluent.getResponse());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}