package io.fabric8.kubernetes.api.model.admission.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface AdmissionReviewFluent<A extends AdmissionReviewFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public AdmissionRequest getRequest();
  public A withRequest(AdmissionRequest request);
  public Boolean hasRequest();
  
  /**
   * This method has been deprecated, please use method buildResponse instead.
   * @return The buildable object.
   */
  @Deprecated
  public AdmissionResponse getResponse();
  public AdmissionResponse buildResponse();
  public A withResponse(AdmissionResponse response);
  public Boolean hasResponse();
  public AdmissionReviewFluent.ResponseNested<A> withNewResponse();
  public AdmissionReviewFluent.ResponseNested<A> withNewResponseLike(AdmissionResponse item);
  public AdmissionReviewFluent.ResponseNested<A> editResponse();
  public AdmissionReviewFluent.ResponseNested<A> editOrNewResponse();
  public AdmissionReviewFluent.ResponseNested<A> editOrNewResponseLike(AdmissionResponse item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ResponseNested<N> extends Nested<N>,AdmissionResponseFluent<AdmissionReviewFluent.ResponseNested<N>>{
    public N and();
    public N endResponse();
    
  }
  
}