package io.fabric8.kubernetes.api.model.admissionregistration.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MutatingWebhookConfigurationFluentImpl<A extends MutatingWebhookConfigurationFluent<A>> extends BaseFluent<A> implements MutatingWebhookConfigurationFluent<A>{
  public MutatingWebhookConfigurationFluentImpl() {
  }
  public MutatingWebhookConfigurationFluentImpl(MutatingWebhookConfiguration instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withWebhooks(instance.getWebhooks());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private ArrayList<MutatingWebhookBuilder> webhooks = new ArrayList<MutatingWebhookBuilder>();
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public MutatingWebhookConfigurationFluentImpl.MetadataNested<A> withNewMetadata() {
    return new MutatingWebhookConfigurationFluentImpl.MetadataNestedImpl();
  }
  public MutatingWebhookConfigurationFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new MutatingWebhookConfigurationFluentImpl.MetadataNestedImpl(item);
  }
  public MutatingWebhookConfigurationFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public MutatingWebhookConfigurationFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public MutatingWebhookConfigurationFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public A addToWebhooks(int index,MutatingWebhook item) {
    if (this.webhooks == null) {this.webhooks = new ArrayList<MutatingWebhookBuilder>();}
    MutatingWebhookBuilder builder = new MutatingWebhookBuilder(item);
    if (index < 0 || index >= webhooks.size()) { _visitables.get("webhooks").add(builder); webhooks.add(builder); } else { _visitables.get("webhooks").add(index, builder); webhooks.add(index, builder);}
    return (A)this;
  }
  public A setToWebhooks(int index,MutatingWebhook item) {
    if (this.webhooks == null) {this.webhooks = new ArrayList<MutatingWebhookBuilder>();}
    MutatingWebhookBuilder builder = new MutatingWebhookBuilder(item);
    if (index < 0 || index >= webhooks.size()) { _visitables.get("webhooks").add(builder); webhooks.add(builder); } else { _visitables.get("webhooks").set(index, builder); webhooks.set(index, builder);}
    return (A)this;
  }
  public A addToWebhooks(io.fabric8.kubernetes.api.model.admissionregistration.v1.MutatingWebhook... items) {
    if (this.webhooks == null) {this.webhooks = new ArrayList<MutatingWebhookBuilder>();}
    for (MutatingWebhook item : items) {MutatingWebhookBuilder builder = new MutatingWebhookBuilder(item);_visitables.get("webhooks").add(builder);this.webhooks.add(builder);} return (A)this;
  }
  public A addAllToWebhooks(Collection<MutatingWebhook> items) {
    if (this.webhooks == null) {this.webhooks = new ArrayList<MutatingWebhookBuilder>();}
    for (MutatingWebhook item : items) {MutatingWebhookBuilder builder = new MutatingWebhookBuilder(item);_visitables.get("webhooks").add(builder);this.webhooks.add(builder);} return (A)this;
  }
  public A removeFromWebhooks(io.fabric8.kubernetes.api.model.admissionregistration.v1.MutatingWebhook... items) {
    for (MutatingWebhook item : items) {MutatingWebhookBuilder builder = new MutatingWebhookBuilder(item);_visitables.get("webhooks").remove(builder);if (this.webhooks != null) {this.webhooks.remove(builder);}} return (A)this;
  }
  public A removeAllFromWebhooks(Collection<MutatingWebhook> items) {
    for (MutatingWebhook item : items) {MutatingWebhookBuilder builder = new MutatingWebhookBuilder(item);_visitables.get("webhooks").remove(builder);if (this.webhooks != null) {this.webhooks.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromWebhooks(Predicate<MutatingWebhookBuilder> predicate) {
    if (webhooks == null) return (A) this;
    final Iterator<MutatingWebhookBuilder> each = webhooks.iterator();
    final List visitables = _visitables.get("webhooks");
    while (each.hasNext()) {
      MutatingWebhookBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildWebhooks instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<MutatingWebhook> getWebhooks() {
    return webhooks != null ? build(webhooks) : null;
  }
  public List<MutatingWebhook> buildWebhooks() {
    return webhooks != null ? build(webhooks) : null;
  }
  public MutatingWebhook buildWebhook(int index) {
    return this.webhooks.get(index).build();
  }
  public MutatingWebhook buildFirstWebhook() {
    return this.webhooks.get(0).build();
  }
  public MutatingWebhook buildLastWebhook() {
    return this.webhooks.get(webhooks.size() - 1).build();
  }
  public MutatingWebhook buildMatchingWebhook(Predicate<MutatingWebhookBuilder> predicate) {
    for (MutatingWebhookBuilder item: webhooks) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingWebhook(Predicate<MutatingWebhookBuilder> predicate) {
    for (MutatingWebhookBuilder item: webhooks) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withWebhooks(List<MutatingWebhook> webhooks) {
    if (this.webhooks != null) { _visitables.get("webhooks").clear();}
    if (webhooks != null) {this.webhooks = new ArrayList(); for (MutatingWebhook item : webhooks){this.addToWebhooks(item);}} else { this.webhooks = null;} return (A) this;
  }
  public A withWebhooks(io.fabric8.kubernetes.api.model.admissionregistration.v1.MutatingWebhook... webhooks) {
    if (this.webhooks != null) {this.webhooks.clear(); _visitables.remove("webhooks"); }
    if (webhooks != null) {for (MutatingWebhook item :webhooks){ this.addToWebhooks(item);}} return (A) this;
  }
  public Boolean hasWebhooks() {
    return webhooks != null && !webhooks.isEmpty();
  }
  public MutatingWebhookConfigurationFluentImpl.WebhooksNested<A> addNewWebhook() {
    return new MutatingWebhookConfigurationFluentImpl.WebhooksNestedImpl();
  }
  public MutatingWebhookConfigurationFluentImpl.WebhooksNested<A> addNewWebhookLike(MutatingWebhook item) {
    return new MutatingWebhookConfigurationFluentImpl.WebhooksNestedImpl(-1, item);
  }
  public MutatingWebhookConfigurationFluentImpl.WebhooksNested<A> setNewWebhookLike(int index,MutatingWebhook item) {
    return new MutatingWebhookConfigurationFluentImpl.WebhooksNestedImpl(index, item);
  }
  public MutatingWebhookConfigurationFluentImpl.WebhooksNested<A> editWebhook(int index) {
    if (webhooks.size() <= index) throw new RuntimeException("Can't edit webhooks. Index exceeds size.");
    return setNewWebhookLike(index, buildWebhook(index));
  }
  public MutatingWebhookConfigurationFluentImpl.WebhooksNested<A> editFirstWebhook() {
    if (webhooks.size() == 0) throw new RuntimeException("Can't edit first webhooks. The list is empty.");
    return setNewWebhookLike(0, buildWebhook(0));
  }
  public MutatingWebhookConfigurationFluentImpl.WebhooksNested<A> editLastWebhook() {
    int index = webhooks.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last webhooks. The list is empty.");
    return setNewWebhookLike(index, buildWebhook(index));
  }
  public MutatingWebhookConfigurationFluentImpl.WebhooksNested<A> editMatchingWebhook(Predicate<MutatingWebhookBuilder> predicate) {
    int index = -1;
    for (int i=0;i<webhooks.size();i++) { 
    if (predicate.test(webhooks.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching webhooks. No match found.");
    return setNewWebhookLike(index, buildWebhook(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MutatingWebhookConfigurationFluentImpl that = (MutatingWebhookConfigurationFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(webhooks, that.webhooks)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  webhooks,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (webhooks != null && !webhooks.isEmpty()) { sb.append("webhooks:"); sb.append(webhooks + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MutatingWebhookConfigurationFluentImpl.MetadataNested<N>> implements MutatingWebhookConfigurationFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) MutatingWebhookConfigurationFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class WebhooksNestedImpl<N> extends MutatingWebhookFluentImpl<MutatingWebhookConfigurationFluentImpl.WebhooksNested<N>> implements MutatingWebhookConfigurationFluentImpl.WebhooksNested<N>,Nested<N>{
    WebhooksNestedImpl(int index,MutatingWebhook item) {
      this.index = index;
      this.builder = new MutatingWebhookBuilder(this, item);
    }
    WebhooksNestedImpl() {
      this.index = -1;
      this.builder = new MutatingWebhookBuilder(this);
    }
    MutatingWebhookBuilder builder;
    int index;
    public N and() {
      return (N) MutatingWebhookConfigurationFluentImpl.this.setToWebhooks(index,builder.build());
    }
    public N endWebhook() {
      return and();
    }
    
  }
  
}