package io.fabric8.kubernetes.api.model.authentication;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface TokenRequestFluent<A extends TokenRequestFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public TokenRequestFluent.MetadataNested<A> withNewMetadata();
  public TokenRequestFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public TokenRequestFluent.MetadataNested<A> editMetadata();
  public TokenRequestFluent.MetadataNested<A> editOrNewMetadata();
  public TokenRequestFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public TokenRequestSpec getSpec();
  public TokenRequestSpec buildSpec();
  public A withSpec(TokenRequestSpec spec);
  public Boolean hasSpec();
  public TokenRequestFluent.SpecNested<A> withNewSpec();
  public TokenRequestFluent.SpecNested<A> withNewSpecLike(TokenRequestSpec item);
  public TokenRequestFluent.SpecNested<A> editSpec();
  public TokenRequestFluent.SpecNested<A> editOrNewSpec();
  public TokenRequestFluent.SpecNested<A> editOrNewSpecLike(TokenRequestSpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public TokenRequestStatus getStatus();
  public TokenRequestStatus buildStatus();
  public A withStatus(TokenRequestStatus status);
  public Boolean hasStatus();
  public A withNewStatus(String expirationTimestamp,String token);
  public TokenRequestFluent.StatusNested<A> withNewStatus();
  public TokenRequestFluent.StatusNested<A> withNewStatusLike(TokenRequestStatus item);
  public TokenRequestFluent.StatusNested<A> editStatus();
  public TokenRequestFluent.StatusNested<A> editOrNewStatus();
  public TokenRequestFluent.StatusNested<A> editOrNewStatusLike(TokenRequestStatus item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<TokenRequestFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,TokenRequestSpecFluent<TokenRequestFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,TokenRequestStatusFluent<TokenRequestFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}