package io.fabric8.kubernetes.api.model.authentication;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TokenRequestSpecFluentImpl<A extends TokenRequestSpecFluent<A>> extends BaseFluent<A> implements TokenRequestSpecFluent<A>{
  public TokenRequestSpecFluentImpl() {
  }
  public TokenRequestSpecFluentImpl(TokenRequestSpec instance) {
    if (instance != null) {
      this.withAudiences(instance.getAudiences());
      this.withBoundObjectRef(instance.getBoundObjectRef());
      this.withExpirationSeconds(instance.getExpirationSeconds());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<String> audiences = new ArrayList<String>();
  private BoundObjectReferenceBuilder boundObjectRef;
  private Long expirationSeconds;
  private Map<String,Object> additionalProperties;
  public A addToAudiences(int index,String item) {
    if (this.audiences == null) {this.audiences = new ArrayList<String>();}
    this.audiences.add(index, item);
    return (A)this;
  }
  public A setToAudiences(int index,String item) {
    if (this.audiences == null) {this.audiences = new ArrayList<String>();}
    this.audiences.set(index, item); return (A)this;
  }
  public A addToAudiences(java.lang.String... items) {
    if (this.audiences == null) {this.audiences = new ArrayList<String>();}
    for (String item : items) {this.audiences.add(item);} return (A)this;
  }
  public A addAllToAudiences(Collection<String> items) {
    if (this.audiences == null) {this.audiences = new ArrayList<String>();}
    for (String item : items) {this.audiences.add(item);} return (A)this;
  }
  public A removeFromAudiences(java.lang.String... items) {
    for (String item : items) {if (this.audiences!= null){ this.audiences.remove(item);}} return (A)this;
  }
  public A removeAllFromAudiences(Collection<String> items) {
    for (String item : items) {if (this.audiences!= null){ this.audiences.remove(item);}} return (A)this;
  }
  public List<String> getAudiences() {
    return this.audiences;
  }
  public String getAudience(int index) {
    return this.audiences.get(index);
  }
  public String getFirstAudience() {
    return this.audiences.get(0);
  }
  public String getLastAudience() {
    return this.audiences.get(audiences.size() - 1);
  }
  public String getMatchingAudience(Predicate<String> predicate) {
    for (String item: audiences) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAudience(Predicate<String> predicate) {
    for (String item: audiences) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAudiences(List<String> audiences) {
    if (audiences != null) {this.audiences = new ArrayList(); for (String item : audiences){this.addToAudiences(item);}} else { this.audiences = null;} return (A) this;
  }
  public A withAudiences(java.lang.String... audiences) {
    if (this.audiences != null) {this.audiences.clear(); _visitables.remove("audiences"); }
    if (audiences != null) {for (String item :audiences){ this.addToAudiences(item);}} return (A) this;
  }
  public Boolean hasAudiences() {
    return audiences != null && !audiences.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildBoundObjectRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public BoundObjectReference getBoundObjectRef() {
    return this.boundObjectRef!=null ?this.boundObjectRef.build():null;
  }
  public BoundObjectReference buildBoundObjectRef() {
    return this.boundObjectRef!=null ?this.boundObjectRef.build():null;
  }
  public A withBoundObjectRef(BoundObjectReference boundObjectRef) {
    _visitables.get("boundObjectRef").remove(this.boundObjectRef);
    if (boundObjectRef!=null){ this.boundObjectRef= new BoundObjectReferenceBuilder(boundObjectRef); _visitables.get("boundObjectRef").add(this.boundObjectRef);} else { this.boundObjectRef = null; _visitables.get("boundObjectRef").remove(this.boundObjectRef); } return (A) this;
  }
  public Boolean hasBoundObjectRef() {
    return this.boundObjectRef != null;
  }
  public A withNewBoundObjectRef(String apiVersion,String kind,String name,String uid) {
    return (A)withBoundObjectRef(new BoundObjectReference(apiVersion, kind, name, uid));
  }
  public TokenRequestSpecFluentImpl.BoundObjectRefNested<A> withNewBoundObjectRef() {
    return new TokenRequestSpecFluentImpl.BoundObjectRefNestedImpl();
  }
  public TokenRequestSpecFluentImpl.BoundObjectRefNested<A> withNewBoundObjectRefLike(BoundObjectReference item) {
    return new TokenRequestSpecFluentImpl.BoundObjectRefNestedImpl(item);
  }
  public TokenRequestSpecFluentImpl.BoundObjectRefNested<A> editBoundObjectRef() {
    return withNewBoundObjectRefLike(getBoundObjectRef());
  }
  public TokenRequestSpecFluentImpl.BoundObjectRefNested<A> editOrNewBoundObjectRef() {
    return withNewBoundObjectRefLike(getBoundObjectRef() != null ? getBoundObjectRef(): new BoundObjectReferenceBuilder().build());
  }
  public TokenRequestSpecFluentImpl.BoundObjectRefNested<A> editOrNewBoundObjectRefLike(BoundObjectReference item) {
    return withNewBoundObjectRefLike(getBoundObjectRef() != null ? getBoundObjectRef(): item);
  }
  public Long getExpirationSeconds() {
    return this.expirationSeconds;
  }
  public A withExpirationSeconds(Long expirationSeconds) {
    this.expirationSeconds=expirationSeconds; return (A) this;
  }
  public Boolean hasExpirationSeconds() {
    return this.expirationSeconds != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TokenRequestSpecFluentImpl that = (TokenRequestSpecFluentImpl) o;
    if (!java.util.Objects.equals(audiences, that.audiences)) return false;

    if (!java.util.Objects.equals(boundObjectRef, that.boundObjectRef)) return false;

    if (!java.util.Objects.equals(expirationSeconds, that.expirationSeconds)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(audiences,  boundObjectRef,  expirationSeconds,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (audiences != null && !audiences.isEmpty()) { sb.append("audiences:"); sb.append(audiences + ","); }
    if (boundObjectRef != null) { sb.append("boundObjectRef:"); sb.append(boundObjectRef + ","); }
    if (expirationSeconds != null) { sb.append("expirationSeconds:"); sb.append(expirationSeconds + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class BoundObjectRefNestedImpl<N> extends BoundObjectReferenceFluentImpl<TokenRequestSpecFluentImpl.BoundObjectRefNested<N>> implements TokenRequestSpecFluentImpl.BoundObjectRefNested<N>,Nested<N>{
    BoundObjectRefNestedImpl(BoundObjectReference item) {
      this.builder = new BoundObjectReferenceBuilder(this, item);
    }
    BoundObjectRefNestedImpl() {
      this.builder = new BoundObjectReferenceBuilder(this);
    }
    BoundObjectReferenceBuilder builder;
    public N and() {
      return (N) TokenRequestSpecFluentImpl.this.withBoundObjectRef(builder.build());
    }
    public N endBoundObjectRef() {
      return and();
    }
    
  }
  
}