package io.fabric8.kubernetes.api.model.authentication;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TokenReviewStatusFluentImpl<A extends TokenReviewStatusFluent<A>> extends BaseFluent<A> implements TokenReviewStatusFluent<A>{
  public TokenReviewStatusFluentImpl() {
  }
  public TokenReviewStatusFluentImpl(TokenReviewStatus instance) {
    if (instance != null) {
      this.withAudiences(instance.getAudiences());
      this.withAuthenticated(instance.getAuthenticated());
      this.withError(instance.getError());
      this.withUser(instance.getUser());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<String> audiences = new ArrayList<String>();
  private Boolean authenticated;
  private String error;
  private UserInfoBuilder user;
  private Map<String,Object> additionalProperties;
  public A addToAudiences(int index,String item) {
    if (this.audiences == null) {this.audiences = new ArrayList<String>();}
    this.audiences.add(index, item);
    return (A)this;
  }
  public A setToAudiences(int index,String item) {
    if (this.audiences == null) {this.audiences = new ArrayList<String>();}
    this.audiences.set(index, item); return (A)this;
  }
  public A addToAudiences(java.lang.String... items) {
    if (this.audiences == null) {this.audiences = new ArrayList<String>();}
    for (String item : items) {this.audiences.add(item);} return (A)this;
  }
  public A addAllToAudiences(Collection<String> items) {
    if (this.audiences == null) {this.audiences = new ArrayList<String>();}
    for (String item : items) {this.audiences.add(item);} return (A)this;
  }
  public A removeFromAudiences(java.lang.String... items) {
    for (String item : items) {if (this.audiences!= null){ this.audiences.remove(item);}} return (A)this;
  }
  public A removeAllFromAudiences(Collection<String> items) {
    for (String item : items) {if (this.audiences!= null){ this.audiences.remove(item);}} return (A)this;
  }
  public List<String> getAudiences() {
    return this.audiences;
  }
  public String getAudience(int index) {
    return this.audiences.get(index);
  }
  public String getFirstAudience() {
    return this.audiences.get(0);
  }
  public String getLastAudience() {
    return this.audiences.get(audiences.size() - 1);
  }
  public String getMatchingAudience(Predicate<String> predicate) {
    for (String item: audiences) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAudience(Predicate<String> predicate) {
    for (String item: audiences) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAudiences(List<String> audiences) {
    if (audiences != null) {this.audiences = new ArrayList(); for (String item : audiences){this.addToAudiences(item);}} else { this.audiences = null;} return (A) this;
  }
  public A withAudiences(java.lang.String... audiences) {
    if (this.audiences != null) {this.audiences.clear(); _visitables.remove("audiences"); }
    if (audiences != null) {for (String item :audiences){ this.addToAudiences(item);}} return (A) this;
  }
  public Boolean hasAudiences() {
    return audiences != null && !audiences.isEmpty();
  }
  public Boolean getAuthenticated() {
    return this.authenticated;
  }
  public A withAuthenticated(Boolean authenticated) {
    this.authenticated=authenticated; return (A) this;
  }
  public Boolean hasAuthenticated() {
    return this.authenticated != null;
  }
  public String getError() {
    return this.error;
  }
  public A withError(String error) {
    this.error=error; return (A) this;
  }
  public Boolean hasError() {
    return this.error != null;
  }
  
  /**
   * This method has been deprecated, please use method buildUser instead.
   * @return The buildable object.
   */
  @Deprecated
  public UserInfo getUser() {
    return this.user!=null ?this.user.build():null;
  }
  public UserInfo buildUser() {
    return this.user!=null ?this.user.build():null;
  }
  public A withUser(UserInfo user) {
    _visitables.get("user").remove(this.user);
    if (user!=null){ this.user= new UserInfoBuilder(user); _visitables.get("user").add(this.user);} else { this.user = null; _visitables.get("user").remove(this.user); } return (A) this;
  }
  public Boolean hasUser() {
    return this.user != null;
  }
  public TokenReviewStatusFluentImpl.UserNested<A> withNewUser() {
    return new TokenReviewStatusFluentImpl.UserNestedImpl();
  }
  public TokenReviewStatusFluentImpl.UserNested<A> withNewUserLike(UserInfo item) {
    return new TokenReviewStatusFluentImpl.UserNestedImpl(item);
  }
  public TokenReviewStatusFluentImpl.UserNested<A> editUser() {
    return withNewUserLike(getUser());
  }
  public TokenReviewStatusFluentImpl.UserNested<A> editOrNewUser() {
    return withNewUserLike(getUser() != null ? getUser(): new UserInfoBuilder().build());
  }
  public TokenReviewStatusFluentImpl.UserNested<A> editOrNewUserLike(UserInfo item) {
    return withNewUserLike(getUser() != null ? getUser(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TokenReviewStatusFluentImpl that = (TokenReviewStatusFluentImpl) o;
    if (!java.util.Objects.equals(audiences, that.audiences)) return false;

    if (!java.util.Objects.equals(authenticated, that.authenticated)) return false;

    if (!java.util.Objects.equals(error, that.error)) return false;

    if (!java.util.Objects.equals(user, that.user)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(audiences,  authenticated,  error,  user,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (audiences != null && !audiences.isEmpty()) { sb.append("audiences:"); sb.append(audiences + ","); }
    if (authenticated != null) { sb.append("authenticated:"); sb.append(authenticated + ","); }
    if (error != null) { sb.append("error:"); sb.append(error + ","); }
    if (user != null) { sb.append("user:"); sb.append(user + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withAuthenticated() {
    return withAuthenticated(true);
  }
  class UserNestedImpl<N> extends UserInfoFluentImpl<TokenReviewStatusFluentImpl.UserNested<N>> implements TokenReviewStatusFluentImpl.UserNested<N>,Nested<N>{
    UserNestedImpl(UserInfo item) {
      this.builder = new UserInfoBuilder(this, item);
    }
    UserNestedImpl() {
      this.builder = new UserInfoBuilder(this);
    }
    UserInfoBuilder builder;
    public N and() {
      return (N) TokenReviewStatusFluentImpl.this.withUser(builder.build());
    }
    public N endUser() {
      return and();
    }
    
  }
  
}