package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MatchConditionBuilder extends MatchConditionFluent<MatchConditionBuilder> implements VisitableBuilder<MatchCondition,MatchConditionBuilder>{
  public MatchConditionBuilder() {
    this(false);
  }
  public MatchConditionBuilder(Boolean validationEnabled) {
    this(new MatchCondition(), validationEnabled);
  }
  public MatchConditionBuilder(MatchConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public MatchConditionBuilder(MatchConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MatchCondition(), validationEnabled);
  }
  public MatchConditionBuilder(MatchConditionFluent<?> fluent,MatchCondition instance) {
    this(fluent, instance, false);
  }
  public MatchConditionBuilder(MatchConditionFluent<?> fluent,MatchCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MatchCondition());

    if (instance != null) {
      fluent.withExpression(instance.getExpression());
      fluent.withName(instance.getName());
      fluent.withExpression(instance.getExpression());
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MatchConditionBuilder(MatchCondition instance) {
    this(instance,false);
  }
  public MatchConditionBuilder(MatchCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MatchCondition());

    if (instance != null) {
      this.withExpression(instance.getExpression());
      this.withName(instance.getName());
      this.withExpression(instance.getExpression());
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MatchConditionFluent<?> fluent;
  Boolean validationEnabled;
  public MatchCondition build() {
    MatchCondition buildable = new MatchCondition(fluent.getExpression(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}