package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ValidatingAdmissionPolicySpecBuilder extends ValidatingAdmissionPolicySpecFluent<ValidatingAdmissionPolicySpecBuilder> implements VisitableBuilder<ValidatingAdmissionPolicySpec,ValidatingAdmissionPolicySpecBuilder>{
  public ValidatingAdmissionPolicySpecBuilder() {
    this(false);
  }
  public ValidatingAdmissionPolicySpecBuilder(Boolean validationEnabled) {
    this(new ValidatingAdmissionPolicySpec(), validationEnabled);
  }
  public ValidatingAdmissionPolicySpecBuilder(ValidatingAdmissionPolicySpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ValidatingAdmissionPolicySpecBuilder(ValidatingAdmissionPolicySpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ValidatingAdmissionPolicySpec(), validationEnabled);
  }
  public ValidatingAdmissionPolicySpecBuilder(ValidatingAdmissionPolicySpecFluent<?> fluent,ValidatingAdmissionPolicySpec instance) {
    this(fluent, instance, false);
  }
  public ValidatingAdmissionPolicySpecBuilder(ValidatingAdmissionPolicySpecFluent<?> fluent,ValidatingAdmissionPolicySpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ValidatingAdmissionPolicySpec());

    if (instance != null) {
      fluent.withAuditAnnotations(instance.getAuditAnnotations());
      fluent.withFailurePolicy(instance.getFailurePolicy());
      fluent.withMatchConditions(instance.getMatchConditions());
      fluent.withMatchConstraints(instance.getMatchConstraints());
      fluent.withParamKind(instance.getParamKind());
      fluent.withValidations(instance.getValidations());
      fluent.withAuditAnnotations(instance.getAuditAnnotations());
      fluent.withFailurePolicy(instance.getFailurePolicy());
      fluent.withMatchConditions(instance.getMatchConditions());
      fluent.withMatchConstraints(instance.getMatchConstraints());
      fluent.withParamKind(instance.getParamKind());
      fluent.withValidations(instance.getValidations());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ValidatingAdmissionPolicySpecBuilder(ValidatingAdmissionPolicySpec instance) {
    this(instance,false);
  }
  public ValidatingAdmissionPolicySpecBuilder(ValidatingAdmissionPolicySpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ValidatingAdmissionPolicySpec());

    if (instance != null) {
      this.withAuditAnnotations(instance.getAuditAnnotations());
      this.withFailurePolicy(instance.getFailurePolicy());
      this.withMatchConditions(instance.getMatchConditions());
      this.withMatchConstraints(instance.getMatchConstraints());
      this.withParamKind(instance.getParamKind());
      this.withValidations(instance.getValidations());
      this.withAuditAnnotations(instance.getAuditAnnotations());
      this.withFailurePolicy(instance.getFailurePolicy());
      this.withMatchConditions(instance.getMatchConditions());
      this.withMatchConstraints(instance.getMatchConstraints());
      this.withParamKind(instance.getParamKind());
      this.withValidations(instance.getValidations());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ValidatingAdmissionPolicySpecFluent<?> fluent;
  Boolean validationEnabled;
  public ValidatingAdmissionPolicySpec build() {
    ValidatingAdmissionPolicySpec buildable = new ValidatingAdmissionPolicySpec(fluent.buildAuditAnnotations(),fluent.getFailurePolicy(),fluent.buildMatchConditions(),fluent.buildMatchConstraints(),fluent.buildParamKind(),fluent.buildValidations());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}