package io.fabric8.kubernetes.api.model.admissionregistration.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ValidatingWebhookConfigurationBuilder extends ValidatingWebhookConfigurationFluent<ValidatingWebhookConfigurationBuilder> implements VisitableBuilder<ValidatingWebhookConfiguration,ValidatingWebhookConfigurationBuilder>{
  public ValidatingWebhookConfigurationBuilder() {
    this(false);
  }
  public ValidatingWebhookConfigurationBuilder(Boolean validationEnabled) {
    this(new ValidatingWebhookConfiguration(), validationEnabled);
  }
  public ValidatingWebhookConfigurationBuilder(ValidatingWebhookConfigurationFluent<?> fluent) {
    this(fluent, false);
  }
  public ValidatingWebhookConfigurationBuilder(ValidatingWebhookConfigurationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ValidatingWebhookConfiguration(), validationEnabled);
  }
  public ValidatingWebhookConfigurationBuilder(ValidatingWebhookConfigurationFluent<?> fluent,ValidatingWebhookConfiguration instance) {
    this(fluent, instance, false);
  }
  public ValidatingWebhookConfigurationBuilder(ValidatingWebhookConfigurationFluent<?> fluent,ValidatingWebhookConfiguration instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ValidatingWebhookConfiguration());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withWebhooks(instance.getWebhooks());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withWebhooks(instance.getWebhooks());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ValidatingWebhookConfigurationBuilder(ValidatingWebhookConfiguration instance) {
    this(instance,false);
  }
  public ValidatingWebhookConfigurationBuilder(ValidatingWebhookConfiguration instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ValidatingWebhookConfiguration());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withWebhooks(instance.getWebhooks());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withWebhooks(instance.getWebhooks());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ValidatingWebhookConfigurationFluent<?> fluent;
  Boolean validationEnabled;
  public ValidatingWebhookConfiguration build() {
    ValidatingWebhookConfiguration buildable = new ValidatingWebhookConfiguration(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildWebhooks());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}