package io.fabric8.kubernetes.api.model.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BoundObjectReferenceBuilder extends BoundObjectReferenceFluent<BoundObjectReferenceBuilder> implements VisitableBuilder<BoundObjectReference,BoundObjectReferenceBuilder>{
  public BoundObjectReferenceBuilder() {
    this(false);
  }
  public BoundObjectReferenceBuilder(Boolean validationEnabled) {
    this(new BoundObjectReference(), validationEnabled);
  }
  public BoundObjectReferenceBuilder(BoundObjectReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public BoundObjectReferenceBuilder(BoundObjectReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BoundObjectReference(), validationEnabled);
  }
  public BoundObjectReferenceBuilder(BoundObjectReferenceFluent<?> fluent,BoundObjectReference instance) {
    this(fluent, instance, false);
  }
  public BoundObjectReferenceBuilder(BoundObjectReferenceFluent<?> fluent,BoundObjectReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new BoundObjectReference());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withUid(instance.getUid());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withUid(instance.getUid());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BoundObjectReferenceBuilder(BoundObjectReference instance) {
    this(instance,false);
  }
  public BoundObjectReferenceBuilder(BoundObjectReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new BoundObjectReference());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withUid(instance.getUid());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withUid(instance.getUid());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BoundObjectReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public BoundObjectReference build() {
    BoundObjectReference buildable = new BoundObjectReference(fluent.getApiVersion(),fluent.getKind(),fluent.getName(),fluent.getUid());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}