package io.fabric8.kubernetes.api.model.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TokenRequestBuilder extends TokenRequestFluent<TokenRequestBuilder> implements VisitableBuilder<TokenRequest,TokenRequestBuilder>{
  public TokenRequestBuilder() {
    this(false);
  }
  public TokenRequestBuilder(Boolean validationEnabled) {
    this(new TokenRequest(), validationEnabled);
  }
  public TokenRequestBuilder(TokenRequestFluent<?> fluent) {
    this(fluent, false);
  }
  public TokenRequestBuilder(TokenRequestFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TokenRequest(), validationEnabled);
  }
  public TokenRequestBuilder(TokenRequestFluent<?> fluent,TokenRequest instance) {
    this(fluent, instance, false);
  }
  public TokenRequestBuilder(TokenRequestFluent<?> fluent,TokenRequest instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TokenRequest());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TokenRequestBuilder(TokenRequest instance) {
    this(instance,false);
  }
  public TokenRequestBuilder(TokenRequest instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TokenRequest());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TokenRequestFluent<?> fluent;
  Boolean validationEnabled;
  public TokenRequest build() {
    TokenRequest buildable = new TokenRequest(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}