package io.fabric8.kubernetes.api.model.authentication.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SelfSubjectReviewBuilder extends SelfSubjectReviewFluent<SelfSubjectReviewBuilder> implements VisitableBuilder<SelfSubjectReview,SelfSubjectReviewBuilder>{
  public SelfSubjectReviewBuilder() {
    this(false);
  }
  public SelfSubjectReviewBuilder(Boolean validationEnabled) {
    this(new SelfSubjectReview(), validationEnabled);
  }
  public SelfSubjectReviewBuilder(SelfSubjectReviewFluent<?> fluent) {
    this(fluent, false);
  }
  public SelfSubjectReviewBuilder(SelfSubjectReviewFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SelfSubjectReview(), validationEnabled);
  }
  public SelfSubjectReviewBuilder(SelfSubjectReviewFluent<?> fluent,SelfSubjectReview instance) {
    this(fluent, instance, false);
  }
  public SelfSubjectReviewBuilder(SelfSubjectReviewFluent<?> fluent,SelfSubjectReview instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SelfSubjectReview());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SelfSubjectReviewBuilder(SelfSubjectReview instance) {
    this(instance,false);
  }
  public SelfSubjectReviewBuilder(SelfSubjectReview instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SelfSubjectReview());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SelfSubjectReviewFluent<?> fluent;
  Boolean validationEnabled;
  public SelfSubjectReview build() {
    SelfSubjectReview buildable = new SelfSubjectReview(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}