package io.fabric8.kubernetes.api.model.admissionregistration.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MutatingWebhookBuilder extends MutatingWebhookFluent<MutatingWebhookBuilder> implements VisitableBuilder<MutatingWebhook,MutatingWebhookBuilder>{
  public MutatingWebhookBuilder() {
    this(false);
  }
  public MutatingWebhookBuilder(Boolean validationEnabled) {
    this(new MutatingWebhook(), validationEnabled);
  }
  public MutatingWebhookBuilder(MutatingWebhookFluent<?> fluent) {
    this(fluent, false);
  }
  public MutatingWebhookBuilder(MutatingWebhookFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MutatingWebhook(), validationEnabled);
  }
  public MutatingWebhookBuilder(MutatingWebhookFluent<?> fluent,MutatingWebhook instance) {
    this(fluent, instance, false);
  }
  public MutatingWebhookBuilder(MutatingWebhookFluent<?> fluent,MutatingWebhook instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MutatingWebhook());

    if (instance != null) {
      fluent.withAdmissionReviewVersions(instance.getAdmissionReviewVersions());
      fluent.withClientConfig(instance.getClientConfig());
      fluent.withFailurePolicy(instance.getFailurePolicy());
      fluent.withMatchConditions(instance.getMatchConditions());
      fluent.withMatchPolicy(instance.getMatchPolicy());
      fluent.withName(instance.getName());
      fluent.withNamespaceSelector(instance.getNamespaceSelector());
      fluent.withObjectSelector(instance.getObjectSelector());
      fluent.withReinvocationPolicy(instance.getReinvocationPolicy());
      fluent.withRules(instance.getRules());
      fluent.withSideEffects(instance.getSideEffects());
      fluent.withTimeoutSeconds(instance.getTimeoutSeconds());
      fluent.withAdmissionReviewVersions(instance.getAdmissionReviewVersions());
      fluent.withClientConfig(instance.getClientConfig());
      fluent.withFailurePolicy(instance.getFailurePolicy());
      fluent.withMatchConditions(instance.getMatchConditions());
      fluent.withMatchPolicy(instance.getMatchPolicy());
      fluent.withName(instance.getName());
      fluent.withNamespaceSelector(instance.getNamespaceSelector());
      fluent.withObjectSelector(instance.getObjectSelector());
      fluent.withReinvocationPolicy(instance.getReinvocationPolicy());
      fluent.withRules(instance.getRules());
      fluent.withSideEffects(instance.getSideEffects());
      fluent.withTimeoutSeconds(instance.getTimeoutSeconds());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MutatingWebhookBuilder(MutatingWebhook instance) {
    this(instance,false);
  }
  public MutatingWebhookBuilder(MutatingWebhook instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MutatingWebhook());

    if (instance != null) {
      this.withAdmissionReviewVersions(instance.getAdmissionReviewVersions());
      this.withClientConfig(instance.getClientConfig());
      this.withFailurePolicy(instance.getFailurePolicy());
      this.withMatchConditions(instance.getMatchConditions());
      this.withMatchPolicy(instance.getMatchPolicy());
      this.withName(instance.getName());
      this.withNamespaceSelector(instance.getNamespaceSelector());
      this.withObjectSelector(instance.getObjectSelector());
      this.withReinvocationPolicy(instance.getReinvocationPolicy());
      this.withRules(instance.getRules());
      this.withSideEffects(instance.getSideEffects());
      this.withTimeoutSeconds(instance.getTimeoutSeconds());
      this.withAdmissionReviewVersions(instance.getAdmissionReviewVersions());
      this.withClientConfig(instance.getClientConfig());
      this.withFailurePolicy(instance.getFailurePolicy());
      this.withMatchConditions(instance.getMatchConditions());
      this.withMatchPolicy(instance.getMatchPolicy());
      this.withName(instance.getName());
      this.withNamespaceSelector(instance.getNamespaceSelector());
      this.withObjectSelector(instance.getObjectSelector());
      this.withReinvocationPolicy(instance.getReinvocationPolicy());
      this.withRules(instance.getRules());
      this.withSideEffects(instance.getSideEffects());
      this.withTimeoutSeconds(instance.getTimeoutSeconds());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MutatingWebhookFluent<?> fluent;
  Boolean validationEnabled;
  public MutatingWebhook build() {
    MutatingWebhook buildable = new MutatingWebhook(fluent.getAdmissionReviewVersions(),fluent.buildClientConfig(),fluent.getFailurePolicy(),fluent.buildMatchConditions(),fluent.getMatchPolicy(),fluent.getName(),fluent.buildNamespaceSelector(),fluent.buildObjectSelector(),fluent.getReinvocationPolicy(),fluent.buildRules(),fluent.getSideEffects(),fluent.getTimeoutSeconds());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}