package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExpressionWarningBuilder extends ExpressionWarningFluent<ExpressionWarningBuilder> implements VisitableBuilder<ExpressionWarning,ExpressionWarningBuilder>{
  public ExpressionWarningBuilder() {
    this(false);
  }
  public ExpressionWarningBuilder(Boolean validationEnabled) {
    this(new ExpressionWarning(), validationEnabled);
  }
  public ExpressionWarningBuilder(ExpressionWarningFluent<?> fluent) {
    this(fluent, false);
  }
  public ExpressionWarningBuilder(ExpressionWarningFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ExpressionWarning(), validationEnabled);
  }
  public ExpressionWarningBuilder(ExpressionWarningFluent<?> fluent,ExpressionWarning instance) {
    this(fluent, instance, false);
  }
  public ExpressionWarningBuilder(ExpressionWarningFluent<?> fluent,ExpressionWarning instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ExpressionWarning());

    if (instance != null) {
      fluent.withFieldRef(instance.getFieldRef());
      fluent.withWarning(instance.getWarning());
      fluent.withFieldRef(instance.getFieldRef());
      fluent.withWarning(instance.getWarning());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ExpressionWarningBuilder(ExpressionWarning instance) {
    this(instance,false);
  }
  public ExpressionWarningBuilder(ExpressionWarning instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ExpressionWarning());

    if (instance != null) {
      this.withFieldRef(instance.getFieldRef());
      this.withWarning(instance.getWarning());
      this.withFieldRef(instance.getFieldRef());
      this.withWarning(instance.getWarning());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ExpressionWarningFluent<?> fluent;
  Boolean validationEnabled;
  public ExpressionWarning build() {
    ExpressionWarning buildable = new ExpressionWarning(fluent.getFieldRef(),fluent.getWarning());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}