package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ParamRefBuilder extends ParamRefFluent<ParamRefBuilder> implements VisitableBuilder<ParamRef,ParamRefBuilder>{
  public ParamRefBuilder() {
    this(false);
  }
  public ParamRefBuilder(Boolean validationEnabled) {
    this(new ParamRef(), validationEnabled);
  }
  public ParamRefBuilder(ParamRefFluent<?> fluent) {
    this(fluent, false);
  }
  public ParamRefBuilder(ParamRefFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ParamRef(), validationEnabled);
  }
  public ParamRefBuilder(ParamRefFluent<?> fluent,ParamRef instance) {
    this(fluent, instance, false);
  }
  public ParamRefBuilder(ParamRefFluent<?> fluent,ParamRef instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ParamRef());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ParamRefBuilder(ParamRef instance) {
    this(instance,false);
  }
  public ParamRefBuilder(ParamRef instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ParamRef());

    if (instance != null) {
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ParamRefFluent<?> fluent;
  Boolean validationEnabled;
  public ParamRef build() {
    ParamRef buildable = new ParamRef(fluent.getName(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}