package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ValidatingAdmissionPolicyBindingSpecBuilder extends ValidatingAdmissionPolicyBindingSpecFluent<ValidatingAdmissionPolicyBindingSpecBuilder> implements VisitableBuilder<ValidatingAdmissionPolicyBindingSpec,ValidatingAdmissionPolicyBindingSpecBuilder>{
  public ValidatingAdmissionPolicyBindingSpecBuilder() {
    this(false);
  }
  public ValidatingAdmissionPolicyBindingSpecBuilder(Boolean validationEnabled) {
    this(new ValidatingAdmissionPolicyBindingSpec(), validationEnabled);
  }
  public ValidatingAdmissionPolicyBindingSpecBuilder(ValidatingAdmissionPolicyBindingSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ValidatingAdmissionPolicyBindingSpecBuilder(ValidatingAdmissionPolicyBindingSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ValidatingAdmissionPolicyBindingSpec(), validationEnabled);
  }
  public ValidatingAdmissionPolicyBindingSpecBuilder(ValidatingAdmissionPolicyBindingSpecFluent<?> fluent,ValidatingAdmissionPolicyBindingSpec instance) {
    this(fluent, instance, false);
  }
  public ValidatingAdmissionPolicyBindingSpecBuilder(ValidatingAdmissionPolicyBindingSpecFluent<?> fluent,ValidatingAdmissionPolicyBindingSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ValidatingAdmissionPolicyBindingSpec());

    if (instance != null) {
      fluent.withMatchResources(instance.getMatchResources());
      fluent.withParamRef(instance.getParamRef());
      fluent.withPolicyName(instance.getPolicyName());
      fluent.withValidationActions(instance.getValidationActions());
      fluent.withMatchResources(instance.getMatchResources());
      fluent.withParamRef(instance.getParamRef());
      fluent.withPolicyName(instance.getPolicyName());
      fluent.withValidationActions(instance.getValidationActions());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ValidatingAdmissionPolicyBindingSpecBuilder(ValidatingAdmissionPolicyBindingSpec instance) {
    this(instance,false);
  }
  public ValidatingAdmissionPolicyBindingSpecBuilder(ValidatingAdmissionPolicyBindingSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ValidatingAdmissionPolicyBindingSpec());

    if (instance != null) {
      this.withMatchResources(instance.getMatchResources());
      this.withParamRef(instance.getParamRef());
      this.withPolicyName(instance.getPolicyName());
      this.withValidationActions(instance.getValidationActions());
      this.withMatchResources(instance.getMatchResources());
      this.withParamRef(instance.getParamRef());
      this.withPolicyName(instance.getPolicyName());
      this.withValidationActions(instance.getValidationActions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ValidatingAdmissionPolicyBindingSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ValidatingAdmissionPolicyBindingSpec build() {
    ValidatingAdmissionPolicyBindingSpec buildable = new ValidatingAdmissionPolicyBindingSpec(fluent.buildMatchResources(),fluent.buildParamRef(),fluent.getPolicyName(),fluent.getValidationActions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}