package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ValidatingAdmissionPolicyBindingSpecFluent<A extends ValidatingAdmissionPolicyBindingSpecFluent<A>> extends BaseFluent<A>{
  public ValidatingAdmissionPolicyBindingSpecFluent() {
  }
  public ValidatingAdmissionPolicyBindingSpecFluent(ValidatingAdmissionPolicyBindingSpec instance) {
    instance = (instance != null ? instance : new ValidatingAdmissionPolicyBindingSpec());

    if (instance != null) {
      this.withMatchResources(instance.getMatchResources());
      this.withParamRef(instance.getParamRef());
      this.withPolicyName(instance.getPolicyName());
      this.withValidationActions(instance.getValidationActions());
      this.withMatchResources(instance.getMatchResources());
      this.withParamRef(instance.getParamRef());
      this.withPolicyName(instance.getPolicyName());
      this.withValidationActions(instance.getValidationActions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private MatchResourcesBuilder matchResources;
  private ParamRefBuilder paramRef;
  private String policyName;
  private List<String> validationActions = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public MatchResources buildMatchResources() {
    return this.matchResources!=null ?this.matchResources.build():null;
  }
  public A withMatchResources(MatchResources matchResources) {
    _visitables.get("matchResources").remove(this.matchResources);
    if (matchResources!=null){ this.matchResources= new MatchResourcesBuilder(matchResources); _visitables.get("matchResources").add(this.matchResources);} else { this.matchResources = null; _visitables.get("matchResources").remove(this.matchResources); } return (A) this;
  }
  public boolean hasMatchResources() {
    return this.matchResources != null;
  }
  public MatchResourcesNested<A> withNewMatchResources() {
    return new MatchResourcesNested(null);
  }
  public MatchResourcesNested<A> withNewMatchResourcesLike(MatchResources item) {
    return new MatchResourcesNested(item);
  }
  public MatchResourcesNested<A> editMatchResources() {
    return withNewMatchResourcesLike(java.util.Optional.ofNullable(buildMatchResources()).orElse(null));
  }
  public MatchResourcesNested<A> editOrNewMatchResources() {
    return withNewMatchResourcesLike(java.util.Optional.ofNullable(buildMatchResources()).orElse(new MatchResourcesBuilder().build()));
  }
  public MatchResourcesNested<A> editOrNewMatchResourcesLike(MatchResources item) {
    return withNewMatchResourcesLike(java.util.Optional.ofNullable(buildMatchResources()).orElse(item));
  }
  public ParamRef buildParamRef() {
    return this.paramRef!=null ?this.paramRef.build():null;
  }
  public A withParamRef(ParamRef paramRef) {
    _visitables.get("paramRef").remove(this.paramRef);
    if (paramRef!=null){ this.paramRef= new ParamRefBuilder(paramRef); _visitables.get("paramRef").add(this.paramRef);} else { this.paramRef = null; _visitables.get("paramRef").remove(this.paramRef); } return (A) this;
  }
  public boolean hasParamRef() {
    return this.paramRef != null;
  }
  public A withNewParamRef(String name,String namespace) {
    return (A)withParamRef(new ParamRef(name, namespace));
  }
  public ParamRefNested<A> withNewParamRef() {
    return new ParamRefNested(null);
  }
  public ParamRefNested<A> withNewParamRefLike(ParamRef item) {
    return new ParamRefNested(item);
  }
  public ParamRefNested<A> editParamRef() {
    return withNewParamRefLike(java.util.Optional.ofNullable(buildParamRef()).orElse(null));
  }
  public ParamRefNested<A> editOrNewParamRef() {
    return withNewParamRefLike(java.util.Optional.ofNullable(buildParamRef()).orElse(new ParamRefBuilder().build()));
  }
  public ParamRefNested<A> editOrNewParamRefLike(ParamRef item) {
    return withNewParamRefLike(java.util.Optional.ofNullable(buildParamRef()).orElse(item));
  }
  public String getPolicyName() {
    return this.policyName;
  }
  public A withPolicyName(String policyName) {
    this.policyName=policyName; return (A) this;
  }
  public boolean hasPolicyName() {
    return this.policyName != null;
  }
  public A addToValidationActions(int index,String item) {
    if (this.validationActions == null) {this.validationActions = new ArrayList<String>();}
    this.validationActions.add(index, item);
    return (A)this;
  }
  public A setToValidationActions(int index,String item) {
    if (this.validationActions == null) {this.validationActions = new ArrayList<String>();}
    this.validationActions.set(index, item); return (A)this;
  }
  public A addToValidationActions(java.lang.String... items) {
    if (this.validationActions == null) {this.validationActions = new ArrayList<String>();}
    for (String item : items) {this.validationActions.add(item);} return (A)this;
  }
  public A addAllToValidationActions(Collection<String> items) {
    if (this.validationActions == null) {this.validationActions = new ArrayList<String>();}
    for (String item : items) {this.validationActions.add(item);} return (A)this;
  }
  public A removeFromValidationActions(java.lang.String... items) {
    if (this.validationActions == null) return (A)this;
    for (String item : items) { this.validationActions.remove(item);} return (A)this;
  }
  public A removeAllFromValidationActions(Collection<String> items) {
    if (this.validationActions == null) return (A)this;
    for (String item : items) { this.validationActions.remove(item);} return (A)this;
  }
  public List<String> getValidationActions() {
    return this.validationActions;
  }
  public String getValidationAction(int index) {
    return this.validationActions.get(index);
  }
  public String getFirstValidationAction() {
    return this.validationActions.get(0);
  }
  public String getLastValidationAction() {
    return this.validationActions.get(validationActions.size() - 1);
  }
  public String getMatchingValidationAction(Predicate<String> predicate) {
    for (String item: validationActions) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingValidationAction(Predicate<String> predicate) {
    for (String item: validationActions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withValidationActions(List<String> validationActions) {
    if (validationActions != null) {this.validationActions = new ArrayList(); for (String item : validationActions){this.addToValidationActions(item);}} else { this.validationActions = null;} return (A) this;
  }
  public A withValidationActions(java.lang.String... validationActions) {
    if (this.validationActions != null) {this.validationActions.clear(); _visitables.remove("validationActions"); }
    if (validationActions != null) {for (String item :validationActions){ this.addToValidationActions(item);}} return (A) this;
  }
  public boolean hasValidationActions() {
    return validationActions != null && !validationActions.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ValidatingAdmissionPolicyBindingSpecFluent that = (ValidatingAdmissionPolicyBindingSpecFluent) o;
    if (!java.util.Objects.equals(matchResources, that.matchResources)) return false;

    if (!java.util.Objects.equals(paramRef, that.paramRef)) return false;

    if (!java.util.Objects.equals(policyName, that.policyName)) return false;

    if (!java.util.Objects.equals(validationActions, that.validationActions)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(matchResources,  paramRef,  policyName,  validationActions,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (matchResources != null) { sb.append("matchResources:"); sb.append(matchResources + ","); }
    if (paramRef != null) { sb.append("paramRef:"); sb.append(paramRef + ","); }
    if (policyName != null) { sb.append("policyName:"); sb.append(policyName + ","); }
    if (validationActions != null && !validationActions.isEmpty()) { sb.append("validationActions:"); sb.append(validationActions + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class MatchResourcesNested<N> extends MatchResourcesFluent<MatchResourcesNested<N>> implements Nested<N>{
    MatchResourcesNested(MatchResources item) {
      this.builder = new MatchResourcesBuilder(this, item);
    }
    MatchResourcesBuilder builder;
    public N and() {
      return (N) ValidatingAdmissionPolicyBindingSpecFluent.this.withMatchResources(builder.build());
    }
    public N endMatchResources() {
      return and();
    }
    
  }
  public class ParamRefNested<N> extends ParamRefFluent<ParamRefNested<N>> implements Nested<N>{
    ParamRefNested(ParamRef item) {
      this.builder = new ParamRefBuilder(this, item);
    }
    ParamRefBuilder builder;
    public N and() {
      return (N) ValidatingAdmissionPolicyBindingSpecFluent.this.withParamRef(builder.build());
    }
    public N endParamRef() {
      return and();
    }
    
  }
  
}