package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ValidatingAdmissionPolicyStatusBuilder extends ValidatingAdmissionPolicyStatusFluent<ValidatingAdmissionPolicyStatusBuilder> implements VisitableBuilder<ValidatingAdmissionPolicyStatus,ValidatingAdmissionPolicyStatusBuilder>{
  public ValidatingAdmissionPolicyStatusBuilder() {
    this(false);
  }
  public ValidatingAdmissionPolicyStatusBuilder(Boolean validationEnabled) {
    this(new ValidatingAdmissionPolicyStatus(), validationEnabled);
  }
  public ValidatingAdmissionPolicyStatusBuilder(ValidatingAdmissionPolicyStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ValidatingAdmissionPolicyStatusBuilder(ValidatingAdmissionPolicyStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ValidatingAdmissionPolicyStatus(), validationEnabled);
  }
  public ValidatingAdmissionPolicyStatusBuilder(ValidatingAdmissionPolicyStatusFluent<?> fluent,ValidatingAdmissionPolicyStatus instance) {
    this(fluent, instance, false);
  }
  public ValidatingAdmissionPolicyStatusBuilder(ValidatingAdmissionPolicyStatusFluent<?> fluent,ValidatingAdmissionPolicyStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ValidatingAdmissionPolicyStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withTypeChecking(instance.getTypeChecking());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withTypeChecking(instance.getTypeChecking());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ValidatingAdmissionPolicyStatusBuilder(ValidatingAdmissionPolicyStatus instance) {
    this(instance,false);
  }
  public ValidatingAdmissionPolicyStatusBuilder(ValidatingAdmissionPolicyStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ValidatingAdmissionPolicyStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withTypeChecking(instance.getTypeChecking());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withTypeChecking(instance.getTypeChecking());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ValidatingAdmissionPolicyStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ValidatingAdmissionPolicyStatus build() {
    ValidatingAdmissionPolicyStatus buildable = new ValidatingAdmissionPolicyStatus(fluent.getConditions(),fluent.getObservedGeneration(),fluent.buildTypeChecking());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}