/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.authentication;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.authentication.TokenReviewSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class TokenReviewSpecFluent<A extends TokenReviewSpecFluent<A>>
extends BaseFluent<A> {
    private List<String> audiences = new ArrayList<String>();
    private String token;
    private Map<String, Object> additionalProperties;

    public TokenReviewSpecFluent() {
    }

    public TokenReviewSpecFluent(TokenReviewSpec instance) {
        TokenReviewSpec tokenReviewSpec = instance = instance != null ? instance : new TokenReviewSpec();
        if (instance != null) {
            this.withAudiences(instance.getAudiences());
            this.withToken(instance.getToken());
            this.withAudiences(instance.getAudiences());
            this.withToken(instance.getToken());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAudiences(int index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.add(index, item);
        return (A)((Object)this);
    }

    public A setToAudiences(int index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.set(index, item);
        return (A)((Object)this);
    }

    public A addToAudiences(String ... items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAudiences(Collection<String> items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAudiences(String ... items) {
        if (this.audiences == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.audiences.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAudiences(Collection<String> items) {
        if (this.audiences == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.audiences.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getAudiences() {
        return this.audiences;
    }

    public String getAudience(int index) {
        return this.audiences.get(index);
    }

    public String getFirstAudience() {
        return this.audiences.get(0);
    }

    public String getLastAudience() {
        return this.audiences.get(this.audiences.size() - 1);
    }

    public String getMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAudiences(List<String> audiences) {
        if (audiences != null) {
            this.audiences = new ArrayList<String>();
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        } else {
            this.audiences = null;
        }
        return (A)((Object)this);
    }

    public A withAudiences(String ... audiences) {
        if (this.audiences != null) {
            this.audiences.clear();
            this._visitables.remove((Object)"audiences");
        }
        if (audiences != null) {
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAudiences() {
        return this.audiences != null && !this.audiences.isEmpty();
    }

    public String getToken() {
        return this.token;
    }

    public A withToken(String token) {
        this.token = token;
        return (A)((Object)this);
    }

    public boolean hasToken() {
        return this.token != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TokenReviewSpecFluent that = (TokenReviewSpecFluent)((Object)o);
        if (!Objects.equals(this.audiences, that.audiences)) {
            return false;
        }
        if (!Objects.equals(this.token, that.token)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.audiences, this.token, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.audiences != null && !this.audiences.isEmpty()) {
            sb.append("audiences:");
            sb.append(this.audiences + ",");
        }
        if (this.token != null) {
            sb.append("token:");
            sb.append(this.token + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

