package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ValidatingAdmissionPolicySpecFluent<A extends ValidatingAdmissionPolicySpecFluent<A>> extends BaseFluent<A>{
  public ValidatingAdmissionPolicySpecFluent() {
  }
  
  public ValidatingAdmissionPolicySpecFluent(ValidatingAdmissionPolicySpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<AuditAnnotationBuilder> auditAnnotations = new ArrayList<AuditAnnotationBuilder>();
  private String failurePolicy;
  private ArrayList<MatchConditionBuilder> matchConditions = new ArrayList<MatchConditionBuilder>();
  private MatchResourcesBuilder matchConstraints;
  private ParamKindBuilder paramKind;
  private ArrayList<ValidationBuilder> validations = new ArrayList<ValidationBuilder>();
  private ArrayList<VariableBuilder> variables = new ArrayList<VariableBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ValidatingAdmissionPolicySpec instance) {
    instance = (instance != null ? instance : new ValidatingAdmissionPolicySpec());
  
    if (instance != null) {
        this.withAuditAnnotations(instance.getAuditAnnotations());
        this.withFailurePolicy(instance.getFailurePolicy());
        this.withMatchConditions(instance.getMatchConditions());
        this.withMatchConstraints(instance.getMatchConstraints());
        this.withParamKind(instance.getParamKind());
        this.withValidations(instance.getValidations());
        this.withVariables(instance.getVariables());
        this.withAuditAnnotations(instance.getAuditAnnotations());
        this.withFailurePolicy(instance.getFailurePolicy());
        this.withMatchConditions(instance.getMatchConditions());
        this.withMatchConstraints(instance.getMatchConstraints());
        this.withParamKind(instance.getParamKind());
        this.withValidations(instance.getValidations());
        this.withVariables(instance.getVariables());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public A addToAuditAnnotations(int index,AuditAnnotation item) {
    if (this.auditAnnotations == null) {this.auditAnnotations = new ArrayList<AuditAnnotationBuilder>();}
    AuditAnnotationBuilder builder = new AuditAnnotationBuilder(item);
    if (index < 0 || index >= auditAnnotations.size()) { _visitables.get("auditAnnotations").add(builder); auditAnnotations.add(builder); } else { _visitables.get("auditAnnotations").add(index, builder); auditAnnotations.add(index, builder);}
    return (A)this;
  }
  
  public A setToAuditAnnotations(int index,AuditAnnotation item) {
    if (this.auditAnnotations == null) {this.auditAnnotations = new ArrayList<AuditAnnotationBuilder>();}
    AuditAnnotationBuilder builder = new AuditAnnotationBuilder(item);
    if (index < 0 || index >= auditAnnotations.size()) { _visitables.get("auditAnnotations").add(builder); auditAnnotations.add(builder); } else { _visitables.get("auditAnnotations").set(index, builder); auditAnnotations.set(index, builder);}
    return (A)this;
  }
  
  public A addToAuditAnnotations(io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.AuditAnnotation... items) {
    if (this.auditAnnotations == null) {this.auditAnnotations = new ArrayList<AuditAnnotationBuilder>();}
    for (AuditAnnotation item : items) {AuditAnnotationBuilder builder = new AuditAnnotationBuilder(item);_visitables.get("auditAnnotations").add(builder);this.auditAnnotations.add(builder);} return (A)this;
  }
  
  public A addAllToAuditAnnotations(Collection<AuditAnnotation> items) {
    if (this.auditAnnotations == null) {this.auditAnnotations = new ArrayList<AuditAnnotationBuilder>();}
    for (AuditAnnotation item : items) {AuditAnnotationBuilder builder = new AuditAnnotationBuilder(item);_visitables.get("auditAnnotations").add(builder);this.auditAnnotations.add(builder);} return (A)this;
  }
  
  public A removeFromAuditAnnotations(io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.AuditAnnotation... items) {
    if (this.auditAnnotations == null) return (A)this;
    for (AuditAnnotation item : items) {AuditAnnotationBuilder builder = new AuditAnnotationBuilder(item);_visitables.get("auditAnnotations").remove(builder); this.auditAnnotations.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAuditAnnotations(Collection<AuditAnnotation> items) {
    if (this.auditAnnotations == null) return (A)this;
    for (AuditAnnotation item : items) {AuditAnnotationBuilder builder = new AuditAnnotationBuilder(item);_visitables.get("auditAnnotations").remove(builder); this.auditAnnotations.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAuditAnnotations(Predicate<AuditAnnotationBuilder> predicate) {
    if (auditAnnotations == null) return (A) this;
    final Iterator<AuditAnnotationBuilder> each = auditAnnotations.iterator();
    final List visitables = _visitables.get("auditAnnotations");
    while (each.hasNext()) {
      AuditAnnotationBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<AuditAnnotation> buildAuditAnnotations() {
    return auditAnnotations != null ? build(auditAnnotations) : null;
  }
  
  public AuditAnnotation buildAuditAnnotation(int index) {
    return this.auditAnnotations.get(index).build();
  }
  
  public AuditAnnotation buildFirstAuditAnnotation() {
    return this.auditAnnotations.get(0).build();
  }
  
  public AuditAnnotation buildLastAuditAnnotation() {
    return this.auditAnnotations.get(auditAnnotations.size() - 1).build();
  }
  
  public AuditAnnotation buildMatchingAuditAnnotation(Predicate<AuditAnnotationBuilder> predicate) {
    for (AuditAnnotationBuilder item: auditAnnotations) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingAuditAnnotation(Predicate<AuditAnnotationBuilder> predicate) {
    for (AuditAnnotationBuilder item: auditAnnotations) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withAuditAnnotations(List<AuditAnnotation> auditAnnotations) {
    if (this.auditAnnotations != null) { _visitables.get("auditAnnotations").clear();}
    if (auditAnnotations != null) {this.auditAnnotations = new ArrayList(); for (AuditAnnotation item : auditAnnotations){this.addToAuditAnnotations(item);}} else { this.auditAnnotations = null;} return (A) this;
  }
  
  public A withAuditAnnotations(io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.AuditAnnotation... auditAnnotations) {
    if (this.auditAnnotations != null) {this.auditAnnotations.clear(); _visitables.remove("auditAnnotations"); }
    if (auditAnnotations != null) {for (AuditAnnotation item :auditAnnotations){ this.addToAuditAnnotations(item);}} return (A) this;
  }
  
  public boolean hasAuditAnnotations() {
    return auditAnnotations != null && !auditAnnotations.isEmpty();
  }
  
  public A addNewAuditAnnotation(String key,String valueExpression) {
    return (A)addToAuditAnnotations(new AuditAnnotation(key, valueExpression));
  }
  
  public AuditAnnotationsNested<A> addNewAuditAnnotation() {
    return new AuditAnnotationsNested(-1, null);
  }
  
  public AuditAnnotationsNested<A> addNewAuditAnnotationLike(AuditAnnotation item) {
    return new AuditAnnotationsNested(-1, item);
  }
  
  public AuditAnnotationsNested<A> setNewAuditAnnotationLike(int index,AuditAnnotation item) {
    return new AuditAnnotationsNested(index, item);
  }
  
  public AuditAnnotationsNested<A> editAuditAnnotation(int index) {
    if (auditAnnotations.size() <= index) throw new RuntimeException("Can't edit auditAnnotations. Index exceeds size.");
    return setNewAuditAnnotationLike(index, buildAuditAnnotation(index));
  }
  
  public AuditAnnotationsNested<A> editFirstAuditAnnotation() {
    if (auditAnnotations.size() == 0) throw new RuntimeException("Can't edit first auditAnnotations. The list is empty.");
    return setNewAuditAnnotationLike(0, buildAuditAnnotation(0));
  }
  
  public AuditAnnotationsNested<A> editLastAuditAnnotation() {
    int index = auditAnnotations.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last auditAnnotations. The list is empty.");
    return setNewAuditAnnotationLike(index, buildAuditAnnotation(index));
  }
  
  public AuditAnnotationsNested<A> editMatchingAuditAnnotation(Predicate<AuditAnnotationBuilder> predicate) {
    int index = -1;
    for (int i=0;i<auditAnnotations.size();i++) { 
    if (predicate.test(auditAnnotations.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching auditAnnotations. No match found.");
    return setNewAuditAnnotationLike(index, buildAuditAnnotation(index));
  }
  
  public String getFailurePolicy() {
    return this.failurePolicy;
  }
  
  public A withFailurePolicy(String failurePolicy) {
    this.failurePolicy=failurePolicy; return (A) this;
  }
  
  public boolean hasFailurePolicy() {
    return this.failurePolicy != null;
  }
  
  public A addToMatchConditions(int index,MatchCondition item) {
    if (this.matchConditions == null) {this.matchConditions = new ArrayList<MatchConditionBuilder>();}
    MatchConditionBuilder builder = new MatchConditionBuilder(item);
    if (index < 0 || index >= matchConditions.size()) { _visitables.get("matchConditions").add(builder); matchConditions.add(builder); } else { _visitables.get("matchConditions").add(index, builder); matchConditions.add(index, builder);}
    return (A)this;
  }
  
  public A setToMatchConditions(int index,MatchCondition item) {
    if (this.matchConditions == null) {this.matchConditions = new ArrayList<MatchConditionBuilder>();}
    MatchConditionBuilder builder = new MatchConditionBuilder(item);
    if (index < 0 || index >= matchConditions.size()) { _visitables.get("matchConditions").add(builder); matchConditions.add(builder); } else { _visitables.get("matchConditions").set(index, builder); matchConditions.set(index, builder);}
    return (A)this;
  }
  
  public A addToMatchConditions(io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.MatchCondition... items) {
    if (this.matchConditions == null) {this.matchConditions = new ArrayList<MatchConditionBuilder>();}
    for (MatchCondition item : items) {MatchConditionBuilder builder = new MatchConditionBuilder(item);_visitables.get("matchConditions").add(builder);this.matchConditions.add(builder);} return (A)this;
  }
  
  public A addAllToMatchConditions(Collection<MatchCondition> items) {
    if (this.matchConditions == null) {this.matchConditions = new ArrayList<MatchConditionBuilder>();}
    for (MatchCondition item : items) {MatchConditionBuilder builder = new MatchConditionBuilder(item);_visitables.get("matchConditions").add(builder);this.matchConditions.add(builder);} return (A)this;
  }
  
  public A removeFromMatchConditions(io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.MatchCondition... items) {
    if (this.matchConditions == null) return (A)this;
    for (MatchCondition item : items) {MatchConditionBuilder builder = new MatchConditionBuilder(item);_visitables.get("matchConditions").remove(builder); this.matchConditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromMatchConditions(Collection<MatchCondition> items) {
    if (this.matchConditions == null) return (A)this;
    for (MatchCondition item : items) {MatchConditionBuilder builder = new MatchConditionBuilder(item);_visitables.get("matchConditions").remove(builder); this.matchConditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromMatchConditions(Predicate<MatchConditionBuilder> predicate) {
    if (matchConditions == null) return (A) this;
    final Iterator<MatchConditionBuilder> each = matchConditions.iterator();
    final List visitables = _visitables.get("matchConditions");
    while (each.hasNext()) {
      MatchConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<MatchCondition> buildMatchConditions() {
    return matchConditions != null ? build(matchConditions) : null;
  }
  
  public MatchCondition buildMatchCondition(int index) {
    return this.matchConditions.get(index).build();
  }
  
  public MatchCondition buildFirstMatchCondition() {
    return this.matchConditions.get(0).build();
  }
  
  public MatchCondition buildLastMatchCondition() {
    return this.matchConditions.get(matchConditions.size() - 1).build();
  }
  
  public MatchCondition buildMatchingMatchCondition(Predicate<MatchConditionBuilder> predicate) {
    for (MatchConditionBuilder item: matchConditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingMatchCondition(Predicate<MatchConditionBuilder> predicate) {
    for (MatchConditionBuilder item: matchConditions) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withMatchConditions(List<MatchCondition> matchConditions) {
    if (this.matchConditions != null) { _visitables.get("matchConditions").clear();}
    if (matchConditions != null) {this.matchConditions = new ArrayList(); for (MatchCondition item : matchConditions){this.addToMatchConditions(item);}} else { this.matchConditions = null;} return (A) this;
  }
  
  public A withMatchConditions(io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.MatchCondition... matchConditions) {
    if (this.matchConditions != null) {this.matchConditions.clear(); _visitables.remove("matchConditions"); }
    if (matchConditions != null) {for (MatchCondition item :matchConditions){ this.addToMatchConditions(item);}} return (A) this;
  }
  
  public boolean hasMatchConditions() {
    return matchConditions != null && !matchConditions.isEmpty();
  }
  
  public A addNewMatchCondition(String expression,String name) {
    return (A)addToMatchConditions(new MatchCondition(expression, name));
  }
  
  public MatchConditionsNested<A> addNewMatchCondition() {
    return new MatchConditionsNested(-1, null);
  }
  
  public MatchConditionsNested<A> addNewMatchConditionLike(MatchCondition item) {
    return new MatchConditionsNested(-1, item);
  }
  
  public MatchConditionsNested<A> setNewMatchConditionLike(int index,MatchCondition item) {
    return new MatchConditionsNested(index, item);
  }
  
  public MatchConditionsNested<A> editMatchCondition(int index) {
    if (matchConditions.size() <= index) throw new RuntimeException("Can't edit matchConditions. Index exceeds size.");
    return setNewMatchConditionLike(index, buildMatchCondition(index));
  }
  
  public MatchConditionsNested<A> editFirstMatchCondition() {
    if (matchConditions.size() == 0) throw new RuntimeException("Can't edit first matchConditions. The list is empty.");
    return setNewMatchConditionLike(0, buildMatchCondition(0));
  }
  
  public MatchConditionsNested<A> editLastMatchCondition() {
    int index = matchConditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last matchConditions. The list is empty.");
    return setNewMatchConditionLike(index, buildMatchCondition(index));
  }
  
  public MatchConditionsNested<A> editMatchingMatchCondition(Predicate<MatchConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<matchConditions.size();i++) { 
    if (predicate.test(matchConditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching matchConditions. No match found.");
    return setNewMatchConditionLike(index, buildMatchCondition(index));
  }
  
  public MatchResources buildMatchConstraints() {
    return this.matchConstraints!=null ?this.matchConstraints.build():null;
  }
  
  public A withMatchConstraints(MatchResources matchConstraints) {
    _visitables.get("matchConstraints").remove(this.matchConstraints);
    if (matchConstraints!=null){ this.matchConstraints= new MatchResourcesBuilder(matchConstraints); _visitables.get("matchConstraints").add(this.matchConstraints);} else { this.matchConstraints = null; _visitables.get("matchConstraints").remove(this.matchConstraints); } return (A) this;
  }
  
  public boolean hasMatchConstraints() {
    return this.matchConstraints != null;
  }
  
  public MatchConstraintsNested<A> withNewMatchConstraints() {
    return new MatchConstraintsNested(null);
  }
  
  public MatchConstraintsNested<A> withNewMatchConstraintsLike(MatchResources item) {
    return new MatchConstraintsNested(item);
  }
  
  public MatchConstraintsNested<A> editMatchConstraints() {
    return withNewMatchConstraintsLike(java.util.Optional.ofNullable(buildMatchConstraints()).orElse(null));
  }
  
  public MatchConstraintsNested<A> editOrNewMatchConstraints() {
    return withNewMatchConstraintsLike(java.util.Optional.ofNullable(buildMatchConstraints()).orElse(new MatchResourcesBuilder().build()));
  }
  
  public MatchConstraintsNested<A> editOrNewMatchConstraintsLike(MatchResources item) {
    return withNewMatchConstraintsLike(java.util.Optional.ofNullable(buildMatchConstraints()).orElse(item));
  }
  
  public ParamKind buildParamKind() {
    return this.paramKind!=null ?this.paramKind.build():null;
  }
  
  public A withParamKind(ParamKind paramKind) {
    _visitables.get("paramKind").remove(this.paramKind);
    if (paramKind!=null){ this.paramKind= new ParamKindBuilder(paramKind); _visitables.get("paramKind").add(this.paramKind);} else { this.paramKind = null; _visitables.get("paramKind").remove(this.paramKind); } return (A) this;
  }
  
  public boolean hasParamKind() {
    return this.paramKind != null;
  }
  
  public A withNewParamKind(String apiVersion,String kind) {
    return (A)withParamKind(new ParamKind(apiVersion, kind));
  }
  
  public ParamKindNested<A> withNewParamKind() {
    return new ParamKindNested(null);
  }
  
  public ParamKindNested<A> withNewParamKindLike(ParamKind item) {
    return new ParamKindNested(item);
  }
  
  public ParamKindNested<A> editParamKind() {
    return withNewParamKindLike(java.util.Optional.ofNullable(buildParamKind()).orElse(null));
  }
  
  public ParamKindNested<A> editOrNewParamKind() {
    return withNewParamKindLike(java.util.Optional.ofNullable(buildParamKind()).orElse(new ParamKindBuilder().build()));
  }
  
  public ParamKindNested<A> editOrNewParamKindLike(ParamKind item) {
    return withNewParamKindLike(java.util.Optional.ofNullable(buildParamKind()).orElse(item));
  }
  
  public A addToValidations(int index,Validation item) {
    if (this.validations == null) {this.validations = new ArrayList<ValidationBuilder>();}
    ValidationBuilder builder = new ValidationBuilder(item);
    if (index < 0 || index >= validations.size()) { _visitables.get("validations").add(builder); validations.add(builder); } else { _visitables.get("validations").add(index, builder); validations.add(index, builder);}
    return (A)this;
  }
  
  public A setToValidations(int index,Validation item) {
    if (this.validations == null) {this.validations = new ArrayList<ValidationBuilder>();}
    ValidationBuilder builder = new ValidationBuilder(item);
    if (index < 0 || index >= validations.size()) { _visitables.get("validations").add(builder); validations.add(builder); } else { _visitables.get("validations").set(index, builder); validations.set(index, builder);}
    return (A)this;
  }
  
  public A addToValidations(io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.Validation... items) {
    if (this.validations == null) {this.validations = new ArrayList<ValidationBuilder>();}
    for (Validation item : items) {ValidationBuilder builder = new ValidationBuilder(item);_visitables.get("validations").add(builder);this.validations.add(builder);} return (A)this;
  }
  
  public A addAllToValidations(Collection<Validation> items) {
    if (this.validations == null) {this.validations = new ArrayList<ValidationBuilder>();}
    for (Validation item : items) {ValidationBuilder builder = new ValidationBuilder(item);_visitables.get("validations").add(builder);this.validations.add(builder);} return (A)this;
  }
  
  public A removeFromValidations(io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.Validation... items) {
    if (this.validations == null) return (A)this;
    for (Validation item : items) {ValidationBuilder builder = new ValidationBuilder(item);_visitables.get("validations").remove(builder); this.validations.remove(builder);} return (A)this;
  }
  
  public A removeAllFromValidations(Collection<Validation> items) {
    if (this.validations == null) return (A)this;
    for (Validation item : items) {ValidationBuilder builder = new ValidationBuilder(item);_visitables.get("validations").remove(builder); this.validations.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromValidations(Predicate<ValidationBuilder> predicate) {
    if (validations == null) return (A) this;
    final Iterator<ValidationBuilder> each = validations.iterator();
    final List visitables = _visitables.get("validations");
    while (each.hasNext()) {
      ValidationBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Validation> buildValidations() {
    return validations != null ? build(validations) : null;
  }
  
  public Validation buildValidation(int index) {
    return this.validations.get(index).build();
  }
  
  public Validation buildFirstValidation() {
    return this.validations.get(0).build();
  }
  
  public Validation buildLastValidation() {
    return this.validations.get(validations.size() - 1).build();
  }
  
  public Validation buildMatchingValidation(Predicate<ValidationBuilder> predicate) {
    for (ValidationBuilder item: validations) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingValidation(Predicate<ValidationBuilder> predicate) {
    for (ValidationBuilder item: validations) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withValidations(List<Validation> validations) {
    if (this.validations != null) { _visitables.get("validations").clear();}
    if (validations != null) {this.validations = new ArrayList(); for (Validation item : validations){this.addToValidations(item);}} else { this.validations = null;} return (A) this;
  }
  
  public A withValidations(io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.Validation... validations) {
    if (this.validations != null) {this.validations.clear(); _visitables.remove("validations"); }
    if (validations != null) {for (Validation item :validations){ this.addToValidations(item);}} return (A) this;
  }
  
  public boolean hasValidations() {
    return validations != null && !validations.isEmpty();
  }
  
  public A addNewValidation(String expression,String message,String messageExpression,String reason) {
    return (A)addToValidations(new Validation(expression, message, messageExpression, reason));
  }
  
  public ValidationsNested<A> addNewValidation() {
    return new ValidationsNested(-1, null);
  }
  
  public ValidationsNested<A> addNewValidationLike(Validation item) {
    return new ValidationsNested(-1, item);
  }
  
  public ValidationsNested<A> setNewValidationLike(int index,Validation item) {
    return new ValidationsNested(index, item);
  }
  
  public ValidationsNested<A> editValidation(int index) {
    if (validations.size() <= index) throw new RuntimeException("Can't edit validations. Index exceeds size.");
    return setNewValidationLike(index, buildValidation(index));
  }
  
  public ValidationsNested<A> editFirstValidation() {
    if (validations.size() == 0) throw new RuntimeException("Can't edit first validations. The list is empty.");
    return setNewValidationLike(0, buildValidation(0));
  }
  
  public ValidationsNested<A> editLastValidation() {
    int index = validations.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last validations. The list is empty.");
    return setNewValidationLike(index, buildValidation(index));
  }
  
  public ValidationsNested<A> editMatchingValidation(Predicate<ValidationBuilder> predicate) {
    int index = -1;
    for (int i=0;i<validations.size();i++) { 
    if (predicate.test(validations.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching validations. No match found.");
    return setNewValidationLike(index, buildValidation(index));
  }
  
  public A addToVariables(int index,Variable item) {
    if (this.variables == null) {this.variables = new ArrayList<VariableBuilder>();}
    VariableBuilder builder = new VariableBuilder(item);
    if (index < 0 || index >= variables.size()) { _visitables.get("variables").add(builder); variables.add(builder); } else { _visitables.get("variables").add(index, builder); variables.add(index, builder);}
    return (A)this;
  }
  
  public A setToVariables(int index,Variable item) {
    if (this.variables == null) {this.variables = new ArrayList<VariableBuilder>();}
    VariableBuilder builder = new VariableBuilder(item);
    if (index < 0 || index >= variables.size()) { _visitables.get("variables").add(builder); variables.add(builder); } else { _visitables.get("variables").set(index, builder); variables.set(index, builder);}
    return (A)this;
  }
  
  public A addToVariables(io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.Variable... items) {
    if (this.variables == null) {this.variables = new ArrayList<VariableBuilder>();}
    for (Variable item : items) {VariableBuilder builder = new VariableBuilder(item);_visitables.get("variables").add(builder);this.variables.add(builder);} return (A)this;
  }
  
  public A addAllToVariables(Collection<Variable> items) {
    if (this.variables == null) {this.variables = new ArrayList<VariableBuilder>();}
    for (Variable item : items) {VariableBuilder builder = new VariableBuilder(item);_visitables.get("variables").add(builder);this.variables.add(builder);} return (A)this;
  }
  
  public A removeFromVariables(io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.Variable... items) {
    if (this.variables == null) return (A)this;
    for (Variable item : items) {VariableBuilder builder = new VariableBuilder(item);_visitables.get("variables").remove(builder); this.variables.remove(builder);} return (A)this;
  }
  
  public A removeAllFromVariables(Collection<Variable> items) {
    if (this.variables == null) return (A)this;
    for (Variable item : items) {VariableBuilder builder = new VariableBuilder(item);_visitables.get("variables").remove(builder); this.variables.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromVariables(Predicate<VariableBuilder> predicate) {
    if (variables == null) return (A) this;
    final Iterator<VariableBuilder> each = variables.iterator();
    final List visitables = _visitables.get("variables");
    while (each.hasNext()) {
      VariableBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Variable> buildVariables() {
    return variables != null ? build(variables) : null;
  }
  
  public Variable buildVariable(int index) {
    return this.variables.get(index).build();
  }
  
  public Variable buildFirstVariable() {
    return this.variables.get(0).build();
  }
  
  public Variable buildLastVariable() {
    return this.variables.get(variables.size() - 1).build();
  }
  
  public Variable buildMatchingVariable(Predicate<VariableBuilder> predicate) {
    for (VariableBuilder item: variables) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingVariable(Predicate<VariableBuilder> predicate) {
    for (VariableBuilder item: variables) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withVariables(List<Variable> variables) {
    if (this.variables != null) { _visitables.get("variables").clear();}
    if (variables != null) {this.variables = new ArrayList(); for (Variable item : variables){this.addToVariables(item);}} else { this.variables = null;} return (A) this;
  }
  
  public A withVariables(io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.Variable... variables) {
    if (this.variables != null) {this.variables.clear(); _visitables.remove("variables"); }
    if (variables != null) {for (Variable item :variables){ this.addToVariables(item);}} return (A) this;
  }
  
  public boolean hasVariables() {
    return variables != null && !variables.isEmpty();
  }
  
  public A addNewVariable(String expression,String name) {
    return (A)addToVariables(new Variable(expression, name));
  }
  
  public VariablesNested<A> addNewVariable() {
    return new VariablesNested(-1, null);
  }
  
  public VariablesNested<A> addNewVariableLike(Variable item) {
    return new VariablesNested(-1, item);
  }
  
  public VariablesNested<A> setNewVariableLike(int index,Variable item) {
    return new VariablesNested(index, item);
  }
  
  public VariablesNested<A> editVariable(int index) {
    if (variables.size() <= index) throw new RuntimeException("Can't edit variables. Index exceeds size.");
    return setNewVariableLike(index, buildVariable(index));
  }
  
  public VariablesNested<A> editFirstVariable() {
    if (variables.size() == 0) throw new RuntimeException("Can't edit first variables. The list is empty.");
    return setNewVariableLike(0, buildVariable(0));
  }
  
  public VariablesNested<A> editLastVariable() {
    int index = variables.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last variables. The list is empty.");
    return setNewVariableLike(index, buildVariable(index));
  }
  
  public VariablesNested<A> editMatchingVariable(Predicate<VariableBuilder> predicate) {
    int index = -1;
    for (int i=0;i<variables.size();i++) { 
    if (predicate.test(variables.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching variables. No match found.");
    return setNewVariableLike(index, buildVariable(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ValidatingAdmissionPolicySpecFluent that = (ValidatingAdmissionPolicySpecFluent) o;
    if (!java.util.Objects.equals(auditAnnotations, that.auditAnnotations)) return false;
  
    if (!java.util.Objects.equals(failurePolicy, that.failurePolicy)) return false;
  
    if (!java.util.Objects.equals(matchConditions, that.matchConditions)) return false;
  
    if (!java.util.Objects.equals(matchConstraints, that.matchConstraints)) return false;
  
    if (!java.util.Objects.equals(paramKind, that.paramKind)) return false;
  
    if (!java.util.Objects.equals(validations, that.validations)) return false;
  
    if (!java.util.Objects.equals(variables, that.variables)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(auditAnnotations,  failurePolicy,  matchConditions,  matchConstraints,  paramKind,  validations,  variables,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (auditAnnotations != null && !auditAnnotations.isEmpty()) { sb.append("auditAnnotations:"); sb.append(auditAnnotations + ","); }
    if (failurePolicy != null) { sb.append("failurePolicy:"); sb.append(failurePolicy + ","); }
    if (matchConditions != null && !matchConditions.isEmpty()) { sb.append("matchConditions:"); sb.append(matchConditions + ","); }
    if (matchConstraints != null) { sb.append("matchConstraints:"); sb.append(matchConstraints + ","); }
    if (paramKind != null) { sb.append("paramKind:"); sb.append(paramKind + ","); }
    if (validations != null && !validations.isEmpty()) { sb.append("validations:"); sb.append(validations + ","); }
    if (variables != null && !variables.isEmpty()) { sb.append("variables:"); sb.append(variables + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AuditAnnotationsNested<N> extends AuditAnnotationFluent<AuditAnnotationsNested<N>> implements Nested<N>{
    AuditAnnotationsNested(int index,AuditAnnotation item) {
      this.index = index;
      this.builder = new AuditAnnotationBuilder(this, item);
    }
    AuditAnnotationBuilder builder;
    int index;
    
    public N and() {
      return (N) ValidatingAdmissionPolicySpecFluent.this.setToAuditAnnotations(index,builder.build());
    }
    
    public N endAuditAnnotation() {
      return and();
    }
    
  
  }
  public class MatchConditionsNested<N> extends MatchConditionFluent<MatchConditionsNested<N>> implements Nested<N>{
    MatchConditionsNested(int index,MatchCondition item) {
      this.index = index;
      this.builder = new MatchConditionBuilder(this, item);
    }
    MatchConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) ValidatingAdmissionPolicySpecFluent.this.setToMatchConditions(index,builder.build());
    }
    
    public N endMatchCondition() {
      return and();
    }
    
  
  }
  public class MatchConstraintsNested<N> extends MatchResourcesFluent<MatchConstraintsNested<N>> implements Nested<N>{
    MatchConstraintsNested(MatchResources item) {
      this.builder = new MatchResourcesBuilder(this, item);
    }
    MatchResourcesBuilder builder;
    
    public N and() {
      return (N) ValidatingAdmissionPolicySpecFluent.this.withMatchConstraints(builder.build());
    }
    
    public N endMatchConstraints() {
      return and();
    }
    
  
  }
  public class ParamKindNested<N> extends ParamKindFluent<ParamKindNested<N>> implements Nested<N>{
    ParamKindNested(ParamKind item) {
      this.builder = new ParamKindBuilder(this, item);
    }
    ParamKindBuilder builder;
    
    public N and() {
      return (N) ValidatingAdmissionPolicySpecFluent.this.withParamKind(builder.build());
    }
    
    public N endParamKind() {
      return and();
    }
    
  
  }
  public class ValidationsNested<N> extends ValidationFluent<ValidationsNested<N>> implements Nested<N>{
    ValidationsNested(int index,Validation item) {
      this.index = index;
      this.builder = new ValidationBuilder(this, item);
    }
    ValidationBuilder builder;
    int index;
    
    public N and() {
      return (N) ValidatingAdmissionPolicySpecFluent.this.setToValidations(index,builder.build());
    }
    
    public N endValidation() {
      return and();
    }
    
  
  }
  public class VariablesNested<N> extends VariableFluent<VariablesNested<N>> implements Nested<N>{
    VariablesNested(int index,Variable item) {
      this.index = index;
      this.builder = new VariableBuilder(this, item);
    }
    VariableBuilder builder;
    int index;
    
    public N and() {
      return (N) ValidatingAdmissionPolicySpecFluent.this.setToVariables(index,builder.build());
    }
    
    public N endVariable() {
      return and();
    }
    
  
  }

}