package io.fabric8.kubernetes.api.model.admissionregistration.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations;
import io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperationsFluent;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperationsBuilder;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MutatingWebhookFluent<A extends MutatingWebhookFluent<A>> extends BaseFluent<A>{
  public MutatingWebhookFluent() {
  }
  
  public MutatingWebhookFluent(MutatingWebhook instance) {
    this.copyInstance(instance);
  }
  private List<String> admissionReviewVersions = new ArrayList<String>();
  private WebhookClientConfigBuilder clientConfig;
  private String failurePolicy;
  private ArrayList<MatchConditionBuilder> matchConditions = new ArrayList<MatchConditionBuilder>();
  private String matchPolicy;
  private String name;
  private LabelSelectorBuilder namespaceSelector;
  private LabelSelectorBuilder objectSelector;
  private String reinvocationPolicy;
  private ArrayList<RuleWithOperationsBuilder> rules = new ArrayList<RuleWithOperationsBuilder>();
  private String sideEffects;
  private Integer timeoutSeconds;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MutatingWebhook instance) {
    instance = (instance != null ? instance : new MutatingWebhook());
  
    if (instance != null) {
        this.withAdmissionReviewVersions(instance.getAdmissionReviewVersions());
        this.withClientConfig(instance.getClientConfig());
        this.withFailurePolicy(instance.getFailurePolicy());
        this.withMatchConditions(instance.getMatchConditions());
        this.withMatchPolicy(instance.getMatchPolicy());
        this.withName(instance.getName());
        this.withNamespaceSelector(instance.getNamespaceSelector());
        this.withObjectSelector(instance.getObjectSelector());
        this.withReinvocationPolicy(instance.getReinvocationPolicy());
        this.withRules(instance.getRules());
        this.withSideEffects(instance.getSideEffects());
        this.withTimeoutSeconds(instance.getTimeoutSeconds());
        this.withAdmissionReviewVersions(instance.getAdmissionReviewVersions());
        this.withClientConfig(instance.getClientConfig());
        this.withFailurePolicy(instance.getFailurePolicy());
        this.withMatchConditions(instance.getMatchConditions());
        this.withMatchPolicy(instance.getMatchPolicy());
        this.withName(instance.getName());
        this.withNamespaceSelector(instance.getNamespaceSelector());
        this.withObjectSelector(instance.getObjectSelector());
        this.withReinvocationPolicy(instance.getReinvocationPolicy());
        this.withRules(instance.getRules());
        this.withSideEffects(instance.getSideEffects());
        this.withTimeoutSeconds(instance.getTimeoutSeconds());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public A addToAdmissionReviewVersions(int index,String item) {
    if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
    this.admissionReviewVersions.add(index, item);
    return (A)this;
  }
  
  public A setToAdmissionReviewVersions(int index,String item) {
    if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
    this.admissionReviewVersions.set(index, item); return (A)this;
  }
  
  public A addToAdmissionReviewVersions(java.lang.String... items) {
    if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
    for (String item : items) {this.admissionReviewVersions.add(item);} return (A)this;
  }
  
  public A addAllToAdmissionReviewVersions(Collection<String> items) {
    if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
    for (String item : items) {this.admissionReviewVersions.add(item);} return (A)this;
  }
  
  public A removeFromAdmissionReviewVersions(java.lang.String... items) {
    if (this.admissionReviewVersions == null) return (A)this;
    for (String item : items) { this.admissionReviewVersions.remove(item);} return (A)this;
  }
  
  public A removeAllFromAdmissionReviewVersions(Collection<String> items) {
    if (this.admissionReviewVersions == null) return (A)this;
    for (String item : items) { this.admissionReviewVersions.remove(item);} return (A)this;
  }
  
  public List<String> getAdmissionReviewVersions() {
    return this.admissionReviewVersions;
  }
  
  public String getAdmissionReviewVersion(int index) {
    return this.admissionReviewVersions.get(index);
  }
  
  public String getFirstAdmissionReviewVersion() {
    return this.admissionReviewVersions.get(0);
  }
  
  public String getLastAdmissionReviewVersion() {
    return this.admissionReviewVersions.get(admissionReviewVersions.size() - 1);
  }
  
  public String getMatchingAdmissionReviewVersion(Predicate<String> predicate) {
    for (String item: admissionReviewVersions) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingAdmissionReviewVersion(Predicate<String> predicate) {
    for (String item: admissionReviewVersions) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withAdmissionReviewVersions(List<String> admissionReviewVersions) {
    if (admissionReviewVersions != null) {this.admissionReviewVersions = new ArrayList(); for (String item : admissionReviewVersions){this.addToAdmissionReviewVersions(item);}} else { this.admissionReviewVersions = null;} return (A) this;
  }
  
  public A withAdmissionReviewVersions(java.lang.String... admissionReviewVersions) {
    if (this.admissionReviewVersions != null) {this.admissionReviewVersions.clear(); _visitables.remove("admissionReviewVersions"); }
    if (admissionReviewVersions != null) {for (String item :admissionReviewVersions){ this.addToAdmissionReviewVersions(item);}} return (A) this;
  }
  
  public boolean hasAdmissionReviewVersions() {
    return admissionReviewVersions != null && !admissionReviewVersions.isEmpty();
  }
  
  public WebhookClientConfig buildClientConfig() {
    return this.clientConfig!=null ?this.clientConfig.build():null;
  }
  
  public A withClientConfig(WebhookClientConfig clientConfig) {
    _visitables.get("clientConfig").remove(this.clientConfig);
    if (clientConfig!=null){ this.clientConfig= new WebhookClientConfigBuilder(clientConfig); _visitables.get("clientConfig").add(this.clientConfig);} else { this.clientConfig = null; _visitables.get("clientConfig").remove(this.clientConfig); } return (A) this;
  }
  
  public boolean hasClientConfig() {
    return this.clientConfig != null;
  }
  
  public ClientConfigNested<A> withNewClientConfig() {
    return new ClientConfigNested(null);
  }
  
  public ClientConfigNested<A> withNewClientConfigLike(WebhookClientConfig item) {
    return new ClientConfigNested(item);
  }
  
  public ClientConfigNested<A> editClientConfig() {
    return withNewClientConfigLike(java.util.Optional.ofNullable(buildClientConfig()).orElse(null));
  }
  
  public ClientConfigNested<A> editOrNewClientConfig() {
    return withNewClientConfigLike(java.util.Optional.ofNullable(buildClientConfig()).orElse(new WebhookClientConfigBuilder().build()));
  }
  
  public ClientConfigNested<A> editOrNewClientConfigLike(WebhookClientConfig item) {
    return withNewClientConfigLike(java.util.Optional.ofNullable(buildClientConfig()).orElse(item));
  }
  
  public String getFailurePolicy() {
    return this.failurePolicy;
  }
  
  public A withFailurePolicy(String failurePolicy) {
    this.failurePolicy=failurePolicy; return (A) this;
  }
  
  public boolean hasFailurePolicy() {
    return this.failurePolicy != null;
  }
  
  public A addToMatchConditions(int index,MatchCondition item) {
    if (this.matchConditions == null) {this.matchConditions = new ArrayList<MatchConditionBuilder>();}
    MatchConditionBuilder builder = new MatchConditionBuilder(item);
    if (index < 0 || index >= matchConditions.size()) { _visitables.get("matchConditions").add(builder); matchConditions.add(builder); } else { _visitables.get("matchConditions").add(index, builder); matchConditions.add(index, builder);}
    return (A)this;
  }
  
  public A setToMatchConditions(int index,MatchCondition item) {
    if (this.matchConditions == null) {this.matchConditions = new ArrayList<MatchConditionBuilder>();}
    MatchConditionBuilder builder = new MatchConditionBuilder(item);
    if (index < 0 || index >= matchConditions.size()) { _visitables.get("matchConditions").add(builder); matchConditions.add(builder); } else { _visitables.get("matchConditions").set(index, builder); matchConditions.set(index, builder);}
    return (A)this;
  }
  
  public A addToMatchConditions(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MatchCondition... items) {
    if (this.matchConditions == null) {this.matchConditions = new ArrayList<MatchConditionBuilder>();}
    for (MatchCondition item : items) {MatchConditionBuilder builder = new MatchConditionBuilder(item);_visitables.get("matchConditions").add(builder);this.matchConditions.add(builder);} return (A)this;
  }
  
  public A addAllToMatchConditions(Collection<MatchCondition> items) {
    if (this.matchConditions == null) {this.matchConditions = new ArrayList<MatchConditionBuilder>();}
    for (MatchCondition item : items) {MatchConditionBuilder builder = new MatchConditionBuilder(item);_visitables.get("matchConditions").add(builder);this.matchConditions.add(builder);} return (A)this;
  }
  
  public A removeFromMatchConditions(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MatchCondition... items) {
    if (this.matchConditions == null) return (A)this;
    for (MatchCondition item : items) {MatchConditionBuilder builder = new MatchConditionBuilder(item);_visitables.get("matchConditions").remove(builder); this.matchConditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromMatchConditions(Collection<MatchCondition> items) {
    if (this.matchConditions == null) return (A)this;
    for (MatchCondition item : items) {MatchConditionBuilder builder = new MatchConditionBuilder(item);_visitables.get("matchConditions").remove(builder); this.matchConditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromMatchConditions(Predicate<MatchConditionBuilder> predicate) {
    if (matchConditions == null) return (A) this;
    final Iterator<MatchConditionBuilder> each = matchConditions.iterator();
    final List visitables = _visitables.get("matchConditions");
    while (each.hasNext()) {
      MatchConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<MatchCondition> buildMatchConditions() {
    return matchConditions != null ? build(matchConditions) : null;
  }
  
  public MatchCondition buildMatchCondition(int index) {
    return this.matchConditions.get(index).build();
  }
  
  public MatchCondition buildFirstMatchCondition() {
    return this.matchConditions.get(0).build();
  }
  
  public MatchCondition buildLastMatchCondition() {
    return this.matchConditions.get(matchConditions.size() - 1).build();
  }
  
  public MatchCondition buildMatchingMatchCondition(Predicate<MatchConditionBuilder> predicate) {
    for (MatchConditionBuilder item: matchConditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingMatchCondition(Predicate<MatchConditionBuilder> predicate) {
    for (MatchConditionBuilder item: matchConditions) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withMatchConditions(List<MatchCondition> matchConditions) {
    if (this.matchConditions != null) { _visitables.get("matchConditions").clear();}
    if (matchConditions != null) {this.matchConditions = new ArrayList(); for (MatchCondition item : matchConditions){this.addToMatchConditions(item);}} else { this.matchConditions = null;} return (A) this;
  }
  
  public A withMatchConditions(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.MatchCondition... matchConditions) {
    if (this.matchConditions != null) {this.matchConditions.clear(); _visitables.remove("matchConditions"); }
    if (matchConditions != null) {for (MatchCondition item :matchConditions){ this.addToMatchConditions(item);}} return (A) this;
  }
  
  public boolean hasMatchConditions() {
    return matchConditions != null && !matchConditions.isEmpty();
  }
  
  public A addNewMatchCondition(String expression,String name) {
    return (A)addToMatchConditions(new MatchCondition(expression, name));
  }
  
  public MatchConditionsNested<A> addNewMatchCondition() {
    return new MatchConditionsNested(-1, null);
  }
  
  public MatchConditionsNested<A> addNewMatchConditionLike(MatchCondition item) {
    return new MatchConditionsNested(-1, item);
  }
  
  public MatchConditionsNested<A> setNewMatchConditionLike(int index,MatchCondition item) {
    return new MatchConditionsNested(index, item);
  }
  
  public MatchConditionsNested<A> editMatchCondition(int index) {
    if (matchConditions.size() <= index) throw new RuntimeException("Can't edit matchConditions. Index exceeds size.");
    return setNewMatchConditionLike(index, buildMatchCondition(index));
  }
  
  public MatchConditionsNested<A> editFirstMatchCondition() {
    if (matchConditions.size() == 0) throw new RuntimeException("Can't edit first matchConditions. The list is empty.");
    return setNewMatchConditionLike(0, buildMatchCondition(0));
  }
  
  public MatchConditionsNested<A> editLastMatchCondition() {
    int index = matchConditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last matchConditions. The list is empty.");
    return setNewMatchConditionLike(index, buildMatchCondition(index));
  }
  
  public MatchConditionsNested<A> editMatchingMatchCondition(Predicate<MatchConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<matchConditions.size();i++) { 
    if (predicate.test(matchConditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching matchConditions. No match found.");
    return setNewMatchConditionLike(index, buildMatchCondition(index));
  }
  
  public String getMatchPolicy() {
    return this.matchPolicy;
  }
  
  public A withMatchPolicy(String matchPolicy) {
    this.matchPolicy=matchPolicy; return (A) this;
  }
  
  public boolean hasMatchPolicy() {
    return this.matchPolicy != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public LabelSelector buildNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  
  public A withNamespaceSelector(LabelSelector namespaceSelector) {
    _visitables.get("namespaceSelector").remove(this.namespaceSelector);
    if (namespaceSelector!=null){ this.namespaceSelector= new LabelSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} else { this.namespaceSelector = null; _visitables.get("namespaceSelector").remove(this.namespaceSelector); } return (A) this;
  }
  
  public boolean hasNamespaceSelector() {
    return this.namespaceSelector != null;
  }
  
  public NamespaceSelectorNested<A> withNewNamespaceSelector() {
    return new NamespaceSelectorNested(null);
  }
  
  public NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
    return new NamespaceSelectorNested(item);
  }
  
  public NamespaceSelectorNested<A> editNamespaceSelector() {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(null));
  }
  
  public NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(item));
  }
  
  public LabelSelector buildObjectSelector() {
    return this.objectSelector!=null ?this.objectSelector.build():null;
  }
  
  public A withObjectSelector(LabelSelector objectSelector) {
    _visitables.get("objectSelector").remove(this.objectSelector);
    if (objectSelector!=null){ this.objectSelector= new LabelSelectorBuilder(objectSelector); _visitables.get("objectSelector").add(this.objectSelector);} else { this.objectSelector = null; _visitables.get("objectSelector").remove(this.objectSelector); } return (A) this;
  }
  
  public boolean hasObjectSelector() {
    return this.objectSelector != null;
  }
  
  public ObjectSelectorNested<A> withNewObjectSelector() {
    return new ObjectSelectorNested(null);
  }
  
  public ObjectSelectorNested<A> withNewObjectSelectorLike(LabelSelector item) {
    return new ObjectSelectorNested(item);
  }
  
  public ObjectSelectorNested<A> editObjectSelector() {
    return withNewObjectSelectorLike(java.util.Optional.ofNullable(buildObjectSelector()).orElse(null));
  }
  
  public ObjectSelectorNested<A> editOrNewObjectSelector() {
    return withNewObjectSelectorLike(java.util.Optional.ofNullable(buildObjectSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public ObjectSelectorNested<A> editOrNewObjectSelectorLike(LabelSelector item) {
    return withNewObjectSelectorLike(java.util.Optional.ofNullable(buildObjectSelector()).orElse(item));
  }
  
  public String getReinvocationPolicy() {
    return this.reinvocationPolicy;
  }
  
  public A withReinvocationPolicy(String reinvocationPolicy) {
    this.reinvocationPolicy=reinvocationPolicy; return (A) this;
  }
  
  public boolean hasReinvocationPolicy() {
    return this.reinvocationPolicy != null;
  }
  
  public A addToRules(int index,RuleWithOperations item) {
    if (this.rules == null) {this.rules = new ArrayList<RuleWithOperationsBuilder>();}
    RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);
    if (index < 0 || index >= rules.size()) { _visitables.get("rules").add(builder); rules.add(builder); } else { _visitables.get("rules").add(index, builder); rules.add(index, builder);}
    return (A)this;
  }
  
  public A setToRules(int index,RuleWithOperations item) {
    if (this.rules == null) {this.rules = new ArrayList<RuleWithOperationsBuilder>();}
    RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);
    if (index < 0 || index >= rules.size()) { _visitables.get("rules").add(builder); rules.add(builder); } else { _visitables.get("rules").set(index, builder); rules.set(index, builder);}
    return (A)this;
  }
  
  public A addToRules(io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations... items) {
    if (this.rules == null) {this.rules = new ArrayList<RuleWithOperationsBuilder>();}
    for (RuleWithOperations item : items) {RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  
  public A addAllToRules(Collection<RuleWithOperations> items) {
    if (this.rules == null) {this.rules = new ArrayList<RuleWithOperationsBuilder>();}
    for (RuleWithOperations item : items) {RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  
  public A removeFromRules(io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations... items) {
    if (this.rules == null) return (A)this;
    for (RuleWithOperations item : items) {RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);_visitables.get("rules").remove(builder); this.rules.remove(builder);} return (A)this;
  }
  
  public A removeAllFromRules(Collection<RuleWithOperations> items) {
    if (this.rules == null) return (A)this;
    for (RuleWithOperations item : items) {RuleWithOperationsBuilder builder = new RuleWithOperationsBuilder(item);_visitables.get("rules").remove(builder); this.rules.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromRules(Predicate<RuleWithOperationsBuilder> predicate) {
    if (rules == null) return (A) this;
    final Iterator<RuleWithOperationsBuilder> each = rules.iterator();
    final List visitables = _visitables.get("rules");
    while (each.hasNext()) {
      RuleWithOperationsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<RuleWithOperations> buildRules() {
    return rules != null ? build(rules) : null;
  }
  
  public RuleWithOperations buildRule(int index) {
    return this.rules.get(index).build();
  }
  
  public RuleWithOperations buildFirstRule() {
    return this.rules.get(0).build();
  }
  
  public RuleWithOperations buildLastRule() {
    return this.rules.get(rules.size() - 1).build();
  }
  
  public RuleWithOperations buildMatchingRule(Predicate<RuleWithOperationsBuilder> predicate) {
    for (RuleWithOperationsBuilder item: rules) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingRule(Predicate<RuleWithOperationsBuilder> predicate) {
    for (RuleWithOperationsBuilder item: rules) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withRules(List<RuleWithOperations> rules) {
    if (this.rules != null) { _visitables.get("rules").clear();}
    if (rules != null) {this.rules = new ArrayList(); for (RuleWithOperations item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
  }
  
  public A withRules(io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations... rules) {
    if (this.rules != null) {this.rules.clear(); _visitables.remove("rules"); }
    if (rules != null) {for (RuleWithOperations item :rules){ this.addToRules(item);}} return (A) this;
  }
  
  public boolean hasRules() {
    return rules != null && !rules.isEmpty();
  }
  
  public RulesNested<A> addNewRule() {
    return new RulesNested(-1, null);
  }
  
  public RulesNested<A> addNewRuleLike(RuleWithOperations item) {
    return new RulesNested(-1, item);
  }
  
  public RulesNested<A> setNewRuleLike(int index,RuleWithOperations item) {
    return new RulesNested(index, item);
  }
  
  public RulesNested<A> editRule(int index) {
    if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
    return setNewRuleLike(index, buildRule(index));
  }
  
  public RulesNested<A> editFirstRule() {
    if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
    return setNewRuleLike(0, buildRule(0));
  }
  
  public RulesNested<A> editLastRule() {
    int index = rules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
    return setNewRuleLike(index, buildRule(index));
  }
  
  public RulesNested<A> editMatchingRule(Predicate<RuleWithOperationsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<rules.size();i++) { 
    if (predicate.test(rules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
    return setNewRuleLike(index, buildRule(index));
  }
  
  public String getSideEffects() {
    return this.sideEffects;
  }
  
  public A withSideEffects(String sideEffects) {
    this.sideEffects=sideEffects; return (A) this;
  }
  
  public boolean hasSideEffects() {
    return this.sideEffects != null;
  }
  
  public Integer getTimeoutSeconds() {
    return this.timeoutSeconds;
  }
  
  public A withTimeoutSeconds(Integer timeoutSeconds) {
    this.timeoutSeconds=timeoutSeconds; return (A) this;
  }
  
  public boolean hasTimeoutSeconds() {
    return this.timeoutSeconds != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MutatingWebhookFluent that = (MutatingWebhookFluent) o;
    if (!java.util.Objects.equals(admissionReviewVersions, that.admissionReviewVersions)) return false;
  
    if (!java.util.Objects.equals(clientConfig, that.clientConfig)) return false;
  
    if (!java.util.Objects.equals(failurePolicy, that.failurePolicy)) return false;
  
    if (!java.util.Objects.equals(matchConditions, that.matchConditions)) return false;
  
    if (!java.util.Objects.equals(matchPolicy, that.matchPolicy)) return false;
  
    if (!java.util.Objects.equals(name, that.name)) return false;
  
    if (!java.util.Objects.equals(namespaceSelector, that.namespaceSelector)) return false;
  
    if (!java.util.Objects.equals(objectSelector, that.objectSelector)) return false;
  
    if (!java.util.Objects.equals(reinvocationPolicy, that.reinvocationPolicy)) return false;
  
    if (!java.util.Objects.equals(rules, that.rules)) return false;
  
    if (!java.util.Objects.equals(sideEffects, that.sideEffects)) return false;
  
    if (!java.util.Objects.equals(timeoutSeconds, that.timeoutSeconds)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(admissionReviewVersions,  clientConfig,  failurePolicy,  matchConditions,  matchPolicy,  name,  namespaceSelector,  objectSelector,  reinvocationPolicy,  rules,  sideEffects,  timeoutSeconds,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (admissionReviewVersions != null && !admissionReviewVersions.isEmpty()) { sb.append("admissionReviewVersions:"); sb.append(admissionReviewVersions + ","); }
    if (clientConfig != null) { sb.append("clientConfig:"); sb.append(clientConfig + ","); }
    if (failurePolicy != null) { sb.append("failurePolicy:"); sb.append(failurePolicy + ","); }
    if (matchConditions != null && !matchConditions.isEmpty()) { sb.append("matchConditions:"); sb.append(matchConditions + ","); }
    if (matchPolicy != null) { sb.append("matchPolicy:"); sb.append(matchPolicy + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (namespaceSelector != null) { sb.append("namespaceSelector:"); sb.append(namespaceSelector + ","); }
    if (objectSelector != null) { sb.append("objectSelector:"); sb.append(objectSelector + ","); }
    if (reinvocationPolicy != null) { sb.append("reinvocationPolicy:"); sb.append(reinvocationPolicy + ","); }
    if (rules != null && !rules.isEmpty()) { sb.append("rules:"); sb.append(rules + ","); }
    if (sideEffects != null) { sb.append("sideEffects:"); sb.append(sideEffects + ","); }
    if (timeoutSeconds != null) { sb.append("timeoutSeconds:"); sb.append(timeoutSeconds + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClientConfigNested<N> extends WebhookClientConfigFluent<ClientConfigNested<N>> implements Nested<N>{
    ClientConfigNested(WebhookClientConfig item) {
      this.builder = new WebhookClientConfigBuilder(this, item);
    }
    WebhookClientConfigBuilder builder;
    
    public N and() {
      return (N) MutatingWebhookFluent.this.withClientConfig(builder.build());
    }
    
    public N endClientConfig() {
      return and();
    }
    
  
  }
  public class MatchConditionsNested<N> extends MatchConditionFluent<MatchConditionsNested<N>> implements Nested<N>{
    MatchConditionsNested(int index,MatchCondition item) {
      this.index = index;
      this.builder = new MatchConditionBuilder(this, item);
    }
    MatchConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) MutatingWebhookFluent.this.setToMatchConditions(index,builder.build());
    }
    
    public N endMatchCondition() {
      return and();
    }
    
  
  }
  public class NamespaceSelectorNested<N> extends LabelSelectorFluent<NamespaceSelectorNested<N>> implements Nested<N>{
    NamespaceSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) MutatingWebhookFluent.this.withNamespaceSelector(builder.build());
    }
    
    public N endNamespaceSelector() {
      return and();
    }
    
  
  }
  public class ObjectSelectorNested<N> extends LabelSelectorFluent<ObjectSelectorNested<N>> implements Nested<N>{
    ObjectSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) MutatingWebhookFluent.this.withObjectSelector(builder.build());
    }
    
    public N endObjectSelector() {
      return and();
    }
    
  
  }
  public class RulesNested<N> extends RuleWithOperationsFluent<RulesNested<N>> implements Nested<N>{
    RulesNested(int index,RuleWithOperations item) {
      this.index = index;
      this.builder = new RuleWithOperationsBuilder(this, item);
    }
    RuleWithOperationsBuilder builder;
    int index;
    
    public N and() {
      return (N) MutatingWebhookFluent.this.setToRules(index,builder.build());
    }
    
    public N endRule() {
      return and();
    }
    
  
  }

}